/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.ChatBaseComponent;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.network.chat.IChatMutableComponent;

public class ChatComponentKeybind
extends ChatBaseComponent {
    private static Function<String, Supplier<IChatBaseComponent>> keyResolver = var0 -> () -> new ChatComponentText((String)var0);
    private final String name;
    private Supplier<IChatBaseComponent> nameResolver;

    public ChatComponentKeybind(String var0) {
        this.name = var0;
    }

    public static void setKeyResolver(Function<String, Supplier<IChatBaseComponent>> var0) {
        keyResolver = var0;
    }

    private IChatBaseComponent getNestedComponent() {
        if (this.nameResolver == null) {
            this.nameResolver = keyResolver.apply(this.name);
        }
        return this.nameResolver.get();
    }

    @Override
    public <T> Optional<T> visitSelf(IChatFormatted.a<T> var0) {
        return this.getNestedComponent().visit(var0);
    }

    @Override
    public <T> Optional<T> visitSelf(IChatFormatted.b<T> var0, ChatModifier var1) {
        return this.getNestedComponent().visit(var0, var1);
    }

    @Override
    public ChatComponentKeybind plainCopy() {
        return new ChatComponentKeybind(this.name);
    }

    @Override
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof ChatComponentKeybind) {
            ChatComponentKeybind var1 = (ChatComponentKeybind)var0;
            return this.name.equals(var1.name) && super.equals(var0);
        }
        return false;
    }

    @Override
    public String toString() {
        return "KeybindComponent{keybind='" + this.name + "', siblings=" + this.siblings + ", style=" + this.getStyle() + "}";
    }

    public String getName() {
        return this.name;
    }

    @Override
    public /* synthetic */ ChatBaseComponent plainCopy() {
        return this.plainCopy();
    }

    @Override
    public /* synthetic */ IChatMutableComponent plainCopy() {
        return this.plainCopy();
    }
}

