/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.logging.LogUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.TimeoutException;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import net.minecraft.SystemUtils;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.PacketCompressor;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketDecompressor;
import net.minecraft.network.PacketDecrypter;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.PacketEncrypter;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketPrepender;
import net.minecraft.network.PacketSplitter;
import net.minecraft.network.SkipEncodeException;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutKickDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutListener;
import net.minecraft.server.CancelledPacketHandleException;
import net.minecraft.server.network.LoginListener;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.util.LazyInitVar;
import net.minecraft.util.MathHelper;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class NetworkManager
extends SimpleChannelInboundHandler<Packet<?>> {
    private static final float AVERAGE_PACKETS_SMOOTHING = 0.75f;
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Marker ROOT_MARKER = MarkerFactory.getMarker((String)"NETWORK");
    public static final Marker PACKET_MARKER = SystemUtils.make(MarkerFactory.getMarker((String)"NETWORK_PACKETS"), var0 -> var0.add(ROOT_MARKER));
    public static final Marker PACKET_RECEIVED_MARKER = SystemUtils.make(MarkerFactory.getMarker((String)"PACKET_RECEIVED"), var0 -> var0.add(PACKET_MARKER));
    public static final Marker PACKET_SENT_MARKER = SystemUtils.make(MarkerFactory.getMarker((String)"PACKET_SENT"), var0 -> var0.add(PACKET_MARKER));
    public static final AttributeKey<EnumProtocol> ATTRIBUTE_PROTOCOL = AttributeKey.valueOf((String)"protocol");
    public static final LazyInitVar<NioEventLoopGroup> NETWORK_WORKER_GROUP = new LazyInitVar<NioEventLoopGroup>(() -> new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Client IO #%d").setDaemon(true).build()));
    public static final LazyInitVar<EpollEventLoopGroup> NETWORK_EPOLL_WORKER_GROUP = new LazyInitVar<EpollEventLoopGroup>(() -> new EpollEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Epoll Client IO #%d").setDaemon(true).build()));
    public static final LazyInitVar<DefaultEventLoopGroup> LOCAL_WORKER_GROUP = new LazyInitVar<DefaultEventLoopGroup>(() -> new DefaultEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Local Client IO #%d").setDaemon(true).build()));
    private final EnumProtocolDirection receiving;
    private final Queue<QueuedPacket> queue = Queues.newConcurrentLinkedQueue();
    public Channel channel;
    public SocketAddress address;
    private PacketListener packetListener;
    private IChatBaseComponent disconnectedReason;
    private boolean encrypted;
    private boolean disconnectionHandled;
    private int receivedPackets;
    private int sentPackets;
    private float averageReceivedPackets;
    private float averageSentPackets;
    private int tickCount;
    private boolean handlingFault;

    public NetworkManager(EnumProtocolDirection var0) {
        this.receiving = var0;
    }

    public void channelActive(ChannelHandlerContext var0) throws Exception {
        super.channelActive(var0);
        this.channel = var0.channel();
        this.address = this.channel.remoteAddress();
        try {
            this.setProtocol(EnumProtocol.HANDSHAKING);
        }
        catch (Throwable var1) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Failed to change protocol to handshake", var1);
        }
    }

    public void setProtocol(EnumProtocol var0) {
        this.channel.attr(ATTRIBUTE_PROTOCOL).set((Object)var0);
        this.channel.config().setAutoRead(true);
        LOGGER.debug("Enabled auto read");
    }

    public void channelInactive(ChannelHandlerContext var0) {
        this.disconnect(new ChatMessage("disconnect.endOfStream"));
    }

    public void exceptionCaught(ChannelHandlerContext var0, Throwable var12) {
        if (var12 instanceof SkipEncodeException) {
            LOGGER.debug("Skipping packet due to errors", var12.getCause());
            return;
        }
        boolean var2 = !this.handlingFault;
        this.handlingFault = true;
        if (!this.channel.isOpen()) {
            return;
        }
        if (var12 instanceof TimeoutException) {
            LOGGER.debug("Timeout", var12);
            this.disconnect(new ChatMessage("disconnect.timeout"));
        } else {
            ChatMessage var3 = new ChatMessage("disconnect.genericReason", "Internal Exception: " + var12);
            if (var2) {
                LOGGER.debug("Failed to sent packet", var12);
                EnumProtocol var4 = this.getCurrentProtocol();
                Packet<PacketLoginOutListener> var5 = var4 == EnumProtocol.LOGIN ? new PacketLoginOutDisconnect(var3) : new PacketPlayOutKickDisconnect(var3);
                this.send(var5, (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)var1 -> this.disconnect(var3)));
                this.setReadOnly();
            } else {
                LOGGER.debug("Double fault", var12);
                this.disconnect(var3);
            }
        }
    }

    protected void channelRead0(ChannelHandlerContext var0, Packet<?> var1) {
        if (this.channel.isOpen()) {
            try {
                NetworkManager.genericsFtw(var1, this.packetListener);
            }
            catch (CancelledPacketHandleException cancelledPacketHandleException) {
            }
            catch (RejectedExecutionException var2) {
                this.disconnect(new ChatMessage("multiplayer.disconnect.server_shutdown"));
            }
            catch (ClassCastException var2) {
                LOGGER.error("Received {} that couldn't be processed", var1.getClass(), (Object)var2);
                this.disconnect(new ChatMessage("multiplayer.disconnect.invalid_packet"));
            }
            ++this.receivedPackets;
        }
    }

    private static <T extends PacketListener> void genericsFtw(Packet<T> var0, PacketListener var1) {
        var0.handle(var1);
    }

    public void setListener(PacketListener var0) {
        Validate.notNull((Object)var0, (String)"packetListener", (Object[])new Object[0]);
        this.packetListener = var0;
    }

    public void send(Packet<?> var0) {
        this.send(var0, null);
    }

    public void send(Packet<?> var0, @Nullable GenericFutureListener<? extends Future<? super Void>> var1) {
        if (this.isConnected()) {
            this.flushQueue();
            this.sendPacket(var0, var1);
        } else {
            this.queue.add(new QueuedPacket(var0, var1));
        }
    }

    private void sendPacket(Packet<?> var0, @Nullable GenericFutureListener<? extends Future<? super Void>> var1) {
        EnumProtocol var2 = EnumProtocol.getProtocolForPacket(var0);
        EnumProtocol var3 = this.getCurrentProtocol();
        ++this.sentPackets;
        if (var3 != var2) {
            LOGGER.debug("Disabled auto read");
            this.channel.config().setAutoRead(false);
        }
        if (this.channel.eventLoop().inEventLoop()) {
            this.doSendPacket(var0, var1, var2, var3);
        } else {
            this.channel.eventLoop().execute(() -> this.doSendPacket(var0, var1, var2, var3));
        }
    }

    private void doSendPacket(Packet<?> var0, @Nullable GenericFutureListener<? extends Future<? super Void>> var1, EnumProtocol var2, EnumProtocol var3) {
        if (var2 != var3) {
            this.setProtocol(var2);
        }
        ChannelFuture var4 = this.channel.writeAndFlush(var0);
        if (var1 != null) {
            var4.addListener(var1);
        }
        var4.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    private EnumProtocol getCurrentProtocol() {
        return (EnumProtocol)((Object)this.channel.attr(ATTRIBUTE_PROTOCOL).get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushQueue() {
        if (this.channel == null || !this.channel.isOpen()) {
            return;
        }
        Queue<QueuedPacket> queue = this.queue;
        synchronized (queue) {
            QueuedPacket var1;
            while ((var1 = this.queue.poll()) != null) {
                this.sendPacket(var1.packet, var1.listener);
            }
        }
    }

    public void tick() {
        this.flushQueue();
        if (this.packetListener instanceof LoginListener) {
            ((LoginListener)this.packetListener).tick();
        }
        if (this.packetListener instanceof PlayerConnection) {
            ((PlayerConnection)this.packetListener).tick();
        }
        if (!this.isConnected() && !this.disconnectionHandled) {
            this.handleDisconnection();
        }
        if (this.channel != null) {
            this.channel.flush();
        }
        if (this.tickCount++ % 20 == 0) {
            this.tickSecond();
        }
    }

    protected void tickSecond() {
        this.averageSentPackets = MathHelper.lerp(0.75f, this.sentPackets, this.averageSentPackets);
        this.averageReceivedPackets = MathHelper.lerp(0.75f, this.receivedPackets, this.averageReceivedPackets);
        this.sentPackets = 0;
        this.receivedPackets = 0;
    }

    public SocketAddress getRemoteAddress() {
        return this.address;
    }

    public void disconnect(IChatBaseComponent var0) {
        if (this.channel.isOpen()) {
            this.channel.close().awaitUninterruptibly();
            this.disconnectedReason = var0;
        }
    }

    public boolean isMemoryConnection() {
        return this.channel instanceof LocalChannel || this.channel instanceof LocalServerChannel;
    }

    public EnumProtocolDirection getReceiving() {
        return this.receiving;
    }

    public EnumProtocolDirection getSending() {
        return this.receiving.getOpposite();
    }

    public static NetworkManager connectToServer(InetSocketAddress var0, boolean var1) {
        LazyInitVar<NioEventLoopGroup> var4;
        Class<NioSocketChannel> var3;
        final NetworkManager var2 = new NetworkManager(EnumProtocolDirection.CLIENTBOUND);
        if (Epoll.isAvailable() && var1) {
            var3 = EpollSocketChannel.class;
            var4 = NETWORK_EPOLL_WORKER_GROUP;
        } else {
            var3 = NioSocketChannel.class;
            var4 = NETWORK_WORKER_GROUP;
        }
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)var4.get())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel var0) {
                try {
                    var0.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                var0.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30)).addLast("splitter", (ChannelHandler)new PacketSplitter()).addLast("decoder", (ChannelHandler)new PacketDecoder(EnumProtocolDirection.CLIENTBOUND)).addLast("prepender", (ChannelHandler)new PacketPrepender()).addLast("encoder", (ChannelHandler)new PacketEncoder(EnumProtocolDirection.SERVERBOUND)).addLast("packet_handler", (ChannelHandler)var2);
            }
        })).channel(var3)).connect(var0.getAddress(), var0.getPort()).syncUninterruptibly();
        return var2;
    }

    public static NetworkManager connectToLocalServer(SocketAddress var0) {
        final NetworkManager var1 = new NetworkManager(EnumProtocolDirection.CLIENTBOUND);
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)LOCAL_WORKER_GROUP.get())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel var0) {
                var0.pipeline().addLast("packet_handler", (ChannelHandler)var1);
            }
        })).channel(LocalChannel.class)).connect(var0).syncUninterruptibly();
        return var1;
    }

    public void setEncryptionKey(Cipher var0, Cipher var1) {
        this.encrypted = true;
        this.channel.pipeline().addBefore("splitter", "decrypt", (ChannelHandler)new PacketDecrypter(var0));
        this.channel.pipeline().addBefore("prepender", "encrypt", (ChannelHandler)new PacketEncrypter(var1));
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public boolean isConnected() {
        return this.channel != null && this.channel.isOpen();
    }

    public boolean isConnecting() {
        return this.channel == null;
    }

    public PacketListener getPacketListener() {
        return this.packetListener;
    }

    @Nullable
    public IChatBaseComponent getDisconnectedReason() {
        return this.disconnectedReason;
    }

    public void setReadOnly() {
        this.channel.config().setAutoRead(false);
    }

    public void setupCompression(int var0, boolean var1) {
        if (var0 >= 0) {
            if (this.channel.pipeline().get("decompress") instanceof PacketDecompressor) {
                ((PacketDecompressor)this.channel.pipeline().get("decompress")).setThreshold(var0, var1);
            } else {
                this.channel.pipeline().addBefore("decoder", "decompress", (ChannelHandler)new PacketDecompressor(var0, var1));
            }
            if (this.channel.pipeline().get("compress") instanceof PacketCompressor) {
                ((PacketCompressor)this.channel.pipeline().get("compress")).setThreshold(var0);
            } else {
                this.channel.pipeline().addBefore("encoder", "compress", (ChannelHandler)new PacketCompressor(var0));
            }
        } else {
            if (this.channel.pipeline().get("decompress") instanceof PacketDecompressor) {
                this.channel.pipeline().remove("decompress");
            }
            if (this.channel.pipeline().get("compress") instanceof PacketCompressor) {
                this.channel.pipeline().remove("compress");
            }
        }
    }

    public void handleDisconnection() {
        if (this.channel == null || this.channel.isOpen()) {
            return;
        }
        if (this.disconnectionHandled) {
            LOGGER.warn("handleDisconnection() called twice");
        } else {
            this.disconnectionHandled = true;
            if (this.getDisconnectedReason() != null) {
                this.getPacketListener().onDisconnect(this.getDisconnectedReason());
            } else if (this.getPacketListener() != null) {
                this.getPacketListener().onDisconnect(new ChatMessage("multiplayer.disconnect.generic"));
            }
        }
    }

    public float getAverageReceivedPackets() {
        return this.averageReceivedPackets;
    }

    public float getAverageSentPackets() {
        return this.averageSentPackets;
    }

    protected /* synthetic */ void channelRead0(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        this.channelRead0(channelHandlerContext, (Packet)object);
    }

    static class QueuedPacket {
        final Packet<?> packet;
        @Nullable
        final GenericFutureListener<? extends Future<? super Void>> listener;

        public QueuedPacket(Packet<?> var0, @Nullable GenericFutureListener<? extends Future<? super Void>> var1) {
            this.packet = var0;
            this.listener = var1;
        }
    }
}

