/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import net.minecraft.EnumChatFormat;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import org.slf4j.Logger;

public class TextComponentTagVisitor
implements TagVisitor {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int INLINE_LIST_THRESHOLD = 8;
    private static final ByteCollection INLINE_ELEMENT_TYPES = new ByteOpenHashSet(Arrays.asList((byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6));
    private static final EnumChatFormat SYNTAX_HIGHLIGHTING_KEY = EnumChatFormat.AQUA;
    private static final EnumChatFormat SYNTAX_HIGHLIGHTING_STRING = EnumChatFormat.GREEN;
    private static final EnumChatFormat SYNTAX_HIGHLIGHTING_NUMBER = EnumChatFormat.GOLD;
    private static final EnumChatFormat SYNTAX_HIGHLIGHTING_NUMBER_TYPE = EnumChatFormat.RED;
    private static final Pattern SIMPLE_VALUE = Pattern.compile("[A-Za-z0-9._+-]+");
    private static final String NAME_VALUE_SEPARATOR = String.valueOf(':');
    private static final String ELEMENT_SEPARATOR = String.valueOf(',');
    private static final String LIST_OPEN = "[";
    private static final String LIST_CLOSE = "]";
    private static final String LIST_TYPE_SEPARATOR = ";";
    private static final String ELEMENT_SPACING = " ";
    private static final String STRUCT_OPEN = "{";
    private static final String STRUCT_CLOSE = "}";
    private static final String NEWLINE = "\n";
    private final String indentation;
    private final int depth;
    private IChatBaseComponent result = ChatComponentText.EMPTY;

    public TextComponentTagVisitor(String var0, int var1) {
        this.indentation = var0;
        this.depth = var1;
    }

    public IChatBaseComponent visit(NBTBase var0) {
        var0.accept(this);
        return this.result;
    }

    @Override
    public void visitString(NBTTagString var0) {
        String var1 = NBTTagString.quoteAndEscape(var0.getAsString());
        String var2 = var1.substring(0, 1);
        IChatMutableComponent var3 = new ChatComponentText(var1.substring(1, var1.length() - 1)).withStyle(SYNTAX_HIGHLIGHTING_STRING);
        this.result = new ChatComponentText(var2).append(var3).append(var2);
    }

    @Override
    public void visitByte(NBTTagByte var0) {
        IChatMutableComponent var1 = new ChatComponentText("b").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = new ChatComponentText(String.valueOf(var0.getAsNumber())).append(var1).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitShort(NBTTagShort var0) {
        IChatMutableComponent var1 = new ChatComponentText("s").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = new ChatComponentText(String.valueOf(var0.getAsNumber())).append(var1).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitInt(NBTTagInt var0) {
        this.result = new ChatComponentText(String.valueOf(var0.getAsNumber())).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitLong(NBTTagLong var0) {
        IChatMutableComponent var1 = new ChatComponentText("L").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = new ChatComponentText(String.valueOf(var0.getAsNumber())).append(var1).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitFloat(NBTTagFloat var0) {
        IChatMutableComponent var1 = new ChatComponentText("f").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = new ChatComponentText(String.valueOf(var0.getAsFloat())).append(var1).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitDouble(NBTTagDouble var0) {
        IChatMutableComponent var1 = new ChatComponentText("d").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = new ChatComponentText(String.valueOf(var0.getAsDouble())).append(var1).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitByteArray(NBTTagByteArray var0) {
        IChatMutableComponent var1 = new ChatComponentText("B").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        IChatMutableComponent var2 = new ChatComponentText(LIST_OPEN).append(var1).append(LIST_TYPE_SEPARATOR);
        byte[] var3 = var0.getAsByteArray();
        for (int var4 = 0; var4 < var3.length; ++var4) {
            IChatMutableComponent var5 = new ChatComponentText(String.valueOf(var3[var4])).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
            var2.append(ELEMENT_SPACING).append(var5).append(var1);
            if (var4 == var3.length - 1) continue;
            var2.append(ELEMENT_SEPARATOR);
        }
        var2.append(LIST_CLOSE);
        this.result = var2;
    }

    @Override
    public void visitIntArray(NBTTagIntArray var0) {
        IChatMutableComponent var1 = new ChatComponentText("I").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        IChatMutableComponent var2 = new ChatComponentText(LIST_OPEN).append(var1).append(LIST_TYPE_SEPARATOR);
        int[] var3 = var0.getAsIntArray();
        for (int var4 = 0; var4 < var3.length; ++var4) {
            var2.append(ELEMENT_SPACING).append(new ChatComponentText(String.valueOf(var3[var4])).withStyle(SYNTAX_HIGHLIGHTING_NUMBER));
            if (var4 == var3.length - 1) continue;
            var2.append(ELEMENT_SEPARATOR);
        }
        var2.append(LIST_CLOSE);
        this.result = var2;
    }

    @Override
    public void visitLongArray(NBTTagLongArray var0) {
        IChatMutableComponent var1 = new ChatComponentText("L").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        IChatMutableComponent var2 = new ChatComponentText(LIST_OPEN).append(var1).append(LIST_TYPE_SEPARATOR);
        long[] var3 = var0.getAsLongArray();
        for (int var4 = 0; var4 < var3.length; ++var4) {
            IChatMutableComponent var5 = new ChatComponentText(String.valueOf(var3[var4])).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
            var2.append(ELEMENT_SPACING).append(var5).append(var1);
            if (var4 == var3.length - 1) continue;
            var2.append(ELEMENT_SEPARATOR);
        }
        var2.append(LIST_CLOSE);
        this.result = var2;
    }

    @Override
    public void visitList(NBTTagList var0) {
        if (var0.isEmpty()) {
            this.result = new ChatComponentText("[]");
            return;
        }
        if (INLINE_ELEMENT_TYPES.contains(var0.getElementType()) && var0.size() <= 8) {
            String var1 = ELEMENT_SEPARATOR + ELEMENT_SPACING;
            ChatComponentText var2 = new ChatComponentText(LIST_OPEN);
            for (int var3 = 0; var3 < var0.size(); ++var3) {
                if (var3 != 0) {
                    var2.append(var1);
                }
                var2.append(new TextComponentTagVisitor(this.indentation, this.depth).visit(var0.get(var3)));
            }
            var2.append(LIST_CLOSE);
            this.result = var2;
            return;
        }
        ChatComponentText var1 = new ChatComponentText(LIST_OPEN);
        if (!this.indentation.isEmpty()) {
            var1.append(NEWLINE);
        }
        for (int var2 = 0; var2 < var0.size(); ++var2) {
            ChatComponentText var3 = new ChatComponentText(Strings.repeat((String)this.indentation, (int)(this.depth + 1)));
            var3.append(new TextComponentTagVisitor(this.indentation, this.depth + 1).visit(var0.get(var2)));
            if (var2 != var0.size() - 1) {
                var3.append(ELEMENT_SEPARATOR).append(this.indentation.isEmpty() ? ELEMENT_SPACING : NEWLINE);
            }
            var1.append(var3);
        }
        if (!this.indentation.isEmpty()) {
            var1.append(NEWLINE).append(Strings.repeat((String)this.indentation, (int)this.depth));
        }
        var1.append(LIST_CLOSE);
        this.result = var1;
    }

    @Override
    public void visitCompound(NBTTagCompound var0) {
        Object var3;
        if (var0.isEmpty()) {
            this.result = new ChatComponentText("{}");
            return;
        }
        ChatComponentText var1 = new ChatComponentText(STRUCT_OPEN);
        Collection<String> var2 = var0.getAllKeys();
        if (LOGGER.isDebugEnabled()) {
            var3 = Lists.newArrayList(var0.getAllKeys());
            Collections.sort(var3);
            var2 = var3;
        }
        if (!this.indentation.isEmpty()) {
            var1.append(NEWLINE);
        }
        var3 = var2.iterator();
        while (var3.hasNext()) {
            String var4 = (String)var3.next();
            IChatMutableComponent var5 = new ChatComponentText(Strings.repeat((String)this.indentation, (int)(this.depth + 1))).append(TextComponentTagVisitor.handleEscapePretty(var4)).append(NAME_VALUE_SEPARATOR).append(ELEMENT_SPACING).append(new TextComponentTagVisitor(this.indentation, this.depth + 1).visit(var0.get(var4)));
            if (var3.hasNext()) {
                var5.append(ELEMENT_SEPARATOR).append(this.indentation.isEmpty() ? ELEMENT_SPACING : NEWLINE);
            }
            var1.append(var5);
        }
        if (!this.indentation.isEmpty()) {
            var1.append(NEWLINE).append(Strings.repeat((String)this.indentation, (int)this.depth));
        }
        var1.append(STRUCT_CLOSE);
        this.result = var1;
    }

    protected static IChatBaseComponent handleEscapePretty(String var0) {
        if (SIMPLE_VALUE.matcher(var0).matches()) {
            return new ChatComponentText(var0).withStyle(SYNTAX_HIGHLIGHTING_KEY);
        }
        String var1 = NBTTagString.quoteAndEscape(var0);
        String var2 = var1.substring(0, 1);
        IChatMutableComponent var3 = new ChatComponentText(var1.substring(1, var1.length() - 1)).withStyle(SYNTAX_HIGHLIGHTING_KEY);
        return new ChatComponentText(var2).append(var3).append(var2);
    }

    @Override
    public void visitEnd(NBTTagEnd var0) {
        this.result = ChatComponentText.EMPTY;
    }
}

