/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import java.util.Collection;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.server.level.WorldServer;

public class GameTestHarnessBatch {
    public static final String DEFAULT_BATCH_NAME = "defaultBatch";
    private final String name;
    private final Collection<GameTestHarnessTestFunction> testFunctions;
    @Nullable
    private final Consumer<WorldServer> beforeBatchFunction;
    @Nullable
    private final Consumer<WorldServer> afterBatchFunction;

    public GameTestHarnessBatch(String var0, Collection<GameTestHarnessTestFunction> var1, @Nullable Consumer<WorldServer> var2, @Nullable Consumer<WorldServer> var3) {
        if (var1.isEmpty()) {
            throw new IllegalArgumentException("A GameTestBatch must include at least one TestFunction!");
        }
        this.name = var0;
        this.testFunctions = var1;
        this.beforeBatchFunction = var2;
        this.afterBatchFunction = var3;
    }

    public String getName() {
        return this.name;
    }

    public Collection<GameTestHarnessTestFunction> getTestFunctions() {
        return this.testFunctions;
    }

    public void runBeforeBatchFunction(WorldServer var0) {
        if (this.beforeBatchFunction != null) {
            this.beforeBatchFunction.accept(var0);
        }
    }

    public void runAfterBatchFunction(WorldServer var0) {
        if (this.afterBatchFunction != null) {
            this.afterBatchFunction.accept(var0);
        }
    }
}

