/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen.features;

import java.util.List;
import java.util.Random;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.data.worldgen.features.AquaticFeatures;
import net.minecraft.data.worldgen.features.CaveFeatures;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.data.worldgen.features.NetherFeatures;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.features.PileFeatures;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRandomChoiceConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class FeatureUtils {
    public static Holder<? extends WorldGenFeatureConfigured<?, ?>> bootstrap() {
        List<Holder<WorldGenFeatureConfigured<WorldGenFeatureRandomChoiceConfiguration, ?>>> var0 = List.of(AquaticFeatures.KELP, CaveFeatures.MOSS_PATCH_BONEMEAL, EndFeatures.CHORUS_PLANT, MiscOverworldFeatures.SPRING_LAVA_OVERWORLD, NetherFeatures.BASALT_BLOBS, OreFeatures.ORE_ANCIENT_DEBRIS_LARGE, PileFeatures.PILE_HAY, TreeFeatures.AZALEA_TREE, VegetationFeatures.TREES_OLD_GROWTH_PINE_TAIGA);
        return SystemUtils.getRandom(var0, new Random());
    }

    private static BlockPredicate simplePatchPredicate(List<Block> var0) {
        BlockPredicate var1 = !var0.isEmpty() ? BlockPredicate.allOf(BlockPredicate.ONLY_IN_AIR_PREDICATE, BlockPredicate.matchesBlocks(var0, new BlockPosition(0, -1, 0))) : BlockPredicate.ONLY_IN_AIR_PREDICATE;
        return var1;
    }

    public static WorldGenFeatureRandomPatchConfiguration simpleRandomPatchConfiguration(int var0, Holder<PlacedFeature> var1) {
        return new WorldGenFeatureRandomPatchConfiguration(var0, 7, 3, var1);
    }

    public static <FC extends WorldGenFeatureConfiguration, F extends WorldGenerator<FC>> WorldGenFeatureRandomPatchConfiguration simplePatchConfiguration(F var0, FC var1, List<Block> var2, int var3) {
        return FeatureUtils.simpleRandomPatchConfiguration(var3, PlacementUtils.filtered(var0, var1, FeatureUtils.simplePatchPredicate(var2)));
    }

    public static <FC extends WorldGenFeatureConfiguration, F extends WorldGenerator<FC>> WorldGenFeatureRandomPatchConfiguration simplePatchConfiguration(F var0, FC var1, List<Block> var2) {
        return FeatureUtils.simplePatchConfiguration(var0, var1, var2, 96);
    }

    public static <FC extends WorldGenFeatureConfiguration, F extends WorldGenerator<FC>> WorldGenFeatureRandomPatchConfiguration simplePatchConfiguration(F var0, FC var1) {
        return FeatureUtils.simplePatchConfiguration(var0, var1, List.of(), 96);
    }

    public static Holder<WorldGenFeatureConfigured<WorldGenFeatureEmptyConfiguration, ?>> register(String var0, WorldGenerator<WorldGenFeatureEmptyConfiguration> var1) {
        return FeatureUtils.register(var0, var1, WorldGenFeatureConfiguration.NONE);
    }

    public static <FC extends WorldGenFeatureConfiguration, F extends WorldGenerator<FC>> Holder<WorldGenFeatureConfigured<FC, ?>> register(String var0, F var1, FC var2) {
        return RegistryGeneration.registerExact(RegistryGeneration.CONFIGURED_FEATURE, var0, new WorldGenFeatureConfigured<FC, F>(var1, var2));
    }
}

