/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.data.worldgen.WorldGenFeatureBastionPieces;
import net.minecraft.data.worldgen.WorldGenFeaturePillagerOutpostPieces;
import net.minecraft.data.worldgen.WorldGenFeatureVillages;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;

public class WorldGenFeaturePieces {
    public static final ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> EMPTY = ResourceKey.create(IRegistry.TEMPLATE_POOL_REGISTRY, new MinecraftKey("empty"));
    private static final Holder<WorldGenFeatureDefinedStructurePoolTemplate> BUILTIN_EMPTY = WorldGenFeaturePieces.register(new WorldGenFeatureDefinedStructurePoolTemplate(EMPTY.location(), EMPTY.location(), (List<Pair<Function<WorldGenFeatureDefinedStructurePoolTemplate.Matching, ? extends WorldGenFeatureDefinedStructurePoolStructure>, Integer>>)ImmutableList.of(), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));

    public static Holder<WorldGenFeatureDefinedStructurePoolTemplate> register(WorldGenFeatureDefinedStructurePoolTemplate var0) {
        return RegistryGeneration.register(RegistryGeneration.TEMPLATE_POOL, var0.getName(), var0);
    }

    public static Holder<WorldGenFeatureDefinedStructurePoolTemplate> bootstrap() {
        WorldGenFeatureBastionPieces.bootstrap();
        WorldGenFeaturePillagerOutpostPieces.bootstrap();
        WorldGenFeatureVillages.bootstrap();
        return BUILTIN_EMPTY;
    }

    static {
        WorldGenFeaturePieces.bootstrap();
    }
}

