/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.data.DebugReportGenerator;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.structures.DebugReportNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class SnbtToNbt
implements DebugReportProvider {
    @Nullable
    private static final Path DUMP_SNBT_TO = null;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final DebugReportGenerator generator;
    private final List<a> filters = Lists.newArrayList();

    public SnbtToNbt(DebugReportGenerator var0) {
        this.generator = var0;
    }

    public SnbtToNbt addFilter(a var0) {
        this.filters.add(var0);
        return this;
    }

    private NBTTagCompound applyFilters(String var0, NBTTagCompound var1) {
        NBTTagCompound var2 = var1;
        for (a var4 : this.filters) {
            var2 = var4.apply(var0, var2);
        }
        return var2;
    }

    @Override
    public void run(HashCache var02) throws IOException {
        Path var1 = this.generator.getOutputFolder();
        ArrayList var22 = Lists.newArrayList();
        for (Path var4 : this.generator.getInputFolders()) {
            Files.walk(var4, new FileVisitOption[0]).filter(var0 -> var0.toString().endsWith(".snbt")).forEach(var2 -> var22.add(CompletableFuture.supplyAsync(() -> this.readStructure((Path)var2, this.getName(var4, (Path)var2)), SystemUtils.backgroundExecutor())));
        }
        boolean var3 = false;
        for (CompletableFuture var5 : var22) {
            try {
                this.storeStructureIfChanged(var02, (c)var5.get(), var1);
            }
            catch (Exception var6) {
                LOGGER.error("Failed to process structure", (Throwable)var6);
                var3 = true;
            }
        }
        if (var3) {
            throw new IllegalStateException("Failed to convert all structures, aborting");
        }
    }

    @Override
    public String getName() {
        return "SNBT -> NBT";
    }

    private String getName(Path var0, Path var1) {
        String var2 = var0.relativize(var1).toString().replaceAll("\\\\", "/");
        return var2.substring(0, var2.length() - ".snbt".length());
    }

    private c readStructure(Path var0, String var1) {
        c c2;
        block8: {
            BufferedReader var2 = Files.newBufferedReader(var0);
            try {
                String var3 = IOUtils.toString((Reader)var2);
                NBTTagCompound var4 = this.applyFilters(var1, GameProfileSerializer.snbtToStructure(var3));
                ByteArrayOutputStream var5 = new ByteArrayOutputStream();
                NBTCompressedStreamTools.writeCompressed(var4, var5);
                byte[] var6 = var5.toByteArray();
                String var7 = SHA1.hashBytes(var6).toString();
                String var8 = DUMP_SNBT_TO != null ? GameProfileSerializer.structureToSnbt(var4) : null;
                c2 = new c(var1, var6, var8, var7);
                if (var2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (var2 != null) {
                        try {
                            var2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable var22) {
                    throw new b(var0, var22);
                }
            }
            var2.close();
        }
        return c2;
    }

    private void storeStructureIfChanged(HashCache var0, c var1, Path var2) {
        Path var3;
        if (var1.snbtPayload != null) {
            var3 = DUMP_SNBT_TO.resolve(var1.name + ".snbt");
            try {
                DebugReportNBT.writeSnbt(var3, var1.snbtPayload);
            }
            catch (IOException var4) {
                LOGGER.error("Couldn't write structure SNBT {} at {}", new Object[]{var1.name, var3, var4});
            }
        }
        var3 = var2.resolve(var1.name + ".nbt");
        try {
            if (!Objects.equals(var0.getHash(var3), var1.hash) || !Files.exists(var3, new LinkOption[0])) {
                Files.createDirectories(var3.getParent(), new FileAttribute[0]);
                try (OutputStream var4 = Files.newOutputStream(var3, new OpenOption[0]);){
                    var4.write(var1.payload);
                }
            }
            var0.putNew(var3, var1.hash);
        }
        catch (IOException var4) {
            LOGGER.error("Couldn't write structure {} at {}", new Object[]{var1.name, var3, var4});
        }
    }

    @FunctionalInterface
    public static interface a {
        public NBTTagCompound apply(String var1, NBTTagCompound var2);
    }

    static class c {
        final String name;
        final byte[] payload;
        @Nullable
        final String snbtPayload;
        final String hash;

        public c(String var0, byte[] var1, @Nullable String var2, String var3) {
            this.name = var0;
            this.payload = var1;
            this.snbtPayload = var2;
            this.hash = var3;
        }
    }

    static class b
    extends RuntimeException {
        public b(Path var0, Throwable var1) {
            super(var0.toAbsolutePath().toString(), var1);
        }
    }
}

