/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class HashCache {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Path path;
    private final Path cachePath;
    private int hits;
    private final Map<Path, String> oldCache = Maps.newHashMap();
    private final Map<Path, String> newCache = Maps.newHashMap();
    private final Set<Path> keep = Sets.newHashSet();

    public HashCache(Path var02, String var12) throws IOException {
        this.path = var02;
        Path var2 = var02.resolve(".cache");
        Files.createDirectories(var2, new FileAttribute[0]);
        this.cachePath = var2.resolve(var12);
        this.walkOutputFiles().forEach(var0 -> this.oldCache.put((Path)var0, ""));
        if (Files.isReadable(this.cachePath)) {
            IOUtils.readLines((InputStream)Files.newInputStream(this.cachePath, new OpenOption[0]), (Charset)Charsets.UTF_8).forEach(var1 -> {
                int var2 = var1.indexOf(32);
                this.oldCache.put(var02.resolve(var1.substring(var2 + 1)), var1.substring(0, var2));
            });
        }
    }

    public void purgeStaleAndWrite() throws IOException {
        BufferedWriter var02;
        this.removeStale();
        try {
            var02 = Files.newBufferedWriter(this.cachePath, new OpenOption[0]);
        }
        catch (IOException var1) {
            LOGGER.warn("Unable write cachefile {}: {}", (Object)this.cachePath, (Object)var1.toString());
            return;
        }
        IOUtils.writeLines((Collection)this.newCache.entrySet().stream().map(var0 -> (String)var0.getValue() + " " + this.path.relativize((Path)var0.getKey())).collect(Collectors.toList()), (String)System.lineSeparator(), (Writer)var02);
        ((Writer)var02).close();
        LOGGER.debug("Caching: cache hits: {}, created: {} removed: {}", new Object[]{this.hits, this.newCache.size() - this.hits, this.oldCache.size()});
    }

    @Nullable
    public String getHash(Path var0) {
        return this.oldCache.get(var0);
    }

    public void putNew(Path var0, String var1) {
        this.newCache.put(var0, var1);
        if (Objects.equals(this.oldCache.remove(var0), var1)) {
            ++this.hits;
        }
    }

    public boolean had(Path var0) {
        return this.oldCache.containsKey(var0);
    }

    public void keep(Path var0) {
        this.keep.add(var0);
    }

    private void removeStale() throws IOException {
        this.walkOutputFiles().forEach(var0 -> {
            if (this.had((Path)var0) && !this.keep.contains(var0)) {
                try {
                    Files.delete(var0);
                }
                catch (IOException var1) {
                    LOGGER.debug("Unable to delete: {} ({})", var0, (Object)var1.toString());
                }
            }
        });
    }

    private Stream<Path> walkOutputFiles() throws IOException {
        return Files.walk(this.path, new FileVisitOption[0]).filter(var0 -> !Objects.equals(this.cachePath, var0) && !Files.isDirectory(var0, new LinkOption[0]));
    }
}

