/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.HashCache;
import net.minecraft.server.DispenserRegistry;
import org.slf4j.Logger;

public class DebugReportGenerator {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Collection<Path> inputFolders;
    private final Path outputFolder;
    private final List<DebugReportProvider> providers = Lists.newArrayList();

    public DebugReportGenerator(Path var0, Collection<Path> var1) {
        this.outputFolder = var0;
        this.inputFolders = var1;
    }

    public Collection<Path> getInputFolders() {
        return this.inputFolders;
    }

    public Path getOutputFolder() {
        return this.outputFolder;
    }

    public void run() throws IOException {
        HashCache var0 = new HashCache(this.outputFolder, "cache");
        var0.keep(this.getOutputFolder().resolve("version.json"));
        Stopwatch var1 = Stopwatch.createStarted();
        Stopwatch var2 = Stopwatch.createUnstarted();
        for (DebugReportProvider var4 : this.providers) {
            LOGGER.info("Starting provider: {}", (Object)var4.getName());
            var2.start();
            var4.run(var0);
            var2.stop();
            LOGGER.info("{} finished after {} ms", (Object)var4.getName(), (Object)var2.elapsed(TimeUnit.MILLISECONDS));
            var2.reset();
        }
        LOGGER.info("All providers took: {} ms", (Object)var1.elapsed(TimeUnit.MILLISECONDS));
        var0.purgeStaleAndWrite();
    }

    public void addProvider(DebugReportProvider var0) {
        this.providers.add(var0);
    }

    static {
        DispenserRegistry.bootStrap();
    }
}

