/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Vector3fa;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.DustParticleOptionsBase;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.phys.Vec3D;

public class DustColorTransitionOptions
extends DustParticleOptionsBase {
    public static final Vector3fa SCULK_PARTICLE_COLOR = new Vector3fa(Vec3D.fromRGB24(3790560));
    public static final DustColorTransitionOptions SCULK_TO_REDSTONE = new DustColorTransitionOptions(SCULK_PARTICLE_COLOR, ParticleParamRedstone.REDSTONE_PARTICLE_COLOR, 1.0f);
    public static final Codec<DustColorTransitionOptions> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Vector3fa.CODEC.fieldOf("fromColor").forGetter(var0 -> var0.color), (App)Vector3fa.CODEC.fieldOf("toColor").forGetter(var0 -> var0.toColor), (App)Codec.FLOAT.fieldOf("scale").forGetter(var0 -> Float.valueOf(var0.scale))).apply((Applicative)var02, DustColorTransitionOptions::new));
    public static final ParticleParam.a<DustColorTransitionOptions> DESERIALIZER = new ParticleParam.a<DustColorTransitionOptions>(){

        @Override
        public DustColorTransitionOptions fromCommand(Particle<DustColorTransitionOptions> var0, StringReader var1) throws CommandSyntaxException {
            Vector3fa var2 = DustParticleOptionsBase.readVector3f(var1);
            var1.expect(' ');
            float var3 = var1.readFloat();
            Vector3fa var4 = DustParticleOptionsBase.readVector3f(var1);
            return new DustColorTransitionOptions(var2, var4, var3);
        }

        @Override
        public DustColorTransitionOptions fromNetwork(Particle<DustColorTransitionOptions> var0, PacketDataSerializer var1) {
            Vector3fa var2 = DustParticleOptionsBase.readVector3f(var1);
            float var3 = var1.readFloat();
            Vector3fa var4 = DustParticleOptionsBase.readVector3f(var1);
            return new DustColorTransitionOptions(var2, var4, var3);
        }

        @Override
        public /* synthetic */ ParticleParam fromNetwork(Particle particle, PacketDataSerializer packetDataSerializer) {
            return this.fromNetwork(particle, packetDataSerializer);
        }

        @Override
        public /* synthetic */ ParticleParam fromCommand(Particle particle, StringReader stringReader) throws CommandSyntaxException {
            return this.fromCommand(particle, stringReader);
        }
    };
    private final Vector3fa toColor;

    public DustColorTransitionOptions(Vector3fa var0, Vector3fa var1, float var2) {
        super(var0, var2);
        this.toColor = var1;
    }

    public Vector3fa getFromColor() {
        return this.color;
    }

    public Vector3fa getToColor() {
        return this.toColor;
    }

    @Override
    public void writeToNetwork(PacketDataSerializer var0) {
        super.writeToNetwork(var0);
        var0.writeFloat(this.toColor.x());
        var0.writeFloat(this.toColor.y());
        var0.writeFloat(this.toColor.z());
    }

    @Override
    public String writeToString() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %.2f %.2f", IRegistry.PARTICLE_TYPE.getKey(this.getType()), Float.valueOf(this.color.x()), Float.valueOf(this.color.y()), Float.valueOf(this.color.z()), Float.valueOf(this.scale), Float.valueOf(this.toColor.x()), Float.valueOf(this.toColor.y()), Float.valueOf(this.toColor.z()));
    }

    public Particle<DustColorTransitionOptions> getType() {
        return Particles.DUST_COLOR_TRANSITION;
    }
}

