/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import it.unimi.dsi.fastutil.longs.LongConsumer;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.CursorPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.IChunkAccess;

public class SectionPosition
extends BaseBlockPosition {
    public static final int SECTION_BITS = 4;
    public static final int SECTION_SIZE = 16;
    public static final int SECTION_MASK = 15;
    public static final int SECTION_HALF_SIZE = 8;
    public static final int SECTION_MAX_INDEX = 15;
    private static final int PACKED_X_LENGTH = 22;
    private static final int PACKED_Y_LENGTH = 20;
    private static final int PACKED_Z_LENGTH = 22;
    private static final long PACKED_X_MASK = 0x3FFFFFL;
    private static final long PACKED_Y_MASK = 1048575L;
    private static final long PACKED_Z_MASK = 0x3FFFFFL;
    private static final int Y_OFFSET = 0;
    private static final int Z_OFFSET = 20;
    private static final int X_OFFSET = 42;
    private static final int RELATIVE_X_SHIFT = 8;
    private static final int RELATIVE_Y_SHIFT = 0;
    private static final int RELATIVE_Z_SHIFT = 4;

    SectionPosition(int var0, int var1, int var2) {
        super(var0, var1, var2);
    }

    public static SectionPosition of(int var0, int var1, int var2) {
        return new SectionPosition(var0, var1, var2);
    }

    public static SectionPosition of(BlockPosition var0) {
        return new SectionPosition(SectionPosition.blockToSectionCoord(var0.getX()), SectionPosition.blockToSectionCoord(var0.getY()), SectionPosition.blockToSectionCoord(var0.getZ()));
    }

    public static SectionPosition of(ChunkCoordIntPair var0, int var1) {
        return new SectionPosition(var0.x, var1, var0.z);
    }

    public static SectionPosition of(Entity var0) {
        return new SectionPosition(SectionPosition.blockToSectionCoord(var0.getBlockX()), SectionPosition.blockToSectionCoord(var0.getBlockY()), SectionPosition.blockToSectionCoord(var0.getBlockZ()));
    }

    public static SectionPosition of(long var0) {
        return new SectionPosition(SectionPosition.x(var0), SectionPosition.y(var0), SectionPosition.z(var0));
    }

    public static SectionPosition bottomOf(IChunkAccess var0) {
        return SectionPosition.of(var0.getPos(), var0.getMinSection());
    }

    public static long offset(long var0, EnumDirection var2) {
        return SectionPosition.offset(var0, var2.getStepX(), var2.getStepY(), var2.getStepZ());
    }

    public static long offset(long var0, int var2, int var3, int var4) {
        return SectionPosition.asLong(SectionPosition.x(var0) + var2, SectionPosition.y(var0) + var3, SectionPosition.z(var0) + var4);
    }

    public static int posToSectionCoord(double var0) {
        return SectionPosition.blockToSectionCoord(MathHelper.floor(var0));
    }

    public static int blockToSectionCoord(int var0) {
        return var0 >> 4;
    }

    public static int sectionRelative(int var0) {
        return var0 & 0xF;
    }

    public static short sectionRelativePos(BlockPosition var0) {
        int var1 = SectionPosition.sectionRelative(var0.getX());
        int var2 = SectionPosition.sectionRelative(var0.getY());
        int var3 = SectionPosition.sectionRelative(var0.getZ());
        return (short)(var1 << 8 | var3 << 4 | var2 << 0);
    }

    public static int sectionRelativeX(short var0) {
        return var0 >>> 8 & 0xF;
    }

    public static int sectionRelativeY(short var0) {
        return var0 >>> 0 & 0xF;
    }

    public static int sectionRelativeZ(short var0) {
        return var0 >>> 4 & 0xF;
    }

    public int relativeToBlockX(short var0) {
        return this.minBlockX() + SectionPosition.sectionRelativeX(var0);
    }

    public int relativeToBlockY(short var0) {
        return this.minBlockY() + SectionPosition.sectionRelativeY(var0);
    }

    public int relativeToBlockZ(short var0) {
        return this.minBlockZ() + SectionPosition.sectionRelativeZ(var0);
    }

    public BlockPosition relativeToBlockPos(short var0) {
        return new BlockPosition(this.relativeToBlockX(var0), this.relativeToBlockY(var0), this.relativeToBlockZ(var0));
    }

    public static int sectionToBlockCoord(int var0) {
        return var0 << 4;
    }

    public static int sectionToBlockCoord(int var0, int var1) {
        return SectionPosition.sectionToBlockCoord(var0) + var1;
    }

    public static int x(long var0) {
        return (int)(var0 << 0 >> 42);
    }

    public static int y(long var0) {
        return (int)(var0 << 44 >> 44);
    }

    public static int z(long var0) {
        return (int)(var0 << 22 >> 42);
    }

    public int x() {
        return this.getX();
    }

    public int y() {
        return this.getY();
    }

    public int z() {
        return this.getZ();
    }

    public int minBlockX() {
        return SectionPosition.sectionToBlockCoord(this.x());
    }

    public int minBlockY() {
        return SectionPosition.sectionToBlockCoord(this.y());
    }

    public int minBlockZ() {
        return SectionPosition.sectionToBlockCoord(this.z());
    }

    public int maxBlockX() {
        return SectionPosition.sectionToBlockCoord(this.x(), 15);
    }

    public int maxBlockY() {
        return SectionPosition.sectionToBlockCoord(this.y(), 15);
    }

    public int maxBlockZ() {
        return SectionPosition.sectionToBlockCoord(this.z(), 15);
    }

    public static long blockToSection(long var0) {
        return SectionPosition.asLong(SectionPosition.blockToSectionCoord(BlockPosition.getX(var0)), SectionPosition.blockToSectionCoord(BlockPosition.getY(var0)), SectionPosition.blockToSectionCoord(BlockPosition.getZ(var0)));
    }

    public static long getZeroNode(long var0) {
        return var0 & 0xFFFFFFFFFFF00000L;
    }

    public BlockPosition origin() {
        return new BlockPosition(SectionPosition.sectionToBlockCoord(this.x()), SectionPosition.sectionToBlockCoord(this.y()), SectionPosition.sectionToBlockCoord(this.z()));
    }

    public BlockPosition center() {
        int var0 = 8;
        return this.origin().offset(8, 8, 8);
    }

    public ChunkCoordIntPair chunk() {
        return new ChunkCoordIntPair(this.x(), this.z());
    }

    public static long asLong(BlockPosition var0) {
        return SectionPosition.asLong(SectionPosition.blockToSectionCoord(var0.getX()), SectionPosition.blockToSectionCoord(var0.getY()), SectionPosition.blockToSectionCoord(var0.getZ()));
    }

    public static long asLong(int var0, int var1, int var2) {
        long var3 = 0L;
        var3 |= ((long)var0 & 0x3FFFFFL) << 42;
        var3 |= ((long)var1 & 0xFFFFFL) << 0;
        return var3 |= ((long)var2 & 0x3FFFFFL) << 20;
    }

    public long asLong() {
        return SectionPosition.asLong(this.x(), this.y(), this.z());
    }

    @Override
    public SectionPosition offset(int var0, int var1, int var2) {
        if (var0 == 0 && var1 == 0 && var2 == 0) {
            return this;
        }
        return new SectionPosition(this.x() + var0, this.y() + var1, this.z() + var2);
    }

    public Stream<BlockPosition> blocksInside() {
        return BlockPosition.betweenClosedStream(this.minBlockX(), this.minBlockY(), this.minBlockZ(), this.maxBlockX(), this.maxBlockY(), this.maxBlockZ());
    }

    public static Stream<SectionPosition> cube(SectionPosition var0, int var1) {
        int var2 = var0.x();
        int var3 = var0.y();
        int var4 = var0.z();
        return SectionPosition.betweenClosedStream(var2 - var1, var3 - var1, var4 - var1, var2 + var1, var3 + var1, var4 + var1);
    }

    public static Stream<SectionPosition> aroundChunk(ChunkCoordIntPair var0, int var1, int var2, int var3) {
        int var4 = var0.x;
        int var5 = var0.z;
        return SectionPosition.betweenClosedStream(var4 - var1, var2, var5 - var1, var4 + var1, var3 - 1, var5 + var1);
    }

    public static Stream<SectionPosition> betweenClosedStream(final int var0, final int var1, final int var2, final int var3, final int var4, final int var5) {
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<SectionPosition>((long)((var3 - var0 + 1) * (var4 - var1 + 1) * (var5 - var2 + 1)), 64){
            final CursorPosition cursor;
            {
                super(var02, var22);
                this.cursor = new CursorPosition(var0, var1, var2, var3, var4, var5);
            }

            @Override
            public boolean tryAdvance(Consumer<? super SectionPosition> var02) {
                if (this.cursor.advance()) {
                    var02.accept(new SectionPosition(this.cursor.nextX(), this.cursor.nextY(), this.cursor.nextZ()));
                    return true;
                }
                return false;
            }
        }, false);
    }

    public static void aroundAndAtBlockPos(BlockPosition var0, LongConsumer var1) {
        SectionPosition.aroundAndAtBlockPos(var0.getX(), var0.getY(), var0.getZ(), var1);
    }

    public static void aroundAndAtBlockPos(long var0, LongConsumer var2) {
        SectionPosition.aroundAndAtBlockPos(BlockPosition.getX(var0), BlockPosition.getY(var0), BlockPosition.getZ(var0), var2);
    }

    public static void aroundAndAtBlockPos(int var0, int var1, int var2, LongConsumer var3) {
        int var4 = SectionPosition.blockToSectionCoord(var0 - 1);
        int var5 = SectionPosition.blockToSectionCoord(var0 + 1);
        int var6 = SectionPosition.blockToSectionCoord(var1 - 1);
        int var7 = SectionPosition.blockToSectionCoord(var1 + 1);
        int var8 = SectionPosition.blockToSectionCoord(var2 - 1);
        int var9 = SectionPosition.blockToSectionCoord(var2 + 1);
        if (var4 == var5 && var6 == var7 && var8 == var9) {
            var3.accept(SectionPosition.asLong(var4, var6, var8));
        } else {
            for (int var10 = var4; var10 <= var5; ++var10) {
                for (int var11 = var6; var11 <= var7; ++var11) {
                    for (int var12 = var8; var12 <= var9; ++var12) {
                        var3.accept(SectionPosition.asLong(var10, var11, var12));
                    }
                }
            }
        }
    }

    @Override
    public /* synthetic */ BaseBlockPosition offset(int n2, int n3, int n4) {
        return this.offset(n2, n3, n4);
    }
}

