/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.RegistryLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;

public class RegistryCodecs {
    private static <T> MapCodec<a<T>> withNameAndId(ResourceKey<? extends IRegistry<T>> var0, MapCodec<T> var1) {
        return RecordCodecBuilder.mapCodec(var2 -> var2.group((App)MinecraftKey.CODEC.xmap(ResourceKey.elementKey(var0), ResourceKey::location).fieldOf("name").forGetter(a::key), (App)Codec.INT.fieldOf("id").forGetter(a::id), (App)var1.forGetter(a::value)).apply((Applicative)var2, a::new));
    }

    public static <T> Codec<IRegistry<T>> networkCodec(ResourceKey<? extends IRegistry<T>> var02, Lifecycle var1, Codec<T> var22) {
        return RegistryCodecs.withNameAndId(var02, var22.fieldOf("element")).codec().listOf().xmap(var2 -> {
            RegistryMaterials var3 = new RegistryMaterials(var02, var1, null);
            for (a var5 : var2) {
                ((IRegistryWritable)var3).registerMapping(var5.id(), var5.key(), var5.value(), var1);
            }
            return var3;
        }, var0 -> {
            ImmutableList.Builder var1 = ImmutableList.builder();
            for (Object var3 : var0) {
                var1.add(new a(var0.getResourceKey(var3).get(), var0.getId(var3), var3));
            }
            return var1.build();
        });
    }

    public static <E> Codec<IRegistry<E>> dataPackAwareCodec(ResourceKey<? extends IRegistry<E>> var02, Lifecycle var1, Codec<E> var2) {
        Codec<Map<ResourceKey<E>, E>> var3 = RegistryCodecs.directCodec(var02, var2);
        Encoder var4 = var3.comap(var0 -> ImmutableMap.copyOf(var0.entrySet()));
        return Codec.of((Encoder)var4, RegistryCodecs.dataPackAwareDecoder(var02, var2, var3, var1), (String)("DataPackRegistryCodec for " + var02));
    }

    private static <E> Decoder<IRegistry<E>> dataPackAwareDecoder(final ResourceKey<? extends IRegistry<E>> var0, final Codec<E> var1, Decoder<Map<ResourceKey<E>, E>> var2, Lifecycle var3) {
        final Decoder var4 = var2.map(var22 -> {
            RegistryMaterials var32 = new RegistryMaterials(var0, var3, null);
            var22.forEach((var2, var3) -> var32.register(var2, var3, var3));
            return var32;
        });
        return new Decoder<IRegistry<E>>(){

            public <T> DataResult<Pair<IRegistry<E>, T>> decode(DynamicOps<T> var02, T var12) {
                DataResult var22 = var4.decode(var02, var12);
                if (var02 instanceof RegistryOps) {
                    RegistryOps var3 = (RegistryOps)var02;
                    return var3.registryLoader().map(var2 -> this.overrideFromResources(var22, var3, var2.loader())).orElseGet(() -> DataResult.error((String)"Can't load registry with this ops"));
                }
                return var22.map(var02 -> var02.mapFirst(var0 -> var0));
            }

            private <T> DataResult<Pair<IRegistry<E>, T>> overrideFromResources(DataResult<Pair<IRegistryWritable<E>, T>> var02, RegistryOps<?> var12, RegistryLoader var2) {
                return var02.flatMap(var4 -> var2.overrideRegistryFromResources((IRegistryWritable)var4.getFirst(), var0, var1, var12.getAsJson()).map(var1 -> Pair.of((Object)var1, (Object)var4.getSecond())));
            }
        };
    }

    private static <T> Codec<Map<ResourceKey<T>, T>> directCodec(ResourceKey<? extends IRegistry<T>> var0, Codec<T> var1) {
        return Codec.unboundedMap((Codec)MinecraftKey.CODEC.xmap(ResourceKey.elementKey(var0), ResourceKey::location), var1);
    }

    public static <E> Codec<HolderSet<E>> homogeneousList(ResourceKey<? extends IRegistry<E>> var0, Codec<E> var1) {
        return RegistryCodecs.homogeneousList(var0, var1, false);
    }

    public static <E> Codec<HolderSet<E>> homogeneousList(ResourceKey<? extends IRegistry<E>> var0, Codec<E> var1, boolean var2) {
        return HolderSetCodec.create(var0, RegistryFileCodec.create(var0, var1), var2);
    }

    public static <E> Codec<HolderSet<E>> homogeneousList(ResourceKey<? extends IRegistry<E>> var0) {
        return RegistryCodecs.homogeneousList(var0, false);
    }

    public static <E> Codec<HolderSet<E>> homogeneousList(ResourceKey<? extends IRegistry<E>> var0, boolean var1) {
        return HolderSetCodec.create(var0, RegistryFixedCodec.create(var0), var1);
    }

    record a<T>(ResourceKey<T> key, int id, T value) {
    }
}

