/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.Lifecycle;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryBlocks;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.Particles;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.valueproviders.FloatProviderType;
import net.minecraft.util.valueproviders.IntProviderType;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.decoration.Paintings;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverAbstract;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacers;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProviders;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTrees;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacers;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePools;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.storage.loot.entries.LootEntries;
import net.minecraft.world.level.storage.loot.entries.LootEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraft.world.level.storage.loot.providers.score.LootScoreProviderType;
import net.minecraft.world.level.storage.loot.providers.score.ScoreboardNameProviders;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public abstract class IRegistry<T>
implements Keyable,
Registry<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<MinecraftKey, Supplier<?>> LOADERS = Maps.newLinkedHashMap();
    public static final MinecraftKey ROOT_REGISTRY_NAME = new MinecraftKey("root");
    protected static final IRegistryWritable<IRegistryWritable<?>> WRITABLE_REGISTRY = new RegistryMaterials(IRegistry.createRegistryKey("root"), Lifecycle.experimental(), null);
    public static final IRegistry<? extends IRegistry<?>> REGISTRY = WRITABLE_REGISTRY;
    public static final ResourceKey<IRegistry<SoundEffect>> SOUND_EVENT_REGISTRY = IRegistry.createRegistryKey("sound_event");
    public static final ResourceKey<IRegistry<FluidType>> FLUID_REGISTRY = IRegistry.createRegistryKey("fluid");
    public static final ResourceKey<IRegistry<MobEffectList>> MOB_EFFECT_REGISTRY = IRegistry.createRegistryKey("mob_effect");
    public static final ResourceKey<IRegistry<Block>> BLOCK_REGISTRY = IRegistry.createRegistryKey("block");
    public static final ResourceKey<IRegistry<Enchantment>> ENCHANTMENT_REGISTRY = IRegistry.createRegistryKey("enchantment");
    public static final ResourceKey<IRegistry<EntityTypes<?>>> ENTITY_TYPE_REGISTRY = IRegistry.createRegistryKey("entity_type");
    public static final ResourceKey<IRegistry<Item>> ITEM_REGISTRY = IRegistry.createRegistryKey("item");
    public static final ResourceKey<IRegistry<PotionRegistry>> POTION_REGISTRY = IRegistry.createRegistryKey("potion");
    public static final ResourceKey<IRegistry<Particle<?>>> PARTICLE_TYPE_REGISTRY = IRegistry.createRegistryKey("particle_type");
    public static final ResourceKey<IRegistry<TileEntityTypes<?>>> BLOCK_ENTITY_TYPE_REGISTRY = IRegistry.createRegistryKey("block_entity_type");
    public static final ResourceKey<IRegistry<Paintings>> MOTIVE_REGISTRY = IRegistry.createRegistryKey("motive");
    public static final ResourceKey<IRegistry<MinecraftKey>> CUSTOM_STAT_REGISTRY = IRegistry.createRegistryKey("custom_stat");
    public static final ResourceKey<IRegistry<ChunkStatus>> CHUNK_STATUS_REGISTRY = IRegistry.createRegistryKey("chunk_status");
    public static final ResourceKey<IRegistry<DefinedStructureRuleTestType<?>>> RULE_TEST_REGISTRY = IRegistry.createRegistryKey("rule_test");
    public static final ResourceKey<IRegistry<PosRuleTestType<?>>> POS_RULE_TEST_REGISTRY = IRegistry.createRegistryKey("pos_rule_test");
    public static final ResourceKey<IRegistry<Containers<?>>> MENU_REGISTRY = IRegistry.createRegistryKey("menu");
    public static final ResourceKey<IRegistry<Recipes<?>>> RECIPE_TYPE_REGISTRY = IRegistry.createRegistryKey("recipe_type");
    public static final ResourceKey<IRegistry<RecipeSerializer<?>>> RECIPE_SERIALIZER_REGISTRY = IRegistry.createRegistryKey("recipe_serializer");
    public static final ResourceKey<IRegistry<AttributeBase>> ATTRIBUTE_REGISTRY = IRegistry.createRegistryKey("attribute");
    public static final ResourceKey<IRegistry<GameEvent>> GAME_EVENT_REGISTRY = IRegistry.createRegistryKey("game_event");
    public static final ResourceKey<IRegistry<PositionSourceType<?>>> POSITION_SOURCE_TYPE_REGISTRY = IRegistry.createRegistryKey("position_source_type");
    public static final ResourceKey<IRegistry<StatisticWrapper<?>>> STAT_TYPE_REGISTRY = IRegistry.createRegistryKey("stat_type");
    public static final ResourceKey<IRegistry<VillagerType>> VILLAGER_TYPE_REGISTRY = IRegistry.createRegistryKey("villager_type");
    public static final ResourceKey<IRegistry<VillagerProfession>> VILLAGER_PROFESSION_REGISTRY = IRegistry.createRegistryKey("villager_profession");
    public static final ResourceKey<IRegistry<VillagePlaceType>> POINT_OF_INTEREST_TYPE_REGISTRY = IRegistry.createRegistryKey("point_of_interest_type");
    public static final ResourceKey<IRegistry<MemoryModuleType<?>>> MEMORY_MODULE_TYPE_REGISTRY = IRegistry.createRegistryKey("memory_module_type");
    public static final ResourceKey<IRegistry<SensorType<?>>> SENSOR_TYPE_REGISTRY = IRegistry.createRegistryKey("sensor_type");
    public static final ResourceKey<IRegistry<Schedule>> SCHEDULE_REGISTRY = IRegistry.createRegistryKey("schedule");
    public static final ResourceKey<IRegistry<Activity>> ACTIVITY_REGISTRY = IRegistry.createRegistryKey("activity");
    public static final ResourceKey<IRegistry<LootEntryType>> LOOT_ENTRY_REGISTRY = IRegistry.createRegistryKey("loot_pool_entry_type");
    public static final ResourceKey<IRegistry<LootItemFunctionType>> LOOT_FUNCTION_REGISTRY = IRegistry.createRegistryKey("loot_function_type");
    public static final ResourceKey<IRegistry<LootItemConditionType>> LOOT_ITEM_REGISTRY = IRegistry.createRegistryKey("loot_condition_type");
    public static final ResourceKey<IRegistry<LootNumberProviderType>> LOOT_NUMBER_PROVIDER_REGISTRY = IRegistry.createRegistryKey("loot_number_provider_type");
    public static final ResourceKey<IRegistry<LootNbtProviderType>> LOOT_NBT_PROVIDER_REGISTRY = IRegistry.createRegistryKey("loot_nbt_provider_type");
    public static final ResourceKey<IRegistry<LootScoreProviderType>> LOOT_SCORE_PROVIDER_REGISTRY = IRegistry.createRegistryKey("loot_score_provider_type");
    public static final ResourceKey<IRegistry<DimensionManager>> DIMENSION_TYPE_REGISTRY = IRegistry.createRegistryKey("dimension_type");
    public static final ResourceKey<IRegistry<World>> DIMENSION_REGISTRY = IRegistry.createRegistryKey("dimension");
    public static final ResourceKey<IRegistry<WorldDimension>> LEVEL_STEM_REGISTRY = IRegistry.createRegistryKey("dimension");
    public static final RegistryBlocks<GameEvent> GAME_EVENT = IRegistry.registerDefaulted(GAME_EVENT_REGISTRY, "step", GameEvent::builtInRegistryHolder, (IRegistry<T> var0) -> GameEvent.STEP);
    public static final IRegistry<SoundEffect> SOUND_EVENT = IRegistry.registerSimple(SOUND_EVENT_REGISTRY, var0 -> SoundEffects.ITEM_PICKUP);
    public static final RegistryBlocks<FluidType> FLUID = IRegistry.registerDefaulted(FLUID_REGISTRY, "empty", FluidType::builtInRegistryHolder, (IRegistry<T> var0) -> FluidTypes.EMPTY);
    public static final IRegistry<MobEffectList> MOB_EFFECT = IRegistry.registerSimple(MOB_EFFECT_REGISTRY, var0 -> MobEffects.LUCK);
    public static final RegistryBlocks<Block> BLOCK = IRegistry.registerDefaulted(BLOCK_REGISTRY, "air", Block::builtInRegistryHolder, (IRegistry<T> var0) -> Blocks.AIR);
    public static final IRegistry<Enchantment> ENCHANTMENT = IRegistry.registerSimple(ENCHANTMENT_REGISTRY, var0 -> Enchantments.BLOCK_FORTUNE);
    public static final RegistryBlocks<EntityTypes<?>> ENTITY_TYPE = IRegistry.registerDefaulted(ENTITY_TYPE_REGISTRY, "pig", EntityTypes::builtInRegistryHolder, (IRegistry<T> var0) -> EntityTypes.PIG);
    public static final RegistryBlocks<Item> ITEM = IRegistry.registerDefaulted(ITEM_REGISTRY, "air", Item::builtInRegistryHolder, (IRegistry<T> var0) -> Items.AIR);
    public static final RegistryBlocks<PotionRegistry> POTION = IRegistry.registerDefaulted(POTION_REGISTRY, "empty", var0 -> Potions.EMPTY);
    public static final IRegistry<Particle<?>> PARTICLE_TYPE = IRegistry.registerSimple(PARTICLE_TYPE_REGISTRY, var0 -> Particles.BLOCK);
    public static final IRegistry<TileEntityTypes<?>> BLOCK_ENTITY_TYPE = IRegistry.registerSimple(BLOCK_ENTITY_TYPE_REGISTRY, var0 -> TileEntityTypes.FURNACE);
    public static final RegistryBlocks<Paintings> MOTIVE = IRegistry.registerDefaulted(MOTIVE_REGISTRY, "kebab", var0 -> Paintings.KEBAB);
    public static final IRegistry<MinecraftKey> CUSTOM_STAT = IRegistry.registerSimple(CUSTOM_STAT_REGISTRY, var0 -> StatisticList.JUMP);
    public static final RegistryBlocks<ChunkStatus> CHUNK_STATUS = IRegistry.registerDefaulted(CHUNK_STATUS_REGISTRY, "empty", var0 -> ChunkStatus.EMPTY);
    public static final IRegistry<DefinedStructureRuleTestType<?>> RULE_TEST = IRegistry.registerSimple(RULE_TEST_REGISTRY, var0 -> DefinedStructureRuleTestType.ALWAYS_TRUE_TEST);
    public static final IRegistry<PosRuleTestType<?>> POS_RULE_TEST = IRegistry.registerSimple(POS_RULE_TEST_REGISTRY, var0 -> PosRuleTestType.ALWAYS_TRUE_TEST);
    public static final IRegistry<Containers<?>> MENU = IRegistry.registerSimple(MENU_REGISTRY, var0 -> Containers.ANVIL);
    public static final IRegistry<Recipes<?>> RECIPE_TYPE = IRegistry.registerSimple(RECIPE_TYPE_REGISTRY, var0 -> Recipes.CRAFTING);
    public static final IRegistry<RecipeSerializer<?>> RECIPE_SERIALIZER = IRegistry.registerSimple(RECIPE_SERIALIZER_REGISTRY, var0 -> RecipeSerializer.SHAPELESS_RECIPE);
    public static final IRegistry<AttributeBase> ATTRIBUTE = IRegistry.registerSimple(ATTRIBUTE_REGISTRY, var0 -> GenericAttributes.LUCK);
    public static final IRegistry<PositionSourceType<?>> POSITION_SOURCE_TYPE = IRegistry.registerSimple(POSITION_SOURCE_TYPE_REGISTRY, var0 -> PositionSourceType.BLOCK);
    public static final IRegistry<StatisticWrapper<?>> STAT_TYPE = IRegistry.registerSimple(STAT_TYPE_REGISTRY, var0 -> StatisticList.ITEM_USED);
    public static final RegistryBlocks<VillagerType> VILLAGER_TYPE = IRegistry.registerDefaulted(VILLAGER_TYPE_REGISTRY, "plains", var0 -> VillagerType.PLAINS);
    public static final RegistryBlocks<VillagerProfession> VILLAGER_PROFESSION = IRegistry.registerDefaulted(VILLAGER_PROFESSION_REGISTRY, "none", var0 -> VillagerProfession.NONE);
    public static final RegistryBlocks<VillagePlaceType> POINT_OF_INTEREST_TYPE = IRegistry.registerDefaulted(POINT_OF_INTEREST_TYPE_REGISTRY, "unemployed", var0 -> VillagePlaceType.UNEMPLOYED);
    public static final RegistryBlocks<MemoryModuleType<?>> MEMORY_MODULE_TYPE = IRegistry.registerDefaulted(MEMORY_MODULE_TYPE_REGISTRY, "dummy", var0 -> MemoryModuleType.DUMMY);
    public static final RegistryBlocks<SensorType<?>> SENSOR_TYPE = IRegistry.registerDefaulted(SENSOR_TYPE_REGISTRY, "dummy", var0 -> SensorType.DUMMY);
    public static final IRegistry<Schedule> SCHEDULE = IRegistry.registerSimple(SCHEDULE_REGISTRY, var0 -> Schedule.EMPTY);
    public static final IRegistry<Activity> ACTIVITY = IRegistry.registerSimple(ACTIVITY_REGISTRY, var0 -> Activity.IDLE);
    public static final IRegistry<LootEntryType> LOOT_POOL_ENTRY_TYPE = IRegistry.registerSimple(LOOT_ENTRY_REGISTRY, var0 -> LootEntries.EMPTY);
    public static final IRegistry<LootItemFunctionType> LOOT_FUNCTION_TYPE = IRegistry.registerSimple(LOOT_FUNCTION_REGISTRY, var0 -> LootItemFunctions.SET_COUNT);
    public static final IRegistry<LootItemConditionType> LOOT_CONDITION_TYPE = IRegistry.registerSimple(LOOT_ITEM_REGISTRY, var0 -> LootItemConditions.INVERTED);
    public static final IRegistry<LootNumberProviderType> LOOT_NUMBER_PROVIDER_TYPE = IRegistry.registerSimple(LOOT_NUMBER_PROVIDER_REGISTRY, var0 -> NumberProviders.CONSTANT);
    public static final IRegistry<LootNbtProviderType> LOOT_NBT_PROVIDER_TYPE = IRegistry.registerSimple(LOOT_NBT_PROVIDER_REGISTRY, var0 -> NbtProviders.CONTEXT);
    public static final IRegistry<LootScoreProviderType> LOOT_SCORE_PROVIDER_TYPE = IRegistry.registerSimple(LOOT_SCORE_PROVIDER_REGISTRY, var0 -> ScoreboardNameProviders.CONTEXT);
    public static final ResourceKey<IRegistry<FloatProviderType<?>>> FLOAT_PROVIDER_TYPE_REGISTRY = IRegistry.createRegistryKey("float_provider_type");
    public static final IRegistry<FloatProviderType<?>> FLOAT_PROVIDER_TYPES = IRegistry.registerSimple(FLOAT_PROVIDER_TYPE_REGISTRY, var0 -> FloatProviderType.CONSTANT);
    public static final ResourceKey<IRegistry<IntProviderType<?>>> INT_PROVIDER_TYPE_REGISTRY = IRegistry.createRegistryKey("int_provider_type");
    public static final IRegistry<IntProviderType<?>> INT_PROVIDER_TYPES = IRegistry.registerSimple(INT_PROVIDER_TYPE_REGISTRY, var0 -> IntProviderType.CONSTANT);
    public static final ResourceKey<IRegistry<HeightProviderType<?>>> HEIGHT_PROVIDER_TYPE_REGISTRY = IRegistry.createRegistryKey("height_provider_type");
    public static final IRegistry<HeightProviderType<?>> HEIGHT_PROVIDER_TYPES = IRegistry.registerSimple(HEIGHT_PROVIDER_TYPE_REGISTRY, var0 -> HeightProviderType.CONSTANT);
    public static final ResourceKey<IRegistry<BlockPredicateType<?>>> BLOCK_PREDICATE_TYPE_REGISTRY = IRegistry.createRegistryKey("block_predicate_type");
    public static final IRegistry<BlockPredicateType<?>> BLOCK_PREDICATE_TYPES = IRegistry.registerSimple(BLOCK_PREDICATE_TYPE_REGISTRY, var0 -> BlockPredicateType.NOT);
    public static final ResourceKey<IRegistry<GeneratorSettingBase>> NOISE_GENERATOR_SETTINGS_REGISTRY = IRegistry.createRegistryKey("worldgen/noise_settings");
    public static final ResourceKey<IRegistry<WorldGenCarverWrapper<?>>> CONFIGURED_CARVER_REGISTRY = IRegistry.createRegistryKey("worldgen/configured_carver");
    public static final ResourceKey<IRegistry<WorldGenFeatureConfigured<?, ?>>> CONFIGURED_FEATURE_REGISTRY = IRegistry.createRegistryKey("worldgen/configured_feature");
    public static final ResourceKey<IRegistry<PlacedFeature>> PLACED_FEATURE_REGISTRY = IRegistry.createRegistryKey("worldgen/placed_feature");
    public static final ResourceKey<IRegistry<StructureFeature<?, ?>>> CONFIGURED_STRUCTURE_FEATURE_REGISTRY = IRegistry.createRegistryKey("worldgen/configured_structure_feature");
    public static final ResourceKey<IRegistry<StructureSet>> STRUCTURE_SET_REGISTRY = IRegistry.createRegistryKey("worldgen/structure_set");
    public static final ResourceKey<IRegistry<ProcessorList>> PROCESSOR_LIST_REGISTRY = IRegistry.createRegistryKey("worldgen/processor_list");
    public static final ResourceKey<IRegistry<WorldGenFeatureDefinedStructurePoolTemplate>> TEMPLATE_POOL_REGISTRY = IRegistry.createRegistryKey("worldgen/template_pool");
    public static final ResourceKey<IRegistry<BiomeBase>> BIOME_REGISTRY = IRegistry.createRegistryKey("worldgen/biome");
    public static final ResourceKey<IRegistry<NoiseGeneratorNormal.a>> NOISE_REGISTRY = IRegistry.createRegistryKey("worldgen/noise");
    public static final ResourceKey<IRegistry<DensityFunction>> DENSITY_FUNCTION_REGISTRY = IRegistry.createRegistryKey("worldgen/density_function");
    public static final ResourceKey<IRegistry<WorldGenCarverAbstract<?>>> CARVER_REGISTRY = IRegistry.createRegistryKey("worldgen/carver");
    public static final IRegistry<WorldGenCarverAbstract<?>> CARVER = IRegistry.registerSimple(CARVER_REGISTRY, var0 -> WorldGenCarverAbstract.CAVE);
    public static final ResourceKey<IRegistry<WorldGenerator<?>>> FEATURE_REGISTRY = IRegistry.createRegistryKey("worldgen/feature");
    public static final IRegistry<WorldGenerator<?>> FEATURE = IRegistry.registerSimple(FEATURE_REGISTRY, var0 -> WorldGenerator.ORE);
    public static final ResourceKey<IRegistry<StructureGenerator<?>>> STRUCTURE_FEATURE_REGISTRY = IRegistry.createRegistryKey("worldgen/structure_feature");
    public static final IRegistry<StructureGenerator<?>> STRUCTURE_FEATURE = IRegistry.registerSimple(STRUCTURE_FEATURE_REGISTRY, var0 -> StructureGenerator.MINESHAFT);
    public static final ResourceKey<IRegistry<StructurePlacementType<?>>> STRUCTURE_PLACEMENT_TYPE_REGISTRY = IRegistry.createRegistryKey("worldgen/structure_placement");
    public static final IRegistry<StructurePlacementType<?>> STRUCTURE_PLACEMENT_TYPE = IRegistry.registerSimple(STRUCTURE_PLACEMENT_TYPE_REGISTRY, var0 -> StructurePlacementType.RANDOM_SPREAD);
    public static final ResourceKey<IRegistry<WorldGenFeatureStructurePieceType>> STRUCTURE_PIECE_REGISTRY = IRegistry.createRegistryKey("worldgen/structure_piece");
    public static final IRegistry<WorldGenFeatureStructurePieceType> STRUCTURE_PIECE = IRegistry.registerSimple(STRUCTURE_PIECE_REGISTRY, var0 -> WorldGenFeatureStructurePieceType.MINE_SHAFT_ROOM);
    public static final ResourceKey<IRegistry<PlacementModifierType<?>>> PLACEMENT_MODIFIER_REGISTRY = IRegistry.createRegistryKey("worldgen/placement_modifier_type");
    public static final IRegistry<PlacementModifierType<?>> PLACEMENT_MODIFIERS = IRegistry.registerSimple(PLACEMENT_MODIFIER_REGISTRY, var0 -> PlacementModifierType.COUNT);
    public static final ResourceKey<IRegistry<WorldGenFeatureStateProviders<?>>> BLOCK_STATE_PROVIDER_TYPE_REGISTRY = IRegistry.createRegistryKey("worldgen/block_state_provider_type");
    public static final ResourceKey<IRegistry<WorldGenFoilagePlacers<?>>> FOLIAGE_PLACER_TYPE_REGISTRY = IRegistry.createRegistryKey("worldgen/foliage_placer_type");
    public static final ResourceKey<IRegistry<TrunkPlacers<?>>> TRUNK_PLACER_TYPE_REGISTRY = IRegistry.createRegistryKey("worldgen/trunk_placer_type");
    public static final ResourceKey<IRegistry<WorldGenFeatureTrees<?>>> TREE_DECORATOR_TYPE_REGISTRY = IRegistry.createRegistryKey("worldgen/tree_decorator_type");
    public static final ResourceKey<IRegistry<FeatureSizeType<?>>> FEATURE_SIZE_TYPE_REGISTRY = IRegistry.createRegistryKey("worldgen/feature_size_type");
    public static final ResourceKey<IRegistry<Codec<? extends WorldChunkManager>>> BIOME_SOURCE_REGISTRY = IRegistry.createRegistryKey("worldgen/biome_source");
    public static final ResourceKey<IRegistry<Codec<? extends ChunkGenerator>>> CHUNK_GENERATOR_REGISTRY = IRegistry.createRegistryKey("worldgen/chunk_generator");
    public static final ResourceKey<IRegistry<Codec<? extends SurfaceRules.f>>> CONDITION_REGISTRY = IRegistry.createRegistryKey("worldgen/material_condition");
    public static final ResourceKey<IRegistry<Codec<? extends SurfaceRules.o>>> RULE_REGISTRY = IRegistry.createRegistryKey("worldgen/material_rule");
    public static final ResourceKey<IRegistry<Codec<? extends DensityFunction>>> DENSITY_FUNCTION_TYPE_REGISTRY = IRegistry.createRegistryKey("worldgen/density_function_type");
    public static final ResourceKey<IRegistry<DefinedStructureStructureProcessorType<?>>> STRUCTURE_PROCESSOR_REGISTRY = IRegistry.createRegistryKey("worldgen/structure_processor");
    public static final ResourceKey<IRegistry<WorldGenFeatureDefinedStructurePools<?>>> STRUCTURE_POOL_ELEMENT_REGISTRY = IRegistry.createRegistryKey("worldgen/structure_pool_element");
    public static final IRegistry<WorldGenFeatureStateProviders<?>> BLOCKSTATE_PROVIDER_TYPES = IRegistry.registerSimple(BLOCK_STATE_PROVIDER_TYPE_REGISTRY, var0 -> WorldGenFeatureStateProviders.SIMPLE_STATE_PROVIDER);
    public static final IRegistry<WorldGenFoilagePlacers<?>> FOLIAGE_PLACER_TYPES = IRegistry.registerSimple(FOLIAGE_PLACER_TYPE_REGISTRY, var0 -> WorldGenFoilagePlacers.BLOB_FOLIAGE_PLACER);
    public static final IRegistry<TrunkPlacers<?>> TRUNK_PLACER_TYPES = IRegistry.registerSimple(TRUNK_PLACER_TYPE_REGISTRY, var0 -> TrunkPlacers.STRAIGHT_TRUNK_PLACER);
    public static final IRegistry<WorldGenFeatureTrees<?>> TREE_DECORATOR_TYPES = IRegistry.registerSimple(TREE_DECORATOR_TYPE_REGISTRY, var0 -> WorldGenFeatureTrees.LEAVE_VINE);
    public static final IRegistry<FeatureSizeType<?>> FEATURE_SIZE_TYPES = IRegistry.registerSimple(FEATURE_SIZE_TYPE_REGISTRY, var0 -> FeatureSizeType.TWO_LAYERS_FEATURE_SIZE);
    public static final IRegistry<Codec<? extends WorldChunkManager>> BIOME_SOURCE = IRegistry.registerSimple(BIOME_SOURCE_REGISTRY, Lifecycle.stable(), var0 -> WorldChunkManager.CODEC);
    public static final IRegistry<Codec<? extends ChunkGenerator>> CHUNK_GENERATOR = IRegistry.registerSimple(CHUNK_GENERATOR_REGISTRY, Lifecycle.stable(), var0 -> ChunkGenerator.CODEC);
    public static final IRegistry<Codec<? extends SurfaceRules.f>> CONDITION = IRegistry.registerSimple(CONDITION_REGISTRY, SurfaceRules.f::bootstrap);
    public static final IRegistry<Codec<? extends SurfaceRules.o>> RULE = IRegistry.registerSimple(RULE_REGISTRY, SurfaceRules.o::bootstrap);
    public static final IRegistry<Codec<? extends DensityFunction>> DENSITY_FUNCTION_TYPES = IRegistry.registerSimple(DENSITY_FUNCTION_TYPE_REGISTRY, DensityFunctions::bootstrap);
    public static final IRegistry<DefinedStructureStructureProcessorType<?>> STRUCTURE_PROCESSOR = IRegistry.registerSimple(STRUCTURE_PROCESSOR_REGISTRY, var0 -> DefinedStructureStructureProcessorType.BLOCK_IGNORE);
    public static final IRegistry<WorldGenFeatureDefinedStructurePools<?>> STRUCTURE_POOL_ELEMENT = IRegistry.registerSimple(STRUCTURE_POOL_ELEMENT_REGISTRY, var0 -> WorldGenFeatureDefinedStructurePools.EMPTY);
    private final ResourceKey<? extends IRegistry<T>> key;
    private final Lifecycle lifecycle;

    private static <T> ResourceKey<IRegistry<T>> createRegistryKey(String var0) {
        return ResourceKey.createRegistryKey(new MinecraftKey(var0));
    }

    public static <T extends IRegistry<?>> void checkRegistry(IRegistry<T> var0) {
        var0.forEach(var1 -> {
            if (var1.keySet().isEmpty()) {
                SystemUtils.logAndPauseIfInIde("Registry '" + var0.getKey(var1) + "' was empty after loading");
            }
            if (var1 instanceof RegistryBlocks) {
                MinecraftKey var2 = ((RegistryBlocks)var1).getDefaultKey();
                Validate.notNull(var1.get(var2), (String)("Missing default of DefaultedMappedRegistry: " + var2), (Object[])new Object[0]);
            }
        });
    }

    private static <T> IRegistry<T> registerSimple(ResourceKey<? extends IRegistry<T>> var0, a<T> var1) {
        return IRegistry.registerSimple(var0, Lifecycle.experimental(), var1);
    }

    private static <T> RegistryBlocks<T> registerDefaulted(ResourceKey<? extends IRegistry<T>> var0, String var1, a<T> var2) {
        return IRegistry.registerDefaulted(var0, var1, Lifecycle.experimental(), var2);
    }

    private static <T> RegistryBlocks<T> registerDefaulted(ResourceKey<? extends IRegistry<T>> var0, String var1, Function<T, Holder.c<T>> var2, a<T> var3) {
        return IRegistry.registerDefaulted(var0, var1, Lifecycle.experimental(), var2, var3);
    }

    private static <T> IRegistry<T> registerSimple(ResourceKey<? extends IRegistry<T>> var0, Lifecycle var1, a<T> var2) {
        return IRegistry.internalRegister(var0, new RegistryMaterials(var0, var1, null), var2, var1);
    }

    private static <T> IRegistry<T> registerSimple(ResourceKey<? extends IRegistry<T>> var0, Lifecycle var1, Function<T, Holder.c<T>> var2, a<T> var3) {
        return IRegistry.internalRegister(var0, new RegistryMaterials<T>(var0, var1, var2), var3, var1);
    }

    private static <T> RegistryBlocks<T> registerDefaulted(ResourceKey<? extends IRegistry<T>> var0, String var1, Lifecycle var2, a<T> var3) {
        return IRegistry.internalRegister(var0, new RegistryBlocks(var1, var0, var2, null), var3, var2);
    }

    private static <T> RegistryBlocks<T> registerDefaulted(ResourceKey<? extends IRegistry<T>> var0, String var1, Lifecycle var2, Function<T, Holder.c<T>> var3, a<T> var4) {
        return IRegistry.internalRegister(var0, new RegistryBlocks<T>(var1, var0, var2, var3), var4, var2);
    }

    private static <T, R extends IRegistryWritable<T>> R internalRegister(ResourceKey<? extends IRegistry<T>> var0, R var1, a<T> var2, Lifecycle var3) {
        MinecraftKey var4 = var0.location();
        LOADERS.put(var4, () -> var2.run(var1));
        WRITABLE_REGISTRY.register(var0, var1, var3);
        return var1;
    }

    protected IRegistry(ResourceKey<? extends IRegistry<T>> var0, Lifecycle var1) {
        DispenserRegistry.checkBootstrapCalled(() -> "registry " + var0);
        this.key = var0;
        this.lifecycle = var1;
    }

    public static void freezeBuiltins() {
        for (IRegistry iRegistry : REGISTRY) {
            iRegistry.freeze();
        }
    }

    public ResourceKey<? extends IRegistry<T>> key() {
        return this.key;
    }

    public Lifecycle lifecycle() {
        return this.lifecycle;
    }

    public String toString() {
        return "Registry[" + this.key + " (" + this.lifecycle + ")]";
    }

    public Codec<T> byNameCodec() {
        Codec var02 = MinecraftKey.CODEC.flatXmap(var0 -> Optional.ofNullable(this.get((MinecraftKey)var0)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown registry key in " + this.key + ": " + var0))), var0 -> this.getResourceKey(var0).map(ResourceKey::location).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown registry element in " + this.key + ":" + var0))));
        Codec<Object> var1 = ExtraCodecs.idResolverCodec(var0 -> this.getResourceKey(var0).isPresent() ? this.getId(var0) : -1, this::byId, -1);
        return ExtraCodecs.overrideLifecycle(ExtraCodecs.orCompressed(var02, var1), this::lifecycle, var0 -> this.lifecycle);
    }

    public Codec<Holder<T>> holderByNameCodec() {
        Codec var02 = MinecraftKey.CODEC.flatXmap(var0 -> this.getHolder(ResourceKey.create(this.key, var0)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown registry key in " + this.key + ": " + var0))), var0 -> var0.unwrapKey().map(ResourceKey::location).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown registry element in " + this.key + ":" + var0))));
        return ExtraCodecs.overrideLifecycle(var02, var0 -> this.lifecycle(var0.value()), var0 -> this.lifecycle);
    }

    public <U> Stream<U> keys(DynamicOps<U> var0) {
        return this.keySet().stream().map(var1 -> var0.createString(var1.toString()));
    }

    @Nullable
    public abstract MinecraftKey getKey(T var1);

    public abstract Optional<ResourceKey<T>> getResourceKey(T var1);

    @Override
    public abstract int getId(@Nullable T var1);

    @Nullable
    public abstract T get(@Nullable ResourceKey<T> var1);

    @Nullable
    public abstract T get(@Nullable MinecraftKey var1);

    public abstract Lifecycle lifecycle(T var1);

    public abstract Lifecycle elementsLifecycle();

    public Optional<T> getOptional(@Nullable MinecraftKey var0) {
        return Optional.ofNullable(this.get(var0));
    }

    public Optional<T> getOptional(@Nullable ResourceKey<T> var0) {
        return Optional.ofNullable(this.get(var0));
    }

    public T getOrThrow(ResourceKey<T> var0) {
        T var1 = this.get(var0);
        if (var1 == null) {
            throw new IllegalStateException("Missing key in " + this.key + ": " + var0);
        }
        return var1;
    }

    public abstract Set<MinecraftKey> keySet();

    public abstract Set<Map.Entry<ResourceKey<T>, T>> entrySet();

    public abstract Optional<Holder<T>> getRandom(Random var1);

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public abstract boolean containsKey(MinecraftKey var1);

    public abstract boolean containsKey(ResourceKey<T> var1);

    public static <T> T register(IRegistry<? super T> var0, String var1, T var2) {
        return IRegistry.register(var0, new MinecraftKey(var1), var2);
    }

    public static <V, T extends V> T register(IRegistry<V> var0, MinecraftKey var1, T var2) {
        return IRegistry.register(var0, ResourceKey.create(var0.key, var1), var2);
    }

    public static <V, T extends V> T register(IRegistry<V> var0, ResourceKey<V> var1, T var2) {
        ((IRegistryWritable)var0).register(var1, var2, Lifecycle.stable());
        return var2;
    }

    public static <V, T extends V> T registerMapping(IRegistry<V> var0, int var1, String var2, T var3) {
        ((IRegistryWritable)var0).registerMapping(var1, ResourceKey.create(var0.key, new MinecraftKey(var2)), var3, Lifecycle.stable());
        return var3;
    }

    public abstract IRegistry<T> freeze();

    public abstract Holder<T> getOrCreateHolder(ResourceKey<T> var1);

    public abstract Holder.c<T> createIntrusiveHolder(T var1);

    public abstract Optional<Holder<T>> getHolder(int var1);

    public abstract Optional<Holder<T>> getHolder(ResourceKey<T> var1);

    public Holder<T> getHolderOrThrow(ResourceKey<T> var0) {
        return this.getHolder(var0).orElseThrow(() -> new IllegalStateException("Missing key in " + this.key + ": " + var0));
    }

    public abstract Stream<Holder.c<T>> holders();

    public abstract Optional<HolderSet.Named<T>> getTag(TagKey<T> var1);

    public Iterable<Holder<T>> getTagOrEmpty(TagKey<T> var0) {
        return (Iterable)DataFixUtils.orElse(this.getTag(var0), List.of());
    }

    public abstract HolderSet.Named<T> getOrCreateTag(TagKey<T> var1);

    public abstract Stream<Pair<TagKey<T>, HolderSet.Named<T>>> getTags();

    public abstract Stream<TagKey<T>> getTagNames();

    public abstract boolean isKnownTagName(TagKey<T> var1);

    public abstract void resetTags();

    public abstract void bindTags(Map<TagKey<T>, List<Holder<T>>> var1);

    public Registry<Holder<T>> asHolderIdMap() {
        return new Registry<Holder<T>>(){

            @Override
            public int getId(Holder<T> var0) {
                return IRegistry.this.getId(var0.value());
            }

            @Override
            @Nullable
            public Holder<T> byId(int var0) {
                return IRegistry.this.getHolder(var0).orElse(null);
            }

            @Override
            public int size() {
                return IRegistry.this.size();
            }

            @Override
            public Iterator<Holder<T>> iterator() {
                return IRegistry.this.holders().map(var0 -> var0).iterator();
            }

            @Override
            @Nullable
            public /* synthetic */ Object byId(int n2) {
                return this.byId(n2);
            }
        };
    }

    static {
        RegistryGeneration.bootstrap();
        LOADERS.forEach((? super K var0, ? super V var1) -> {
            if (var1.get() == null) {
                LOGGER.error("Unable to bootstrap registry '{}'", var0);
            }
        });
        IRegistry.checkRegistry(WRITABLE_REGISTRY);
    }

    @FunctionalInterface
    static interface a<T> {
        public T run(IRegistry<T> var1);
    }
}

