/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization.brigadier;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.brigadier.ArgumentSerializers;
import net.minecraft.network.PacketDataSerializer;

public class ArgumentSerializerLong
implements ArgumentSerializer<LongArgumentType> {
    @Override
    public void serializeToNetwork(LongArgumentType var0, PacketDataSerializer var1) {
        boolean var2 = var0.getMinimum() != Long.MIN_VALUE;
        boolean var3 = var0.getMaximum() != Long.MAX_VALUE;
        var1.writeByte(ArgumentSerializers.createNumberFlags(var2, var3));
        if (var2) {
            var1.writeLong(var0.getMinimum());
        }
        if (var3) {
            var1.writeLong(var0.getMaximum());
        }
    }

    @Override
    public LongArgumentType deserializeFromNetwork(PacketDataSerializer var0) {
        byte var1 = var0.readByte();
        long var2 = ArgumentSerializers.numberHasMin(var1) ? var0.readLong() : Long.MIN_VALUE;
        long var4 = ArgumentSerializers.numberHasMax(var1) ? var0.readLong() : Long.MAX_VALUE;
        return LongArgumentType.longArg((long)var2, (long)var4);
    }

    @Override
    public void serializeToJson(LongArgumentType var0, JsonObject var1) {
        if (var0.getMinimum() != Long.MIN_VALUE) {
            var1.addProperty("min", (Number)var0.getMinimum());
        }
        if (var0.getMaximum() != Long.MAX_VALUE) {
            var1.addProperty("max", (Number)var0.getMaximum());
        }
    }

    @Override
    public /* synthetic */ ArgumentType deserializeFromNetwork(PacketDataSerializer packetDataSerializer) {
        return this.deserializeFromNetwork(packetDataSerializer);
    }
}

