/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization.brigadier;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.brigadier.ArgumentSerializers;
import net.minecraft.network.PacketDataSerializer;

public class ArgumentSerializerFloat
implements ArgumentSerializer<FloatArgumentType> {
    @Override
    public void serializeToNetwork(FloatArgumentType var0, PacketDataSerializer var1) {
        boolean var2 = var0.getMinimum() != -3.4028235E38f;
        boolean var3 = var0.getMaximum() != Float.MAX_VALUE;
        var1.writeByte(ArgumentSerializers.createNumberFlags(var2, var3));
        if (var2) {
            var1.writeFloat(var0.getMinimum());
        }
        if (var3) {
            var1.writeFloat(var0.getMaximum());
        }
    }

    @Override
    public FloatArgumentType deserializeFromNetwork(PacketDataSerializer var0) {
        byte var1 = var0.readByte();
        float var2 = ArgumentSerializers.numberHasMin(var1) ? var0.readFloat() : -3.4028235E38f;
        float var3 = ArgumentSerializers.numberHasMax(var1) ? var0.readFloat() : Float.MAX_VALUE;
        return FloatArgumentType.floatArg((float)var2, (float)var3);
    }

    @Override
    public void serializeToJson(FloatArgumentType var0, JsonObject var1) {
        if (var0.getMinimum() != -3.4028235E38f) {
            var1.addProperty("min", (Number)Float.valueOf(var0.getMinimum()));
        }
        if (var0.getMaximum() != Float.MAX_VALUE) {
            var1.addProperty("max", (Number)Float.valueOf(var0.getMaximum()));
        }
    }

    @Override
    public /* synthetic */ ArgumentType deserializeFromNetwork(PacketDataSerializer packetDataSerializer) {
        return this.deserializeFromNetwork(packetDataSerializer);
    }
}

