/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization;

import com.google.common.collect.Maps;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.core.IRegistry;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.EntityTypes;

public class CompletionProviders {
    private static final Map<MinecraftKey, SuggestionProvider<ICompletionProvider>> PROVIDERS_BY_NAME = Maps.newHashMap();
    private static final MinecraftKey DEFAULT_NAME = new MinecraftKey("ask_server");
    public static final SuggestionProvider<ICompletionProvider> ASK_SERVER = CompletionProviders.register(DEFAULT_NAME, (SuggestionProvider<ICompletionProvider>)((SuggestionProvider)(var0, var1) -> ((ICompletionProvider)var0.getSource()).customSuggestion(var0)));
    public static final SuggestionProvider<CommandListenerWrapper> ALL_RECIPES = CompletionProviders.register(new MinecraftKey("all_recipes"), (SuggestionProvider<ICompletionProvider>)((SuggestionProvider)(var0, var1) -> ICompletionProvider.suggestResource(((ICompletionProvider)var0.getSource()).getRecipeNames(), var1)));
    public static final SuggestionProvider<CommandListenerWrapper> AVAILABLE_SOUNDS = CompletionProviders.register(new MinecraftKey("available_sounds"), (SuggestionProvider<ICompletionProvider>)((SuggestionProvider)(var0, var1) -> ICompletionProvider.suggestResource(((ICompletionProvider)var0.getSource()).getAvailableSoundEvents(), var1)));
    public static final SuggestionProvider<CommandListenerWrapper> SUMMONABLE_ENTITIES = CompletionProviders.register(new MinecraftKey("summonable_entities"), (SuggestionProvider<ICompletionProvider>)((SuggestionProvider)(var02, var1) -> ICompletionProvider.suggestResource(IRegistry.ENTITY_TYPE.stream().filter(EntityTypes::canSummon), var1, EntityTypes::getKey, var0 -> new ChatMessage(SystemUtils.makeDescriptionId("entity", EntityTypes.getKey(var0))))));

    public static <S extends ICompletionProvider> SuggestionProvider<S> register(MinecraftKey var0, SuggestionProvider<ICompletionProvider> var1) {
        if (PROVIDERS_BY_NAME.containsKey(var0)) {
            throw new IllegalArgumentException("A command suggestion provider is already registered with the name " + var0);
        }
        PROVIDERS_BY_NAME.put(var0, var1);
        return new a(var0, var1);
    }

    public static SuggestionProvider<ICompletionProvider> getProvider(MinecraftKey var0) {
        return PROVIDERS_BY_NAME.getOrDefault(var0, ASK_SERVER);
    }

    public static MinecraftKey getName(SuggestionProvider<ICompletionProvider> var0) {
        if (var0 instanceof a) {
            return ((a)var0).name;
        }
        return DEFAULT_NAME;
    }

    public static SuggestionProvider<ICompletionProvider> safelySwap(SuggestionProvider<ICompletionProvider> var0) {
        if (var0 instanceof a) {
            return var0;
        }
        return ASK_SERVER;
    }

    protected static class a
    implements SuggestionProvider<ICompletionProvider> {
        private final SuggestionProvider<ICompletionProvider> delegate;
        final MinecraftKey name;

        public a(MinecraftKey var0, SuggestionProvider<ICompletionProvider> var1) {
            this.delegate = var1;
            this.name = var0;
        }

        public CompletableFuture<Suggestions> getSuggestions(CommandContext<ICompletionProvider> var0, SuggestionsBuilder var1) throws CommandSyntaxException {
            return this.delegate.getSuggestions(var0, var1);
        }
    }
}

