/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.selector;

import com.google.common.primitives.Doubles;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionRange;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.options.PlayerSelector;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class ArgumentParserSelector {
    public static final char SYNTAX_SELECTOR_START = '@';
    private static final char SYNTAX_OPTIONS_START = '[';
    private static final char SYNTAX_OPTIONS_END = ']';
    public static final char SYNTAX_OPTIONS_KEY_VALUE_SEPARATOR = '=';
    private static final char SYNTAX_OPTIONS_SEPARATOR = ',';
    public static final char SYNTAX_NOT = '!';
    public static final char SYNTAX_TAG = '#';
    private static final char SELECTOR_NEAREST_PLAYER = 'p';
    private static final char SELECTOR_ALL_PLAYERS = 'a';
    private static final char SELECTOR_RANDOM_PLAYERS = 'r';
    private static final char SELECTOR_CURRENT_ENTITY = 's';
    private static final char SELECTOR_ALL_ENTITIES = 'e';
    public static final SimpleCommandExceptionType ERROR_INVALID_NAME_OR_UUID = new SimpleCommandExceptionType((Message)new ChatMessage("argument.entity.invalid"));
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_SELECTOR_TYPE = new DynamicCommandExceptionType(var0 -> new ChatMessage("argument.entity.selector.unknown", var0));
    public static final SimpleCommandExceptionType ERROR_SELECTORS_NOT_ALLOWED = new SimpleCommandExceptionType((Message)new ChatMessage("argument.entity.selector.not_allowed"));
    public static final SimpleCommandExceptionType ERROR_MISSING_SELECTOR_TYPE = new SimpleCommandExceptionType((Message)new ChatMessage("argument.entity.selector.missing"));
    public static final SimpleCommandExceptionType ERROR_EXPECTED_END_OF_OPTIONS = new SimpleCommandExceptionType((Message)new ChatMessage("argument.entity.options.unterminated"));
    public static final DynamicCommandExceptionType ERROR_EXPECTED_OPTION_VALUE = new DynamicCommandExceptionType(var0 -> new ChatMessage("argument.entity.options.valueless", var0));
    public static final BiConsumer<Vec3D, List<? extends Entity>> ORDER_ARBITRARY = (var0, var1) -> {};
    public static final BiConsumer<Vec3D, List<? extends Entity>> ORDER_NEAREST = (var0, var12) -> var12.sort((var1, var2) -> Doubles.compare((double)var1.distanceToSqr((Vec3D)var0), (double)var2.distanceToSqr((Vec3D)var0)));
    public static final BiConsumer<Vec3D, List<? extends Entity>> ORDER_FURTHEST = (var0, var12) -> var12.sort((var1, var2) -> Doubles.compare((double)var2.distanceToSqr((Vec3D)var0), (double)var1.distanceToSqr((Vec3D)var0)));
    public static final BiConsumer<Vec3D, List<? extends Entity>> ORDER_RANDOM = (var0, var1) -> Collections.shuffle(var1);
    public static final BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> SUGGEST_NOTHING = (var0, var1) -> var0.buildFuture();
    private final StringReader reader;
    private final boolean allowSelectors;
    private int maxResults;
    private boolean includesEntities;
    private boolean worldLimited;
    private CriterionConditionValue.DoubleRange distance = CriterionConditionValue.DoubleRange.ANY;
    private CriterionConditionValue.IntegerRange level = CriterionConditionValue.IntegerRange.ANY;
    @Nullable
    private Double x;
    @Nullable
    private Double y;
    @Nullable
    private Double z;
    @Nullable
    private Double deltaX;
    @Nullable
    private Double deltaY;
    @Nullable
    private Double deltaZ;
    private CriterionConditionRange rotX = CriterionConditionRange.ANY;
    private CriterionConditionRange rotY = CriterionConditionRange.ANY;
    private Predicate<Entity> predicate = var0 -> true;
    private BiConsumer<Vec3D, List<? extends Entity>> order = ORDER_ARBITRARY;
    private boolean currentEntity;
    @Nullable
    private String playerName;
    private int startPosition;
    @Nullable
    private UUID entityUUID;
    private BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> suggestions = SUGGEST_NOTHING;
    private boolean hasNameEquals;
    private boolean hasNameNotEquals;
    private boolean isLimited;
    private boolean isSorted;
    private boolean hasGamemodeEquals;
    private boolean hasGamemodeNotEquals;
    private boolean hasTeamEquals;
    private boolean hasTeamNotEquals;
    @Nullable
    private EntityTypes<?> type;
    private boolean typeInverse;
    private boolean hasScores;
    private boolean hasAdvancements;
    private boolean usesSelectors;

    public ArgumentParserSelector(StringReader var0) {
        this(var0, true);
    }

    public ArgumentParserSelector(StringReader var02, boolean var1) {
        this.reader = var02;
        this.allowSelectors = var1;
    }

    public EntitySelector getSelector() {
        AxisAlignedBB var02;
        if (this.deltaX != null || this.deltaY != null || this.deltaZ != null) {
            var02 = this.createAabb(this.deltaX == null ? 0.0 : this.deltaX, this.deltaY == null ? 0.0 : this.deltaY, this.deltaZ == null ? 0.0 : this.deltaZ);
        } else if (this.distance.getMax() != null) {
            double var1 = (Double)this.distance.getMax();
            var02 = new AxisAlignedBB(-var1, -var1, -var1, var1 + 1.0, var1 + 1.0, var1 + 1.0);
        } else {
            var02 = null;
        }
        Function<Vec3D, Vec3D> var1 = this.x == null && this.y == null && this.z == null ? var0 -> var0 : var0 -> new Vec3D(this.x == null ? var0.x : this.x, this.y == null ? var0.y : this.y, this.z == null ? var0.z : this.z);
        return new EntitySelector(this.maxResults, this.includesEntities, this.worldLimited, this.predicate, this.distance, var1, var02, this.order, this.currentEntity, this.playerName, this.entityUUID, this.type, this.usesSelectors);
    }

    private AxisAlignedBB createAabb(double var0, double var2, double var4) {
        boolean var6 = var0 < 0.0;
        boolean var7 = var2 < 0.0;
        boolean var8 = var4 < 0.0;
        double var9 = var6 ? var0 : 0.0;
        double var11 = var7 ? var2 : 0.0;
        double var13 = var8 ? var4 : 0.0;
        double var15 = (var6 ? 0.0 : var0) + 1.0;
        double var17 = (var7 ? 0.0 : var2) + 1.0;
        double var19 = (var8 ? 0.0 : var4) + 1.0;
        return new AxisAlignedBB(var9, var11, var13, var15, var17, var19);
    }

    private void finalizePredicates() {
        if (this.rotX != CriterionConditionRange.ANY) {
            this.predicate = this.predicate.and(this.createRotationPredicate(this.rotX, Entity::getXRot));
        }
        if (this.rotY != CriterionConditionRange.ANY) {
            this.predicate = this.predicate.and(this.createRotationPredicate(this.rotY, Entity::getYRot));
        }
        if (!this.level.isAny()) {
            this.predicate = this.predicate.and(var0 -> {
                if (!(var0 instanceof EntityPlayer)) {
                    return false;
                }
                return this.level.matches(((EntityPlayer)var0).experienceLevel);
            });
        }
    }

    private Predicate<Entity> createRotationPredicate(CriterionConditionRange var0, ToDoubleFunction<Entity> var1) {
        double var2 = MathHelper.wrapDegrees(var0.getMin() == null ? 0.0f : var0.getMin().floatValue());
        double var4 = MathHelper.wrapDegrees(var0.getMax() == null ? 359.0f : var0.getMax().floatValue());
        return var5 -> {
            double var6 = MathHelper.wrapDegrees(var1.applyAsDouble((Entity)var5));
            if (var2 > var4) {
                return var6 >= var2 || var6 <= var4;
            }
            return var6 >= var2 && var6 <= var4;
        };
    }

    protected void parseSelector() throws CommandSyntaxException {
        this.usesSelectors = true;
        this.suggestions = this::suggestSelector;
        if (!this.reader.canRead()) {
            throw ERROR_MISSING_SELECTOR_TYPE.createWithContext((ImmutableStringReader)this.reader);
        }
        int var0 = this.reader.getCursor();
        char var1 = this.reader.read();
        if (var1 == 'p') {
            this.maxResults = 1;
            this.includesEntities = false;
            this.order = ORDER_NEAREST;
            this.limitToType(EntityTypes.PLAYER);
        } else if (var1 == 'a') {
            this.maxResults = Integer.MAX_VALUE;
            this.includesEntities = false;
            this.order = ORDER_ARBITRARY;
            this.limitToType(EntityTypes.PLAYER);
        } else if (var1 == 'r') {
            this.maxResults = 1;
            this.includesEntities = false;
            this.order = ORDER_RANDOM;
            this.limitToType(EntityTypes.PLAYER);
        } else if (var1 == 's') {
            this.maxResults = 1;
            this.includesEntities = true;
            this.currentEntity = true;
        } else if (var1 == 'e') {
            this.maxResults = Integer.MAX_VALUE;
            this.includesEntities = true;
            this.order = ORDER_ARBITRARY;
            this.predicate = Entity::isAlive;
        } else {
            this.reader.setCursor(var0);
            throw ERROR_UNKNOWN_SELECTOR_TYPE.createWithContext((ImmutableStringReader)this.reader, (Object)("@" + String.valueOf(var1)));
        }
        this.suggestions = this::suggestOpenOptions;
        if (this.reader.canRead() && this.reader.peek() == '[') {
            this.reader.skip();
            this.suggestions = this::suggestOptionsKeyOrClose;
            this.parseOptions();
        }
    }

    protected void parseNameOrUUID() throws CommandSyntaxException {
        if (this.reader.canRead()) {
            this.suggestions = this::suggestName;
        }
        int var0 = this.reader.getCursor();
        String var1 = this.reader.readString();
        try {
            this.entityUUID = UUID.fromString(var1);
            this.includesEntities = true;
        }
        catch (IllegalArgumentException var2) {
            if (var1.isEmpty() || var1.length() > 16) {
                this.reader.setCursor(var0);
                throw ERROR_INVALID_NAME_OR_UUID.createWithContext((ImmutableStringReader)this.reader);
            }
            this.includesEntities = false;
            this.playerName = var1;
        }
        this.maxResults = 1;
    }

    protected void parseOptions() throws CommandSyntaxException {
        this.suggestions = this::suggestOptionsKey;
        this.reader.skipWhitespace();
        while (this.reader.canRead() && this.reader.peek() != ']') {
            this.reader.skipWhitespace();
            int var0 = this.reader.getCursor();
            String var1 = this.reader.readString();
            PlayerSelector.a var2 = PlayerSelector.get(this, var1, var0);
            this.reader.skipWhitespace();
            if (!this.reader.canRead() || this.reader.peek() != '=') {
                this.reader.setCursor(var0);
                throw ERROR_EXPECTED_OPTION_VALUE.createWithContext((ImmutableStringReader)this.reader, (Object)var1);
            }
            this.reader.skip();
            this.reader.skipWhitespace();
            this.suggestions = SUGGEST_NOTHING;
            var2.handle(this);
            this.reader.skipWhitespace();
            this.suggestions = this::suggestOptionsNextOrClose;
            if (!this.reader.canRead()) continue;
            if (this.reader.peek() == ',') {
                this.reader.skip();
                this.suggestions = this::suggestOptionsKey;
                continue;
            }
            if (this.reader.peek() == ']') break;
            throw ERROR_EXPECTED_END_OF_OPTIONS.createWithContext((ImmutableStringReader)this.reader);
        }
        if (!this.reader.canRead()) {
            throw ERROR_EXPECTED_END_OF_OPTIONS.createWithContext((ImmutableStringReader)this.reader);
        }
        this.reader.skip();
        this.suggestions = SUGGEST_NOTHING;
    }

    public boolean shouldInvertValue() {
        this.reader.skipWhitespace();
        if (this.reader.canRead() && this.reader.peek() == '!') {
            this.reader.skip();
            this.reader.skipWhitespace();
            return true;
        }
        return false;
    }

    public boolean isTag() {
        this.reader.skipWhitespace();
        if (this.reader.canRead() && this.reader.peek() == '#') {
            this.reader.skip();
            this.reader.skipWhitespace();
            return true;
        }
        return false;
    }

    public StringReader getReader() {
        return this.reader;
    }

    public void addPredicate(Predicate<Entity> var0) {
        this.predicate = this.predicate.and(var0);
    }

    public void setWorldLimited() {
        this.worldLimited = true;
    }

    public CriterionConditionValue.DoubleRange getDistance() {
        return this.distance;
    }

    public void setDistance(CriterionConditionValue.DoubleRange var0) {
        this.distance = var0;
    }

    public CriterionConditionValue.IntegerRange getLevel() {
        return this.level;
    }

    public void setLevel(CriterionConditionValue.IntegerRange var0) {
        this.level = var0;
    }

    public CriterionConditionRange getRotX() {
        return this.rotX;
    }

    public void setRotX(CriterionConditionRange var0) {
        this.rotX = var0;
    }

    public CriterionConditionRange getRotY() {
        return this.rotY;
    }

    public void setRotY(CriterionConditionRange var0) {
        this.rotY = var0;
    }

    @Nullable
    public Double getX() {
        return this.x;
    }

    @Nullable
    public Double getY() {
        return this.y;
    }

    @Nullable
    public Double getZ() {
        return this.z;
    }

    public void setX(double var0) {
        this.x = var0;
    }

    public void setY(double var0) {
        this.y = var0;
    }

    public void setZ(double var0) {
        this.z = var0;
    }

    public void setDeltaX(double var0) {
        this.deltaX = var0;
    }

    public void setDeltaY(double var0) {
        this.deltaY = var0;
    }

    public void setDeltaZ(double var0) {
        this.deltaZ = var0;
    }

    @Nullable
    public Double getDeltaX() {
        return this.deltaX;
    }

    @Nullable
    public Double getDeltaY() {
        return this.deltaY;
    }

    @Nullable
    public Double getDeltaZ() {
        return this.deltaZ;
    }

    public void setMaxResults(int var0) {
        this.maxResults = var0;
    }

    public void setIncludesEntities(boolean var0) {
        this.includesEntities = var0;
    }

    public BiConsumer<Vec3D, List<? extends Entity>> getOrder() {
        return this.order;
    }

    public void setOrder(BiConsumer<Vec3D, List<? extends Entity>> var0) {
        this.order = var0;
    }

    public EntitySelector parse() throws CommandSyntaxException {
        this.startPosition = this.reader.getCursor();
        this.suggestions = this::suggestNameOrSelector;
        if (this.reader.canRead() && this.reader.peek() == '@') {
            if (!this.allowSelectors) {
                throw ERROR_SELECTORS_NOT_ALLOWED.createWithContext((ImmutableStringReader)this.reader);
            }
            this.reader.skip();
            this.parseSelector();
        } else {
            this.parseNameOrUUID();
        }
        this.finalizePredicates();
        return this.getSelector();
    }

    private static void fillSelectorSuggestions(SuggestionsBuilder var0) {
        var0.suggest("@p", (Message)new ChatMessage("argument.entity.selector.nearestPlayer"));
        var0.suggest("@a", (Message)new ChatMessage("argument.entity.selector.allPlayers"));
        var0.suggest("@r", (Message)new ChatMessage("argument.entity.selector.randomPlayer"));
        var0.suggest("@s", (Message)new ChatMessage("argument.entity.selector.self"));
        var0.suggest("@e", (Message)new ChatMessage("argument.entity.selector.allEntities"));
    }

    private CompletableFuture<Suggestions> suggestNameOrSelector(SuggestionsBuilder var0, Consumer<SuggestionsBuilder> var1) {
        var1.accept(var0);
        if (this.allowSelectors) {
            ArgumentParserSelector.fillSelectorSuggestions(var0);
        }
        return var0.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestName(SuggestionsBuilder var0, Consumer<SuggestionsBuilder> var1) {
        SuggestionsBuilder var2 = var0.createOffset(this.startPosition);
        var1.accept(var2);
        return var0.add(var2).buildFuture();
    }

    private CompletableFuture<Suggestions> suggestSelector(SuggestionsBuilder var0, Consumer<SuggestionsBuilder> var1) {
        SuggestionsBuilder var2 = var0.createOffset(var0.getStart() - 1);
        ArgumentParserSelector.fillSelectorSuggestions(var2);
        var0.add(var2);
        return var0.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestOpenOptions(SuggestionsBuilder var0, Consumer<SuggestionsBuilder> var1) {
        var0.suggest(String.valueOf('['));
        return var0.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestOptionsKeyOrClose(SuggestionsBuilder var0, Consumer<SuggestionsBuilder> var1) {
        var0.suggest(String.valueOf(']'));
        PlayerSelector.suggestNames(this, var0);
        return var0.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestOptionsKey(SuggestionsBuilder var0, Consumer<SuggestionsBuilder> var1) {
        PlayerSelector.suggestNames(this, var0);
        return var0.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestOptionsNextOrClose(SuggestionsBuilder var0, Consumer<SuggestionsBuilder> var1) {
        var0.suggest(String.valueOf(','));
        var0.suggest(String.valueOf(']'));
        return var0.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestEquals(SuggestionsBuilder var0, Consumer<SuggestionsBuilder> var1) {
        var0.suggest(String.valueOf('='));
        return var0.buildFuture();
    }

    public boolean isCurrentEntity() {
        return this.currentEntity;
    }

    public void setSuggestions(BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> var0) {
        this.suggestions = var0;
    }

    public CompletableFuture<Suggestions> fillSuggestions(SuggestionsBuilder var0, Consumer<SuggestionsBuilder> var1) {
        return this.suggestions.apply(var0.createOffset(this.reader.getCursor()), var1);
    }

    public boolean hasNameEquals() {
        return this.hasNameEquals;
    }

    public void setHasNameEquals(boolean var0) {
        this.hasNameEquals = var0;
    }

    public boolean hasNameNotEquals() {
        return this.hasNameNotEquals;
    }

    public void setHasNameNotEquals(boolean var0) {
        this.hasNameNotEquals = var0;
    }

    public boolean isLimited() {
        return this.isLimited;
    }

    public void setLimited(boolean var0) {
        this.isLimited = var0;
    }

    public boolean isSorted() {
        return this.isSorted;
    }

    public void setSorted(boolean var0) {
        this.isSorted = var0;
    }

    public boolean hasGamemodeEquals() {
        return this.hasGamemodeEquals;
    }

    public void setHasGamemodeEquals(boolean var0) {
        this.hasGamemodeEquals = var0;
    }

    public boolean hasGamemodeNotEquals() {
        return this.hasGamemodeNotEquals;
    }

    public void setHasGamemodeNotEquals(boolean var0) {
        this.hasGamemodeNotEquals = var0;
    }

    public boolean hasTeamEquals() {
        return this.hasTeamEquals;
    }

    public void setHasTeamEquals(boolean var0) {
        this.hasTeamEquals = var0;
    }

    public boolean hasTeamNotEquals() {
        return this.hasTeamNotEquals;
    }

    public void setHasTeamNotEquals(boolean var0) {
        this.hasTeamNotEquals = var0;
    }

    public void limitToType(EntityTypes<?> var0) {
        this.type = var0;
    }

    public void setTypeLimitedInversely() {
        this.typeInverse = true;
    }

    public boolean isTypeLimited() {
        return this.type != null;
    }

    public boolean isTypeLimitedInversely() {
        return this.typeInverse;
    }

    public boolean hasScores() {
        return this.hasScores;
    }

    public void setHasScores(boolean var0) {
        this.hasScores = var0;
    }

    public boolean hasAdvancements() {
        return this.hasAdvancements;
    }

    public void setHasAdvancements(boolean var0) {
        this.hasAdvancements = var0;
    }
}

