/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public class ArgumentParserItemStack {
    public static final SimpleCommandExceptionType ERROR_NO_TAGS_ALLOWED = new SimpleCommandExceptionType((Message)new ChatMessage("argument.item.tag.disallowed"));
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_ITEM = new DynamicCommandExceptionType(var0 -> new ChatMessage("argument.item.id.invalid", var0));
    private static final char SYNTAX_START_NBT = '{';
    private static final char SYNTAX_TAG = '#';
    private static final BiFunction<SuggestionsBuilder, IRegistry<Item>, CompletableFuture<Suggestions>> SUGGEST_NOTHING = (var0, var1) -> var0.buildFuture();
    private final StringReader reader;
    private final boolean forTesting;
    private Item item;
    @Nullable
    private NBTTagCompound nbt;
    @Nullable
    private TagKey<Item> tag;
    private int tagCursor;
    private BiFunction<SuggestionsBuilder, IRegistry<Item>, CompletableFuture<Suggestions>> suggestions = SUGGEST_NOTHING;

    public ArgumentParserItemStack(StringReader var0, boolean var1) {
        this.reader = var0;
        this.forTesting = var1;
    }

    public Item getItem() {
        return this.item;
    }

    @Nullable
    public NBTTagCompound getNbt() {
        return this.nbt;
    }

    public TagKey<Item> getTag() {
        return this.tag;
    }

    public void readItem() throws CommandSyntaxException {
        int var0 = this.reader.getCursor();
        MinecraftKey var1 = MinecraftKey.read(this.reader);
        this.item = IRegistry.ITEM.getOptional(var1).orElseThrow(() -> {
            this.reader.setCursor(var0);
            return ERROR_UNKNOWN_ITEM.createWithContext((ImmutableStringReader)this.reader, (Object)var1.toString());
        });
    }

    public void readTag() throws CommandSyntaxException {
        if (!this.forTesting) {
            throw ERROR_NO_TAGS_ALLOWED.create();
        }
        this.suggestions = this::suggestTag;
        this.reader.expect('#');
        this.tagCursor = this.reader.getCursor();
        this.tag = TagKey.create(IRegistry.ITEM_REGISTRY, MinecraftKey.read(this.reader));
    }

    public void readNbt() throws CommandSyntaxException {
        this.nbt = new MojangsonParser(this.reader).readStruct();
    }

    public ArgumentParserItemStack parse() throws CommandSyntaxException {
        this.suggestions = this::suggestItemIdOrTag;
        if (this.reader.canRead() && this.reader.peek() == '#') {
            this.readTag();
        } else {
            this.readItem();
            this.suggestions = this::suggestOpenNbt;
        }
        if (this.reader.canRead() && this.reader.peek() == '{') {
            this.suggestions = SUGGEST_NOTHING;
            this.readNbt();
        }
        return this;
    }

    private CompletableFuture<Suggestions> suggestOpenNbt(SuggestionsBuilder var0, IRegistry<Item> var1) {
        if (var0.getRemaining().isEmpty()) {
            var0.suggest(String.valueOf('{'));
        }
        return var0.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestTag(SuggestionsBuilder var0, IRegistry<Item> var1) {
        return ICompletionProvider.suggestResource(var1.getTagNames().map(TagKey::location), var0.createOffset(this.tagCursor));
    }

    private CompletableFuture<Suggestions> suggestItemIdOrTag(SuggestionsBuilder var0, IRegistry<Item> var1) {
        if (this.forTesting) {
            ICompletionProvider.suggestResource(var1.getTagNames().map(TagKey::location), var0, String.valueOf('#'));
        }
        return ICompletionProvider.suggestResource(IRegistry.ITEM.keySet(), var0);
    }

    public CompletableFuture<Suggestions> fillSuggestions(SuggestionsBuilder var0, IRegistry<Item> var1) {
        return this.suggestions.apply(var0.createOffset(this.reader.getCursor()), var1);
    }
}

