/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.item.ArgumentParserItemStack;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ArgumentItemPredicate
implements ArgumentType<b> {
    private static final Collection<String> EXAMPLES = Arrays.asList("stick", "minecraft:stick", "#stick", "#stick{foo=bar}");
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_TAG = new DynamicCommandExceptionType(var0 -> new ChatMessage("arguments.item.tag.unknown", var0));

    public static ArgumentItemPredicate itemPredicate() {
        return new ArgumentItemPredicate();
    }

    public b parse(StringReader var0) throws CommandSyntaxException {
        ArgumentParserItemStack var12 = new ArgumentParserItemStack(var0, true).parse();
        if (var12.getItem() != null) {
            a var22 = new a(var12.getItem(), var12.getNbt());
            return var1 -> var22;
        }
        TagKey<Item> var23 = var12.getTag();
        return var2 -> {
            if (!IRegistry.ITEM.isKnownTagName(var23)) {
                throw ERROR_UNKNOWN_TAG.create((Object)var23);
            }
            return new c(var23, var12.getNbt());
        };
    }

    public static Predicate<ItemStack> getItemPredicate(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ((b)var0.getArgument(var1, b.class)).create(var0);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        StringReader var2 = new StringReader(var1.getInput());
        var2.setCursor(var1.getStart());
        ArgumentParserItemStack var3 = new ArgumentParserItemStack(var2, true);
        try {
            var3.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return var3.fillSuggestions(var1, IRegistry.ITEM);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    static class a
    implements Predicate<ItemStack> {
        private final Item item;
        @Nullable
        private final NBTTagCompound nbt;

        public a(Item var0, @Nullable NBTTagCompound var1) {
            this.item = var0;
            this.nbt = var1;
        }

        @Override
        public boolean test(ItemStack var0) {
            return var0.is(this.item) && GameProfileSerializer.compareNbt(this.nbt, var0.getTag(), true);
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((ItemStack)object);
        }
    }

    public static interface b {
        public Predicate<ItemStack> create(CommandContext<CommandListenerWrapper> var1) throws CommandSyntaxException;
    }

    static class c
    implements Predicate<ItemStack> {
        private final TagKey<Item> tag;
        @Nullable
        private final NBTTagCompound nbt;

        public c(TagKey<Item> var0, @Nullable NBTTagCompound var1) {
            this.tag = var0;
            this.nbt = var1;
        }

        @Override
        public boolean test(ItemStack var0) {
            return var0.is(this.tag) && GameProfileSerializer.compareNbt(this.nbt, var0.getTag(), true);
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((ItemStack)object);
        }
    }
}

