/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.coordinates;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.coordinates.ArgumentParserPosition;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.commands.arguments.coordinates.VectorPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.server.level.BlockPosition2D;

public class ArgumentVec2I
implements ArgumentType<IVectorPosition> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0 0", "~ ~", "~1 ~-2", "^ ^", "^-1 ^0");
    public static final SimpleCommandExceptionType ERROR_NOT_COMPLETE = new SimpleCommandExceptionType((Message)new ChatMessage("argument.pos2d.incomplete"));

    public static ArgumentVec2I columnPos() {
        return new ArgumentVec2I();
    }

    public static BlockPosition2D getColumnPos(CommandContext<CommandListenerWrapper> var0, String var1) {
        BlockPosition var2 = ((IVectorPosition)var0.getArgument(var1, IVectorPosition.class)).getBlockPos((CommandListenerWrapper)var0.getSource());
        return new BlockPosition2D(var2.getX(), var2.getZ());
    }

    public IVectorPosition parse(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        if (!var0.canRead()) {
            throw ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        ArgumentParserPosition var2 = ArgumentParserPosition.parseInt(var0);
        if (!var0.canRead() || var0.peek() != ' ') {
            var0.setCursor(var1);
            throw ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        ArgumentParserPosition var3 = ArgumentParserPosition.parseInt(var0);
        return new VectorPosition(var2, new ArgumentParserPosition(true, 0.0), var3);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        if (var0.getSource() instanceof ICompletionProvider) {
            String var2 = var1.getRemaining();
            Collection<ICompletionProvider.b> var3 = !var2.isEmpty() && var2.charAt(0) == '^' ? Collections.singleton(ICompletionProvider.b.DEFAULT_LOCAL) : ((ICompletionProvider)var0.getSource()).getRelevantCoordinates();
            return ICompletionProvider.suggest2DCoordinates(var2, var3, var1, CommandDispatcher.createValidator(this::parse));
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

