/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.blocks;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.blocks.ArgumentBlock;
import net.minecraft.commands.arguments.blocks.ArgumentTileLocation;
import net.minecraft.core.IRegistry;

public class ArgumentTile
implements ArgumentType<ArgumentTileLocation> {
    private static final Collection<String> EXAMPLES = Arrays.asList("stone", "minecraft:stone", "stone[foo=bar]", "foo{bar=baz}");

    public static ArgumentTile block() {
        return new ArgumentTile();
    }

    public ArgumentTileLocation parse(StringReader var0) throws CommandSyntaxException {
        ArgumentBlock var1 = new ArgumentBlock(var0, false).parse(true);
        return new ArgumentTileLocation(var1.getState(), var1.getProperties().keySet(), var1.getNbt());
    }

    public static ArgumentTileLocation getBlock(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (ArgumentTileLocation)var0.getArgument(var1, ArgumentTileLocation.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        StringReader var2 = new StringReader(var1.getInput());
        var2.setCursor(var1.getStart());
        ArgumentBlock var3 = new ArgumentBlock(var2, false);
        try {
            var3.parse(true);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return var3.fillSuggestions(var1, IRegistry.BLOCK);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

