/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.blocks;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.blocks.ArgumentBlock;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.block.state.properties.IBlockState;

public class ArgumentBlockPredicate
implements ArgumentType<b> {
    private static final Collection<String> EXAMPLES = Arrays.asList("stone", "minecraft:stone", "stone[foo=bar]", "#stone", "#stone[foo=bar]{baz=nbt}");
    static final DynamicCommandExceptionType ERROR_UNKNOWN_TAG = new DynamicCommandExceptionType(var0 -> new ChatMessage("arguments.block.tag.unknown", var0));

    public static ArgumentBlockPredicate blockPredicate() {
        return new ArgumentBlockPredicate();
    }

    public b parse(StringReader var0) throws CommandSyntaxException {
        final ArgumentBlock var1 = new ArgumentBlock(var0, true).parse(true);
        if (var1.getState() != null) {
            final a var2 = new a(var1.getState(), var1.getProperties().keySet(), var1.getNbt());
            return new b(){

                @Override
                public Predicate<ShapeDetectorBlock> create(IRegistry<Block> var0) {
                    return var2;
                }

                @Override
                public boolean requiresNbt() {
                    return var2.requiresNbt();
                }
            };
        }
        final TagKey<Block> var2 = var1.getTag();
        return new b(){

            @Override
            public Predicate<ShapeDetectorBlock> create(IRegistry<Block> var0) throws CommandSyntaxException {
                if (!var0.isKnownTagName(var2)) {
                    throw ERROR_UNKNOWN_TAG.create((Object)var2);
                }
                return new c(var2, var1.getVagueProperties(), var1.getNbt());
            }

            @Override
            public boolean requiresNbt() {
                return var1.getNbt() != null;
            }
        };
    }

    public static Predicate<ShapeDetectorBlock> getBlockPredicate(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ((b)var0.getArgument(var1, b.class)).create(((CommandListenerWrapper)var0.getSource()).getServer().registryAccess().registryOrThrow(IRegistry.BLOCK_REGISTRY));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        StringReader var2 = new StringReader(var1.getInput());
        var2.setCursor(var1.getStart());
        ArgumentBlock var3 = new ArgumentBlock(var2, true);
        try {
            var3.parse(true);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return var3.fillSuggestions(var1, IRegistry.BLOCK);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    static class a
    implements Predicate<ShapeDetectorBlock> {
        private final IBlockData state;
        private final Set<IBlockState<?>> properties;
        @Nullable
        private final NBTTagCompound nbt;

        public a(IBlockData var0, Set<IBlockState<?>> var1, @Nullable NBTTagCompound var2) {
            this.state = var0;
            this.properties = var1;
            this.nbt = var2;
        }

        @Override
        public boolean test(ShapeDetectorBlock var0) {
            IBlockData var1 = var0.getState();
            if (!var1.is(this.state.getBlock())) {
                return false;
            }
            for (IBlockState<?> var3 : this.properties) {
                if (var1.getValue(var3) == this.state.getValue(var3)) continue;
                return false;
            }
            if (this.nbt != null) {
                TileEntity var2 = var0.getEntity();
                return var2 != null && GameProfileSerializer.compareNbt(this.nbt, var2.saveWithFullMetadata(), true);
            }
            return true;
        }

        public boolean requiresNbt() {
            return this.nbt != null;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((ShapeDetectorBlock)object);
        }
    }

    public static interface b {
        public Predicate<ShapeDetectorBlock> create(IRegistry<Block> var1) throws CommandSyntaxException;

        public boolean requiresNbt();
    }

    static class c
    implements Predicate<ShapeDetectorBlock> {
        private final TagKey<Block> tag;
        @Nullable
        private final NBTTagCompound nbt;
        private final Map<String, String> vagueProperties;

        c(TagKey<Block> var0, Map<String, String> var1, @Nullable NBTTagCompound var2) {
            this.tag = var0;
            this.vagueProperties = var1;
            this.nbt = var2;
        }

        @Override
        public boolean test(ShapeDetectorBlock var0) {
            IBlockData var1 = var0.getState();
            if (!var1.is(this.tag)) {
                return false;
            }
            for (Map.Entry<String, String> var3 : this.vagueProperties.entrySet()) {
                IBlockState<?> var4 = var1.getBlock().getStateDefinition().getProperty(var3.getKey());
                if (var4 == null) {
                    return false;
                }
                Comparable var5 = var4.getValue(var3.getValue()).orElse(null);
                if (var5 == null) {
                    return false;
                }
                if (var1.getValue(var4) == var5) continue;
                return false;
            }
            if (this.nbt != null) {
                TileEntity var2 = var0.getEntity();
                return var2 != null && GameProfileSerializer.compareNbt(this.nbt, var2.saveWithFullMetadata(), true);
            }
            return true;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((ShapeDetectorBlock)object);
        }
    }
}

