/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.blocks;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;

public class ArgumentBlock {
    public static final SimpleCommandExceptionType ERROR_NO_TAGS_ALLOWED = new SimpleCommandExceptionType((Message)new ChatMessage("argument.block.tag.disallowed"));
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_BLOCK = new DynamicCommandExceptionType(var0 -> new ChatMessage("argument.block.id.invalid", var0));
    public static final Dynamic2CommandExceptionType ERROR_UNKNOWN_PROPERTY = new Dynamic2CommandExceptionType((var0, var1) -> new ChatMessage("argument.block.property.unknown", var0, var1));
    public static final Dynamic2CommandExceptionType ERROR_DUPLICATE_PROPERTY = new Dynamic2CommandExceptionType((var0, var1) -> new ChatMessage("argument.block.property.duplicate", var1, var0));
    public static final Dynamic3CommandExceptionType ERROR_INVALID_VALUE = new Dynamic3CommandExceptionType((var0, var1, var2) -> new ChatMessage("argument.block.property.invalid", var0, var2, var1));
    public static final Dynamic2CommandExceptionType ERROR_EXPECTED_VALUE = new Dynamic2CommandExceptionType((var0, var1) -> new ChatMessage("argument.block.property.novalue", var0, var1));
    public static final SimpleCommandExceptionType ERROR_EXPECTED_END_OF_PROPERTIES = new SimpleCommandExceptionType((Message)new ChatMessage("argument.block.property.unclosed"));
    private static final char SYNTAX_START_PROPERTIES = '[';
    private static final char SYNTAX_START_NBT = '{';
    private static final char SYNTAX_END_PROPERTIES = ']';
    private static final char SYNTAX_EQUALS = '=';
    private static final char SYNTAX_PROPERTY_SEPARATOR = ',';
    private static final char SYNTAX_TAG = '#';
    private static final BiFunction<SuggestionsBuilder, IRegistry<Block>, CompletableFuture<Suggestions>> SUGGEST_NOTHING = (var0, var1) -> var0.buildFuture();
    private final StringReader reader;
    private final boolean forTesting;
    private final Map<IBlockState<?>, Comparable<?>> properties = Maps.newHashMap();
    private final Map<String, String> vagueProperties = Maps.newHashMap();
    private MinecraftKey id = new MinecraftKey("");
    private BlockStateList<Block, IBlockData> definition;
    private IBlockData state;
    @Nullable
    private NBTTagCompound nbt;
    @Nullable
    private TagKey<Block> tag;
    private int tagCursor;
    private BiFunction<SuggestionsBuilder, IRegistry<Block>, CompletableFuture<Suggestions>> suggestions = SUGGEST_NOTHING;

    public ArgumentBlock(StringReader var0, boolean var1) {
        this.reader = var0;
        this.forTesting = var1;
    }

    public Map<IBlockState<?>, Comparable<?>> getProperties() {
        return this.properties;
    }

    @Nullable
    public IBlockData getState() {
        return this.state;
    }

    @Nullable
    public NBTTagCompound getNbt() {
        return this.nbt;
    }

    @Nullable
    public TagKey<Block> getTag() {
        return this.tag;
    }

    public ArgumentBlock parse(boolean var0) throws CommandSyntaxException {
        this.suggestions = this::suggestBlockIdOrTag;
        if (this.reader.canRead() && this.reader.peek() == '#') {
            this.readTag();
            this.suggestions = this::suggestOpenVaguePropertiesOrNbt;
            if (this.reader.canRead() && this.reader.peek() == '[') {
                this.readVagueProperties();
                this.suggestions = this::suggestOpenNbt;
            }
        } else {
            this.readBlock();
            this.suggestions = this::suggestOpenPropertiesOrNbt;
            if (this.reader.canRead() && this.reader.peek() == '[') {
                this.readProperties();
                this.suggestions = this::suggestOpenNbt;
            }
        }
        if (var0 && this.reader.canRead() && this.reader.peek() == '{') {
            this.suggestions = SUGGEST_NOTHING;
            this.readNbt();
        }
        return this;
    }

    private CompletableFuture<Suggestions> suggestPropertyNameOrEnd(SuggestionsBuilder var0, IRegistry<Block> var1) {
        if (var0.getRemaining().isEmpty()) {
            var0.suggest(String.valueOf(']'));
        }
        return this.suggestPropertyName(var0, var1);
    }

    private CompletableFuture<Suggestions> suggestVaguePropertyNameOrEnd(SuggestionsBuilder var0, IRegistry<Block> var1) {
        if (var0.getRemaining().isEmpty()) {
            var0.suggest(String.valueOf(']'));
        }
        return this.suggestVaguePropertyName(var0, var1);
    }

    private CompletableFuture<Suggestions> suggestPropertyName(SuggestionsBuilder var0, IRegistry<Block> var1) {
        String var2 = var0.getRemaining().toLowerCase(Locale.ROOT);
        for (IBlockState<?> var4 : this.state.getProperties()) {
            if (this.properties.containsKey(var4) || !var4.getName().startsWith(var2)) continue;
            var0.suggest(var4.getName() + "=");
        }
        return var0.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestVaguePropertyName(SuggestionsBuilder var0, IRegistry<Block> var1) {
        String var2 = var0.getRemaining().toLowerCase(Locale.ROOT);
        if (this.tag != null) {
            for (Holder<Block> var4 : var1.getTagOrEmpty(this.tag)) {
                for (IBlockState<?> var6 : var4.value().getStateDefinition().getProperties()) {
                    if (this.vagueProperties.containsKey(var6.getName()) || !var6.getName().startsWith(var2)) continue;
                    var0.suggest(var6.getName() + "=");
                }
            }
        }
        return var0.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestOpenNbt(SuggestionsBuilder var0, IRegistry<Block> var1) {
        if (var0.getRemaining().isEmpty() && this.hasBlockEntity(var1)) {
            var0.suggest(String.valueOf('{'));
        }
        return var0.buildFuture();
    }

    private boolean hasBlockEntity(IRegistry<Block> var0) {
        if (this.state != null) {
            return this.state.hasBlockEntity();
        }
        if (this.tag != null) {
            for (Holder<Block> var2 : var0.getTagOrEmpty(this.tag)) {
                if (!var2.value().defaultBlockState().hasBlockEntity()) continue;
                return true;
            }
        }
        return false;
    }

    private CompletableFuture<Suggestions> suggestEquals(SuggestionsBuilder var0, IRegistry<Block> var1) {
        if (var0.getRemaining().isEmpty()) {
            var0.suggest(String.valueOf('='));
        }
        return var0.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestNextPropertyOrEnd(SuggestionsBuilder var0, IRegistry<Block> var1) {
        if (var0.getRemaining().isEmpty()) {
            var0.suggest(String.valueOf(']'));
        }
        if (var0.getRemaining().isEmpty() && this.properties.size() < this.state.getProperties().size()) {
            var0.suggest(String.valueOf(','));
        }
        return var0.buildFuture();
    }

    private static <T extends Comparable<T>> SuggestionsBuilder addSuggestions(SuggestionsBuilder var0, IBlockState<T> var1) {
        for (Comparable var3 : var1.getPossibleValues()) {
            if (var3 instanceof Integer) {
                var0.suggest(((Integer)var3).intValue());
                continue;
            }
            var0.suggest(var1.getName(var3));
        }
        return var0;
    }

    private CompletableFuture<Suggestions> suggestVaguePropertyValue(SuggestionsBuilder var0, IRegistry<Block> var1, String var2) {
        boolean var3 = false;
        if (this.tag != null) {
            block0: for (Holder<Block> var5 : var1.getTagOrEmpty(this.tag)) {
                Block var6 = var5.value();
                IBlockState<?> var7 = var6.getStateDefinition().getProperty(var2);
                if (var7 != null) {
                    ArgumentBlock.addSuggestions(var0, var7);
                }
                if (var3) continue;
                for (IBlockState<?> var9 : var6.getStateDefinition().getProperties()) {
                    if (this.vagueProperties.containsKey(var9.getName())) continue;
                    var3 = true;
                    continue block0;
                }
            }
        }
        if (var3) {
            var0.suggest(String.valueOf(','));
        }
        var0.suggest(String.valueOf(']'));
        return var0.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestOpenVaguePropertiesOrNbt(SuggestionsBuilder var0, IRegistry<Block> var1) {
        if (var0.getRemaining().isEmpty() && this.tag != null) {
            Holder<Block> var5;
            Block var6;
            boolean var2 = false;
            boolean var3 = false;
            Iterator<Holder<Block>> iterator = var1.getTagOrEmpty(this.tag).iterator();
            while (!(!iterator.hasNext() || (var2 |= !(var6 = (var5 = iterator.next()).value()).getStateDefinition().getProperties().isEmpty()) && (var3 |= var6.defaultBlockState().hasBlockEntity()))) {
            }
            if (var2) {
                var0.suggest(String.valueOf('['));
            }
            if (var3) {
                var0.suggest(String.valueOf('{'));
            }
        }
        return this.suggestTag(var0, var1);
    }

    private CompletableFuture<Suggestions> suggestOpenPropertiesOrNbt(SuggestionsBuilder var0, IRegistry<Block> var1) {
        if (var0.getRemaining().isEmpty()) {
            if (!this.state.getBlock().getStateDefinition().getProperties().isEmpty()) {
                var0.suggest(String.valueOf('['));
            }
            if (this.state.hasBlockEntity()) {
                var0.suggest(String.valueOf('{'));
            }
        }
        return var0.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestTag(SuggestionsBuilder var0, IRegistry<Block> var1) {
        return ICompletionProvider.suggestResource(var1.getTagNames().map(TagKey::location), var0.createOffset(this.tagCursor).add(var0));
    }

    private CompletableFuture<Suggestions> suggestBlockIdOrTag(SuggestionsBuilder var0, IRegistry<Block> var1) {
        if (this.forTesting) {
            ICompletionProvider.suggestResource(var1.getTagNames().map(TagKey::location), var0, String.valueOf('#'));
        }
        ICompletionProvider.suggestResource(var1.keySet(), var0);
        return var0.buildFuture();
    }

    public void readBlock() throws CommandSyntaxException {
        int var0 = this.reader.getCursor();
        this.id = MinecraftKey.read(this.reader);
        Block var1 = IRegistry.BLOCK.getOptional(this.id).orElseThrow(() -> {
            this.reader.setCursor(var0);
            return ERROR_UNKNOWN_BLOCK.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString());
        });
        this.definition = var1.getStateDefinition();
        this.state = var1.defaultBlockState();
    }

    public void readTag() throws CommandSyntaxException {
        if (!this.forTesting) {
            throw ERROR_NO_TAGS_ALLOWED.create();
        }
        this.suggestions = this::suggestTag;
        this.reader.expect('#');
        this.tagCursor = this.reader.getCursor();
        this.tag = TagKey.create(IRegistry.BLOCK_REGISTRY, MinecraftKey.read(this.reader));
    }

    public void readProperties() throws CommandSyntaxException {
        this.reader.skip();
        this.suggestions = this::suggestPropertyNameOrEnd;
        this.reader.skipWhitespace();
        while (this.reader.canRead() && this.reader.peek() != ']') {
            this.reader.skipWhitespace();
            int var0 = this.reader.getCursor();
            String var12 = this.reader.readString();
            IBlockState<?> var22 = this.definition.getProperty(var12);
            if (var22 == null) {
                this.reader.setCursor(var0);
                throw ERROR_UNKNOWN_PROPERTY.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)var12);
            }
            if (this.properties.containsKey(var22)) {
                this.reader.setCursor(var0);
                throw ERROR_DUPLICATE_PROPERTY.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)var12);
            }
            this.reader.skipWhitespace();
            this.suggestions = this::suggestEquals;
            if (!this.reader.canRead() || this.reader.peek() != '=') {
                throw ERROR_EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)var12);
            }
            this.reader.skip();
            this.reader.skipWhitespace();
            this.suggestions = (var1, var2) -> ArgumentBlock.addSuggestions(var1, var22).buildFuture();
            int var3 = this.reader.getCursor();
            this.setValue(var22, this.reader.readString(), var3);
            this.suggestions = this::suggestNextPropertyOrEnd;
            this.reader.skipWhitespace();
            if (!this.reader.canRead()) continue;
            if (this.reader.peek() == ',') {
                this.reader.skip();
                this.suggestions = this::suggestPropertyName;
                continue;
            }
            if (this.reader.peek() == ']') break;
            throw ERROR_EXPECTED_END_OF_PROPERTIES.createWithContext((ImmutableStringReader)this.reader);
        }
        if (!this.reader.canRead()) {
            throw ERROR_EXPECTED_END_OF_PROPERTIES.createWithContext((ImmutableStringReader)this.reader);
        }
        this.reader.skip();
    }

    public void readVagueProperties() throws CommandSyntaxException {
        this.reader.skip();
        this.suggestions = this::suggestVaguePropertyNameOrEnd;
        int var0 = -1;
        this.reader.skipWhitespace();
        while (this.reader.canRead() && this.reader.peek() != ']') {
            this.reader.skipWhitespace();
            int var12 = this.reader.getCursor();
            String var22 = this.reader.readString();
            if (this.vagueProperties.containsKey(var22)) {
                this.reader.setCursor(var12);
                throw ERROR_DUPLICATE_PROPERTY.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)var22);
            }
            this.reader.skipWhitespace();
            if (!this.reader.canRead() || this.reader.peek() != '=') {
                this.reader.setCursor(var12);
                throw ERROR_EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)var22);
            }
            this.reader.skip();
            this.reader.skipWhitespace();
            this.suggestions = (var1, var2) -> this.suggestVaguePropertyValue((SuggestionsBuilder)var1, (IRegistry<Block>)var2, var22);
            var0 = this.reader.getCursor();
            String var3 = this.reader.readString();
            this.vagueProperties.put(var22, var3);
            this.reader.skipWhitespace();
            if (!this.reader.canRead()) continue;
            var0 = -1;
            if (this.reader.peek() == ',') {
                this.reader.skip();
                this.suggestions = this::suggestVaguePropertyName;
                continue;
            }
            if (this.reader.peek() == ']') break;
            throw ERROR_EXPECTED_END_OF_PROPERTIES.createWithContext((ImmutableStringReader)this.reader);
        }
        if (!this.reader.canRead()) {
            if (var0 >= 0) {
                this.reader.setCursor(var0);
            }
            throw ERROR_EXPECTED_END_OF_PROPERTIES.createWithContext((ImmutableStringReader)this.reader);
        }
        this.reader.skip();
    }

    public void readNbt() throws CommandSyntaxException {
        this.nbt = new MojangsonParser(this.reader).readStruct();
    }

    private <T extends Comparable<T>> void setValue(IBlockState<T> var0, String var1, int var2) throws CommandSyntaxException {
        Optional<T> var3 = var0.getValue(var1);
        if (!var3.isPresent()) {
            this.reader.setCursor(var2);
            throw ERROR_INVALID_VALUE.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)var0.getName(), (Object)var1);
        }
        this.state = (IBlockData)this.state.setValue(var0, (Comparable)var3.get());
        this.properties.put(var0, (Comparable)var3.get());
    }

    public static String serialize(IBlockData var0) {
        StringBuilder var1 = new StringBuilder(IRegistry.BLOCK.getKey(var0.getBlock()).toString());
        if (!var0.getProperties().isEmpty()) {
            var1.append('[');
            boolean var2 = false;
            for (Map.Entry var4 : var0.getValues().entrySet()) {
                if (var2) {
                    var1.append(',');
                }
                ArgumentBlock.appendProperty(var1, (IBlockState)var4.getKey(), (Comparable)var4.getValue());
                var2 = true;
            }
            var1.append(']');
        }
        return var1.toString();
    }

    private static <T extends Comparable<T>> void appendProperty(StringBuilder var0, IBlockState<T> var1, Comparable<?> var2) {
        var0.append(var1.getName());
        var0.append('=');
        var0.append(var1.getName(var2));
    }

    public CompletableFuture<Suggestions> fillSuggestions(SuggestionsBuilder var0, IRegistry<Block> var1) {
        return this.suggestions.apply(var0.createOffset(this.reader.getCursor()), var1);
    }

    public Map<String, String> getVagueProperties() {
        return this.vagueProperties;
    }
}

