/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.levelgen.feature.StructureFeature;

public class ResourceOrTagLocationArgument<T>
implements ArgumentType<b<T>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012", "#skeletons", "#minecraft:skeletons");
    private static final DynamicCommandExceptionType ERROR_INVALID_BIOME = new DynamicCommandExceptionType(var0 -> new ChatMessage("commands.locatebiome.invalid", var0));
    private static final DynamicCommandExceptionType ERROR_INVALID_STRUCTURE = new DynamicCommandExceptionType(var0 -> new ChatMessage("commands.locate.invalid", var0));
    final ResourceKey<? extends IRegistry<T>> registryKey;

    public ResourceOrTagLocationArgument(ResourceKey<? extends IRegistry<T>> var0) {
        this.registryKey = var0;
    }

    public static <T> ResourceOrTagLocationArgument<T> resourceOrTag(ResourceKey<? extends IRegistry<T>> var0) {
        return new ResourceOrTagLocationArgument<T>(var0);
    }

    private static <T> b<T> getRegistryType(CommandContext<CommandListenerWrapper> var0, String var1, ResourceKey<IRegistry<T>> var2, DynamicCommandExceptionType var3) throws CommandSyntaxException {
        b var4 = (b)var0.getArgument(var1, b.class);
        Optional<b<T>> var5 = var4.cast(var2);
        return var5.orElseThrow(() -> var3.create((Object)var4));
    }

    public static b<BiomeBase> getBiome(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ResourceOrTagLocationArgument.getRegistryType(var0, var1, IRegistry.BIOME_REGISTRY, ERROR_INVALID_BIOME);
    }

    public static b<StructureFeature<?, ?>> getStructureFeature(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ResourceOrTagLocationArgument.getRegistryType(var0, var1, IRegistry.CONFIGURED_STRUCTURE_FEATURE_REGISTRY, ERROR_INVALID_STRUCTURE);
    }

    public b<T> parse(StringReader var0) throws CommandSyntaxException {
        if (var0.canRead() && var0.peek() == '#') {
            int var1 = var0.getCursor();
            try {
                var0.skip();
                MinecraftKey var2 = MinecraftKey.read(var0);
                return new d(TagKey.create(this.registryKey, var2));
            }
            catch (CommandSyntaxException var2) {
                var0.setCursor(var1);
                throw var2;
            }
        }
        MinecraftKey var1 = MinecraftKey.read(var0);
        return new a(ResourceKey.create(this.registryKey, var1));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        Object object = var0.getSource();
        if (object instanceof ICompletionProvider) {
            ICompletionProvider var2 = (ICompletionProvider)object;
            return var2.suggestRegistryElements(this.registryKey, ICompletionProvider.a.ALL, var1, var0);
        }
        return var1.buildFuture();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static interface b<T>
    extends Predicate<Holder<T>> {
        public Either<ResourceKey<T>, TagKey<T>> unwrap();

        public <E> Optional<b<E>> cast(ResourceKey<? extends IRegistry<E>> var1);

        public String asPrintable();
    }

    record d<T>(TagKey<T> key) implements b<T>
    {
        @Override
        public Either<ResourceKey<T>, TagKey<T>> unwrap() {
            return Either.right(this.key);
        }

        @Override
        public <E> Optional<b<E>> cast(ResourceKey<? extends IRegistry<E>> var0) {
            return this.key.cast(var0).map(d::new);
        }

        @Override
        public boolean test(Holder<T> var0) {
            return var0.is(this.key);
        }

        @Override
        public String asPrintable() {
            return "#" + this.key.location();
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Holder)object);
        }
    }

    record a<T>(ResourceKey<T> key) implements b<T>
    {
        @Override
        public Either<ResourceKey<T>, TagKey<T>> unwrap() {
            return Either.left(this.key);
        }

        @Override
        public <E> Optional<b<E>> cast(ResourceKey<? extends IRegistry<E>> var0) {
            return this.key.cast(var0).map(a::new);
        }

        @Override
        public boolean test(Holder<T> var0) {
            return var0.is(this.key);
        }

        @Override
        public String asPrintable() {
            return this.key.location().toString();
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Holder)object);
        }
    }

    public static class c
    implements ArgumentSerializer<ResourceOrTagLocationArgument<?>> {
        @Override
        public void serializeToNetwork(ResourceOrTagLocationArgument<?> var0, PacketDataSerializer var1) {
            var1.writeResourceLocation(var0.registryKey.location());
        }

        @Override
        public ResourceOrTagLocationArgument<?> deserializeFromNetwork(PacketDataSerializer var0) {
            MinecraftKey var1 = var0.readResourceLocation();
            return new ResourceOrTagLocationArgument(ResourceKey.createRegistryKey(var1));
        }

        @Override
        public void serializeToJson(ResourceOrTagLocationArgument<?> var0, JsonObject var1) {
            var1.addProperty("registry", var0.registryKey.location().toString());
        }

        @Override
        public /* synthetic */ ArgumentType deserializeFromNetwork(PacketDataSerializer packetDataSerializer) {
            return this.deserializeFromNetwork(packetDataSerializer);
        }
    }
}

