/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatBaseComponent;

public class ArgumentChat
implements ArgumentType<a> {
    private static final Collection<String> EXAMPLES = Arrays.asList("Hello world!", "foo", "@e", "Hello @p :)");

    public static ArgumentChat message() {
        return new ArgumentChat();
    }

    public static IChatBaseComponent getMessage(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ((a)var0.getArgument(var1, a.class)).toComponent((CommandListenerWrapper)var0.getSource(), ((CommandListenerWrapper)var0.getSource()).hasPermission(2));
    }

    public a parse(StringReader var0) throws CommandSyntaxException {
        return a.parseText(var0, true);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class a {
        private final String text;
        private final b[] parts;

        public a(String var0, b[] var1) {
            this.text = var0;
            this.parts = var1;
        }

        public String getText() {
            return this.text;
        }

        public b[] getParts() {
            return this.parts;
        }

        public IChatBaseComponent toComponent(CommandListenerWrapper var0, boolean var1) throws CommandSyntaxException {
            if (this.parts.length == 0 || !var1) {
                return new ChatComponentText(this.text);
            }
            ChatComponentText var2 = new ChatComponentText(this.text.substring(0, this.parts[0].getStart()));
            int var3 = this.parts[0].getStart();
            for (b var7 : this.parts) {
                IChatBaseComponent var8 = var7.toComponent(var0);
                if (var3 < var7.getStart()) {
                    var2.append(this.text.substring(var3, var7.getStart()));
                }
                if (var8 != null) {
                    var2.append(var8);
                }
                var3 = var7.getEnd();
            }
            if (var3 < this.text.length()) {
                var2.append(this.text.substring(var3));
            }
            return var2;
        }

        public static a parseText(StringReader var0, boolean var1) throws CommandSyntaxException {
            String var2 = var0.getString().substring(var0.getCursor(), var0.getTotalLength());
            if (!var1) {
                var0.setCursor(var0.getTotalLength());
                return new a(var2, new b[0]);
            }
            ArrayList var3 = Lists.newArrayList();
            int var4 = var0.getCursor();
            while (var0.canRead()) {
                if (var0.peek() == '@') {
                    EntitySelector var6;
                    int var5 = var0.getCursor();
                    try {
                        ArgumentParserSelector var7 = new ArgumentParserSelector(var0);
                        var6 = var7.parse();
                    }
                    catch (CommandSyntaxException var7) {
                        if (var7.getType() == ArgumentParserSelector.ERROR_MISSING_SELECTOR_TYPE || var7.getType() == ArgumentParserSelector.ERROR_UNKNOWN_SELECTOR_TYPE) {
                            var0.setCursor(var5 + 1);
                            continue;
                        }
                        throw var7;
                    }
                    var3.add(new b(var5 - var4, var0.getCursor() - var4, var6));
                    continue;
                }
                var0.skip();
            }
            return new a(var2, var3.toArray(new b[0]));
        }
    }

    public static class b {
        private final int start;
        private final int end;
        private final EntitySelector selector;

        public b(int var0, int var1, EntitySelector var2) {
            this.start = var0;
            this.end = var1;
            this.selector = var2;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public EntitySelector getSelector() {
            return this.selector;
        }

        @Nullable
        public IChatBaseComponent toComponent(CommandListenerWrapper var0) throws CommandSyntaxException {
            return EntitySelector.joinNames(this.selector.findEntities(var0));
        }
    }
}

