/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.INamable;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;

public class CriterionTriggerProperties {
    public static final CriterionTriggerProperties ANY = new CriterionTriggerProperties((List<c>)ImmutableList.of());
    private final List<c> properties;

    private static c fromJson(String var0, JsonElement var1) {
        if (var1.isJsonPrimitive()) {
            String var2 = var1.getAsString();
            return new b(var0, var2);
        }
        JsonObject var2 = ChatDeserializer.convertToJsonObject(var1, "value");
        String var3 = var2.has("min") ? CriterionTriggerProperties.getStringOrNull(var2.get("min")) : null;
        String var4 = var2.has("max") ? CriterionTriggerProperties.getStringOrNull(var2.get("max")) : null;
        return var3 != null && var3.equals(var4) ? new b(var0, var3) : new d(var0, var3, var4);
    }

    @Nullable
    private static String getStringOrNull(JsonElement var0) {
        if (var0.isJsonNull()) {
            return null;
        }
        return var0.getAsString();
    }

    CriterionTriggerProperties(List<c> var0) {
        this.properties = ImmutableList.copyOf(var0);
    }

    public <S extends IBlockDataHolder<?, S>> boolean matches(BlockStateList<?, S> var0, S var1) {
        for (c var3 : this.properties) {
            if (var3.match(var0, var1)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(IBlockData var0) {
        return this.matches(var0.getBlock().getStateDefinition(), var0);
    }

    public boolean matches(Fluid var0) {
        return this.matches(var0.getType().getStateDefinition(), var0);
    }

    public void checkState(BlockStateList<?, ?> var0, Consumer<String> var1) {
        this.properties.forEach(var2 -> var2.checkState(var0, var1));
    }

    public static CriterionTriggerProperties fromJson(@Nullable JsonElement var0) {
        if (var0 == null || var0.isJsonNull()) {
            return ANY;
        }
        JsonObject var1 = ChatDeserializer.convertToJsonObject(var0, "properties");
        ArrayList var2 = Lists.newArrayList();
        for (Map.Entry var4 : var1.entrySet()) {
            var2.add(CriterionTriggerProperties.fromJson((String)var4.getKey(), (JsonElement)var4.getValue()));
        }
        return new CriterionTriggerProperties(var2);
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject var0 = new JsonObject();
        if (!this.properties.isEmpty()) {
            this.properties.forEach(var1 -> var0.add(var1.getName(), var1.toJson()));
        }
        return var0;
    }

    static class b
    extends c {
        private final String value;

        public b(String var0, String var1) {
            super(var0);
            this.value = var1;
        }

        @Override
        protected <T extends Comparable<T>> boolean match(IBlockDataHolder<?, ?> var0, IBlockState<T> var1) {
            Comparable var2 = var0.getValue(var1);
            Optional<T> var3 = var1.getValue(this.value);
            return var3.isPresent() && var2.compareTo((Comparable)((Comparable)var3.get())) == 0;
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive(this.value);
        }
    }

    static class d
    extends c {
        @Nullable
        private final String minValue;
        @Nullable
        private final String maxValue;

        public d(String var0, @Nullable String var1, @Nullable String var2) {
            super(var0);
            this.minValue = var1;
            this.maxValue = var2;
        }

        @Override
        protected <T extends Comparable<T>> boolean match(IBlockDataHolder<?, ?> var0, IBlockState<T> var1) {
            Optional<T> var3;
            Comparable var2 = var0.getValue(var1);
            if (!(this.minValue == null || (var3 = var1.getValue(this.minValue)).isPresent() && var2.compareTo((Comparable)((Comparable)var3.get())) >= 0)) {
                return false;
            }
            return this.maxValue == null || (var3 = var1.getValue(this.maxValue)).isPresent() && var2.compareTo((Comparable)((Comparable)var3.get())) <= 0;
        }

        @Override
        public JsonElement toJson() {
            JsonObject var0 = new JsonObject();
            if (this.minValue != null) {
                var0.addProperty("min", this.minValue);
            }
            if (this.maxValue != null) {
                var0.addProperty("max", this.maxValue);
            }
            return var0;
        }
    }

    static abstract class c {
        private final String name;

        public c(String var0) {
            this.name = var0;
        }

        public <S extends IBlockDataHolder<?, S>> boolean match(BlockStateList<?, S> var0, S var1) {
            IBlockState<?> var2 = var0.getProperty(this.name);
            if (var2 == null) {
                return false;
            }
            return this.match(var1, var2);
        }

        protected abstract <T extends Comparable<T>> boolean match(IBlockDataHolder<?, ?> var1, IBlockState<T> var2);

        public abstract JsonElement toJson();

        public String getName() {
            return this.name;
        }

        public void checkState(BlockStateList<?, ?> var0, Consumer<String> var1) {
            IBlockState<?> var2 = var0.getProperty(this.name);
            if (var2 == null) {
                var1.accept(this.name);
            }
        }
    }

    public static class a {
        private final List<c> matchers = Lists.newArrayList();

        private a() {
        }

        public static a properties() {
            return new a();
        }

        public a hasProperty(IBlockState<?> var0, String var1) {
            this.matchers.add(new b(var0.getName(), var1));
            return this;
        }

        public a hasProperty(IBlockState<Integer> var0, int var1) {
            return this.hasProperty((IBlockState)var0, (Comparable<T> & INamable)Integer.toString(var1));
        }

        public a hasProperty(IBlockState<Boolean> var0, boolean var1) {
            return this.hasProperty((IBlockState)var0, (Comparable<T> & INamable)Boolean.toString(var1));
        }

        public <T extends Comparable<T> & INamable> a hasProperty(IBlockState<T> var0, T var1) {
            return this.hasProperty(var0, (T)((INamable)var1).getSerializedName());
        }

        public CriterionTriggerProperties build() {
            return new CriterionTriggerProperties(this.matchers);
        }
    }
}

