/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionEnchantments;
import net.minecraft.advancements.critereon.CriterionConditionNBT;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemEnchantedBook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IMaterial;

public class CriterionConditionItem {
    public static final CriterionConditionItem ANY = new CriterionConditionItem();
    @Nullable
    private final TagKey<Item> tag;
    @Nullable
    private final Set<Item> items;
    private final CriterionConditionValue.IntegerRange count;
    private final CriterionConditionValue.IntegerRange durability;
    private final CriterionConditionEnchantments[] enchantments;
    private final CriterionConditionEnchantments[] storedEnchantments;
    @Nullable
    private final PotionRegistry potion;
    private final CriterionConditionNBT nbt;

    public CriterionConditionItem() {
        this.tag = null;
        this.items = null;
        this.potion = null;
        this.count = CriterionConditionValue.IntegerRange.ANY;
        this.durability = CriterionConditionValue.IntegerRange.ANY;
        this.enchantments = CriterionConditionEnchantments.NONE;
        this.storedEnchantments = CriterionConditionEnchantments.NONE;
        this.nbt = CriterionConditionNBT.ANY;
    }

    public CriterionConditionItem(@Nullable TagKey<Item> var0, @Nullable Set<Item> var1, CriterionConditionValue.IntegerRange var2, CriterionConditionValue.IntegerRange var3, CriterionConditionEnchantments[] var4, CriterionConditionEnchantments[] var5, @Nullable PotionRegistry var6, CriterionConditionNBT var7) {
        this.tag = var0;
        this.items = var1;
        this.count = var2;
        this.durability = var3;
        this.enchantments = var4;
        this.storedEnchantments = var5;
        this.potion = var6;
        this.nbt = var7;
    }

    public boolean matches(ItemStack var0) {
        Map<Enchantment, Integer> var1;
        if (this == ANY) {
            return true;
        }
        if (this.tag != null && !var0.is(this.tag)) {
            return false;
        }
        if (this.items != null && !this.items.contains(var0.getItem())) {
            return false;
        }
        if (!this.count.matches(var0.getCount())) {
            return false;
        }
        if (!this.durability.isAny() && !var0.isDamageableItem()) {
            return false;
        }
        if (!this.durability.matches(var0.getMaxDamage() - var0.getDamageValue())) {
            return false;
        }
        if (!this.nbt.matches(var0)) {
            return false;
        }
        if (this.enchantments.length > 0) {
            var1 = EnchantmentManager.deserializeEnchantments(var0.getEnchantmentTags());
            for (CriterionConditionEnchantments var5 : this.enchantments) {
                if (var5.containedIn(var1)) continue;
                return false;
            }
        }
        if (this.storedEnchantments.length > 0) {
            var1 = EnchantmentManager.deserializeEnchantments(ItemEnchantedBook.getEnchantments(var0));
            for (CriterionConditionEnchantments var5 : this.storedEnchantments) {
                if (var5.containedIn(var1)) continue;
                return false;
            }
        }
        var1 = PotionUtil.getPotion(var0);
        return this.potion == null || this.potion == var1;
    }

    public static CriterionConditionItem fromJson(@Nullable JsonElement var0) {
        Object var8;
        CriterionConditionEnchantments[] var10;
        CriterionConditionEnchantments[] var92;
        Object var7;
        if (var0 == null || var0.isJsonNull()) {
            return ANY;
        }
        JsonObject var1 = ChatDeserializer.convertToJsonObject(var0, "item");
        CriterionConditionValue.IntegerRange var2 = CriterionConditionValue.IntegerRange.fromJson(var1.get("count"));
        CriterionConditionValue.IntegerRange var3 = CriterionConditionValue.IntegerRange.fromJson(var1.get("durability"));
        if (var1.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        CriterionConditionNBT var4 = CriterionConditionNBT.fromJson(var1.get("nbt"));
        ImmutableSet var5 = null;
        JsonArray var6 = ChatDeserializer.getAsJsonArray(var1, "items", null);
        if (var6 != null) {
            var7 = ImmutableSet.builder();
            for (CriterionConditionEnchantments[] var92 : var6) {
                var10 = new MinecraftKey(ChatDeserializer.convertToString((JsonElement)var92, "item"));
                var7.add((Object)IRegistry.ITEM.getOptional((MinecraftKey)var10).orElseThrow(() -> CriterionConditionItem.b((MinecraftKey)var10)));
            }
            var5 = var7.build();
        }
        var7 = null;
        if (var1.has("tag")) {
            var8 = new MinecraftKey(ChatDeserializer.getAsString(var1, "tag"));
            var7 = TagKey.create(IRegistry.ITEM_REGISTRY, (MinecraftKey)var8);
        }
        var8 = null;
        if (var1.has("potion")) {
            var92 = new MinecraftKey(ChatDeserializer.getAsString(var1, "potion"));
            var8 = IRegistry.POTION.getOptional((MinecraftKey)var92).orElseThrow(() -> CriterionConditionItem.a((MinecraftKey)var92));
        }
        var92 = CriterionConditionEnchantments.fromJsonArray(var1.get("enchantments"));
        var10 = CriterionConditionEnchantments.fromJsonArray(var1.get("stored_enchantments"));
        return new CriterionConditionItem((TagKey<Item>)var7, (Set<Item>)var5, var2, var3, var92, var10, (PotionRegistry)var8, var4);
    }

    public JsonElement serializeToJson() {
        JsonArray var1;
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject var0 = new JsonObject();
        if (this.items != null) {
            var1 = new JsonArray();
            for (Item var3 : this.items) {
                var1.add(IRegistry.ITEM.getKey(var3).toString());
            }
            var0.add("items", (JsonElement)var1);
        }
        if (this.tag != null) {
            var0.addProperty("tag", this.tag.location().toString());
        }
        var0.add("count", this.count.serializeToJson());
        var0.add("durability", this.durability.serializeToJson());
        var0.add("nbt", this.nbt.serializeToJson());
        if (this.enchantments.length > 0) {
            var1 = new JsonArray();
            for (CriterionConditionEnchantments var5 : this.enchantments) {
                var1.add(var5.serializeToJson());
            }
            var0.add("enchantments", (JsonElement)var1);
        }
        if (this.storedEnchantments.length > 0) {
            var1 = new JsonArray();
            for (CriterionConditionEnchantments var5 : this.storedEnchantments) {
                var1.add(var5.serializeToJson());
            }
            var0.add("stored_enchantments", (JsonElement)var1);
        }
        if (this.potion != null) {
            var0.addProperty("potion", IRegistry.POTION.getKey(this.potion).toString());
        }
        return var0;
    }

    public static CriterionConditionItem[] fromJsonArray(@Nullable JsonElement var0) {
        if (var0 == null || var0.isJsonNull()) {
            return new CriterionConditionItem[0];
        }
        JsonArray var1 = ChatDeserializer.convertToJsonArray(var0, "items");
        CriterionConditionItem[] var2 = new CriterionConditionItem[var1.size()];
        for (int var3 = 0; var3 < var2.length; ++var3) {
            var2[var3] = CriterionConditionItem.fromJson(var1.get(var3));
        }
        return var2;
    }

    private static /* synthetic */ JsonSyntaxException a(MinecraftKey var0) {
        return new JsonSyntaxException("Unknown potion '" + var0 + "'");
    }

    private static /* synthetic */ JsonSyntaxException b(MinecraftKey var0) {
        return new JsonSyntaxException("Unknown item id '" + var0 + "'");
    }

    public static class a {
        private final List<CriterionConditionEnchantments> enchantments = Lists.newArrayList();
        private final List<CriterionConditionEnchantments> storedEnchantments = Lists.newArrayList();
        @Nullable
        private Set<Item> items;
        @Nullable
        private TagKey<Item> tag;
        private CriterionConditionValue.IntegerRange count = CriterionConditionValue.IntegerRange.ANY;
        private CriterionConditionValue.IntegerRange durability = CriterionConditionValue.IntegerRange.ANY;
        @Nullable
        private PotionRegistry potion;
        private CriterionConditionNBT nbt = CriterionConditionNBT.ANY;

        private a() {
        }

        public static a item() {
            return new a();
        }

        public a of(IMaterial ... var0) {
            this.items = (Set)Stream.of(var0).map(IMaterial::asItem).collect(ImmutableSet.toImmutableSet());
            return this;
        }

        public a of(TagKey<Item> var0) {
            this.tag = var0;
            return this;
        }

        public a withCount(CriterionConditionValue.IntegerRange var0) {
            this.count = var0;
            return this;
        }

        public a hasDurability(CriterionConditionValue.IntegerRange var0) {
            this.durability = var0;
            return this;
        }

        public a isPotion(PotionRegistry var0) {
            this.potion = var0;
            return this;
        }

        public a hasNbt(NBTTagCompound var0) {
            this.nbt = new CriterionConditionNBT(var0);
            return this;
        }

        public a hasEnchantment(CriterionConditionEnchantments var0) {
            this.enchantments.add(var0);
            return this;
        }

        public a hasStoredEnchantment(CriterionConditionEnchantments var0) {
            this.storedEnchantments.add(var0);
            return this;
        }

        public CriterionConditionItem build() {
            return new CriterionConditionItem(this.tag, this.items, this.count, this.durability, this.enchantments.toArray(CriterionConditionEnchantments.NONE), this.storedEnchantments.toArray(CriterionConditionEnchantments.NONE), this.potion, this.nbt);
        }
    }
}

