/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import javax.annotation.Nullable;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.EntityFishingHook;

public class CriterionConditionInOpenWater {
    public static final CriterionConditionInOpenWater ANY = new CriterionConditionInOpenWater(false);
    private static final String IN_OPEN_WATER_KEY = "in_open_water";
    private final boolean inOpenWater;

    private CriterionConditionInOpenWater(boolean var0) {
        this.inOpenWater = var0;
    }

    public static CriterionConditionInOpenWater inOpenWater(boolean var0) {
        return new CriterionConditionInOpenWater(var0);
    }

    public static CriterionConditionInOpenWater fromJson(@Nullable JsonElement var0) {
        if (var0 == null || var0.isJsonNull()) {
            return ANY;
        }
        JsonObject var1 = ChatDeserializer.convertToJsonObject(var0, "fishing_hook");
        JsonElement var2 = var1.get(IN_OPEN_WATER_KEY);
        if (var2 != null) {
            return new CriterionConditionInOpenWater(ChatDeserializer.convertToBoolean(var2, IN_OPEN_WATER_KEY));
        }
        return ANY;
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject var0 = new JsonObject();
        var0.add(IN_OPEN_WATER_KEY, (JsonElement)new JsonPrimitive(Boolean.valueOf(this.inOpenWater)));
        return var0;
    }

    public boolean matches(Entity var0) {
        if (this == ANY) {
            return true;
        }
        if (!(var0 instanceof EntityFishingHook)) {
            return false;
        }
        EntityFishingHook var1 = (EntityFishingHook)var0;
        return this.inOpenWater == var1.isOpenWaterFishing();
    }
}

