/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.base.Joiner;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.EntityTypes;

public abstract class CriterionConditionEntityType {
    public static final CriterionConditionEntityType ANY = new CriterionConditionEntityType(){

        @Override
        public boolean matches(EntityTypes<?> var0) {
            return true;
        }

        @Override
        public JsonElement serializeToJson() {
            return JsonNull.INSTANCE;
        }
    };
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ");

    public abstract boolean matches(EntityTypes<?> var1);

    public abstract JsonElement serializeToJson();

    public static CriterionConditionEntityType fromJson(@Nullable JsonElement var0) {
        if (var0 == null || var0.isJsonNull()) {
            return ANY;
        }
        String var1 = ChatDeserializer.convertToString(var0, "type");
        if (var1.startsWith("#")) {
            MinecraftKey var2 = new MinecraftKey(var1.substring(1));
            return new a(TagKey.create(IRegistry.ENTITY_TYPE_REGISTRY, var2));
        }
        MinecraftKey var2 = new MinecraftKey(var1);
        EntityTypes<?> var3 = IRegistry.ENTITY_TYPE.getOptional(var2).orElseThrow(() -> new JsonSyntaxException("Unknown entity type '" + var2 + "', valid types are: " + COMMA_JOINER.join(IRegistry.ENTITY_TYPE.keySet())));
        return new b(var3);
    }

    public static CriterionConditionEntityType of(EntityTypes<?> var0) {
        return new b(var0);
    }

    public static CriterionConditionEntityType of(TagKey<EntityTypes<?>> var0) {
        return new a(var0);
    }

    static class a
    extends CriterionConditionEntityType {
        private final TagKey<EntityTypes<?>> tag;

        public a(TagKey<EntityTypes<?>> var0) {
            this.tag = var0;
        }

        @Override
        public boolean matches(EntityTypes<?> var0) {
            return var0.is(this.tag);
        }

        @Override
        public JsonElement serializeToJson() {
            return new JsonPrimitive("#" + this.tag.location());
        }
    }

    static class b
    extends CriterionConditionEntityType {
        private final EntityTypes<?> type;

        public b(EntityTypes<?> var0) {
            this.type = var0;
        }

        @Override
        public boolean matches(EntityTypes<?> var0) {
            return this.type == var0;
        }

        @Override
        public JsonElement serializeToJson() {
            return new JsonPrimitive(IRegistry.ENTITY_TYPE.getKey(this.type).toString());
        }
    }
}

