/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;

public class CriterionConditionEntityFlags {
    public static final CriterionConditionEntityFlags ANY = new a().build();
    @Nullable
    private final Boolean isOnFire;
    @Nullable
    private final Boolean isCrouching;
    @Nullable
    private final Boolean isSprinting;
    @Nullable
    private final Boolean isSwimming;
    @Nullable
    private final Boolean isBaby;

    public CriterionConditionEntityFlags(@Nullable Boolean var0, @Nullable Boolean var1, @Nullable Boolean var2, @Nullable Boolean var3, @Nullable Boolean var4) {
        this.isOnFire = var0;
        this.isCrouching = var1;
        this.isSprinting = var2;
        this.isSwimming = var3;
        this.isBaby = var4;
    }

    public boolean matches(Entity var0) {
        if (this.isOnFire != null && var0.isOnFire() != this.isOnFire.booleanValue()) {
            return false;
        }
        if (this.isCrouching != null && var0.isCrouching() != this.isCrouching.booleanValue()) {
            return false;
        }
        if (this.isSprinting != null && var0.isSprinting() != this.isSprinting.booleanValue()) {
            return false;
        }
        if (this.isSwimming != null && var0.isSwimming() != this.isSwimming.booleanValue()) {
            return false;
        }
        return this.isBaby == null || !(var0 instanceof EntityLiving) || ((EntityLiving)var0).isBaby() == this.isBaby.booleanValue();
    }

    @Nullable
    private static Boolean getOptionalBoolean(JsonObject var0, String var1) {
        return var0.has(var1) ? Boolean.valueOf(ChatDeserializer.getAsBoolean(var0, var1)) : null;
    }

    public static CriterionConditionEntityFlags fromJson(@Nullable JsonElement var0) {
        if (var0 == null || var0.isJsonNull()) {
            return ANY;
        }
        JsonObject var1 = ChatDeserializer.convertToJsonObject(var0, "entity flags");
        Boolean var2 = CriterionConditionEntityFlags.getOptionalBoolean(var1, "is_on_fire");
        Boolean var3 = CriterionConditionEntityFlags.getOptionalBoolean(var1, "is_sneaking");
        Boolean var4 = CriterionConditionEntityFlags.getOptionalBoolean(var1, "is_sprinting");
        Boolean var5 = CriterionConditionEntityFlags.getOptionalBoolean(var1, "is_swimming");
        Boolean var6 = CriterionConditionEntityFlags.getOptionalBoolean(var1, "is_baby");
        return new CriterionConditionEntityFlags(var2, var3, var4, var5, var6);
    }

    private void addOptionalBoolean(JsonObject var0, String var1, @Nullable Boolean var2) {
        if (var2 != null) {
            var0.addProperty(var1, var2);
        }
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject var0 = new JsonObject();
        this.addOptionalBoolean(var0, "is_on_fire", this.isOnFire);
        this.addOptionalBoolean(var0, "is_sneaking", this.isCrouching);
        this.addOptionalBoolean(var0, "is_sprinting", this.isSprinting);
        this.addOptionalBoolean(var0, "is_swimming", this.isSwimming);
        this.addOptionalBoolean(var0, "is_baby", this.isBaby);
        return var0;
    }

    public static class a {
        @Nullable
        private Boolean isOnFire;
        @Nullable
        private Boolean isCrouching;
        @Nullable
        private Boolean isSprinting;
        @Nullable
        private Boolean isSwimming;
        @Nullable
        private Boolean isBaby;

        public static a flags() {
            return new a();
        }

        public a setOnFire(@Nullable Boolean var0) {
            this.isOnFire = var0;
            return this;
        }

        public a setCrouching(@Nullable Boolean var0) {
            this.isCrouching = var0;
            return this;
        }

        public a setSprinting(@Nullable Boolean var0) {
            this.isSprinting = var0;
            return this;
        }

        public a setSwimming(@Nullable Boolean var0) {
            this.isSwimming = var0;
            return this;
        }

        public a setIsBaby(@Nullable Boolean var0) {
            this.isBaby = var0;
            return this;
        }

        public CriterionConditionEntityFlags build() {
            return new CriterionConditionEntityFlags(this.isOnFire, this.isCrouching, this.isSprinting, this.isSwimming, this.isBaby);
        }
    }
}

