/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class EnumChatFormat
extends Enum<EnumChatFormat> {
    public static final /* enum */ EnumChatFormat BLACK = new EnumChatFormat("BLACK", '0', 0, 0);
    public static final /* enum */ EnumChatFormat DARK_BLUE = new EnumChatFormat("DARK_BLUE", '1', 1, 170);
    public static final /* enum */ EnumChatFormat DARK_GREEN = new EnumChatFormat("DARK_GREEN", '2', 2, 43520);
    public static final /* enum */ EnumChatFormat DARK_AQUA = new EnumChatFormat("DARK_AQUA", '3', 3, 43690);
    public static final /* enum */ EnumChatFormat DARK_RED = new EnumChatFormat("DARK_RED", '4', 4, 0xAA0000);
    public static final /* enum */ EnumChatFormat DARK_PURPLE = new EnumChatFormat("DARK_PURPLE", '5', 5, 0xAA00AA);
    public static final /* enum */ EnumChatFormat GOLD = new EnumChatFormat("GOLD", '6', 6, 0xFFAA00);
    public static final /* enum */ EnumChatFormat GRAY = new EnumChatFormat("GRAY", '7', 7, 0xAAAAAA);
    public static final /* enum */ EnumChatFormat DARK_GRAY = new EnumChatFormat("DARK_GRAY", '8', 8, 0x555555);
    public static final /* enum */ EnumChatFormat BLUE = new EnumChatFormat("BLUE", '9', 9, 0x5555FF);
    public static final /* enum */ EnumChatFormat GREEN = new EnumChatFormat("GREEN", 'a', 10, 0x55FF55);
    public static final /* enum */ EnumChatFormat AQUA = new EnumChatFormat("AQUA", 'b', 11, 0x55FFFF);
    public static final /* enum */ EnumChatFormat RED = new EnumChatFormat("RED", 'c', 12, 0xFF5555);
    public static final /* enum */ EnumChatFormat LIGHT_PURPLE = new EnumChatFormat("LIGHT_PURPLE", 'd', 13, 0xFF55FF);
    public static final /* enum */ EnumChatFormat YELLOW = new EnumChatFormat("YELLOW", 'e', 14, 0xFFFF55);
    public static final /* enum */ EnumChatFormat WHITE = new EnumChatFormat("WHITE", 'f', 15, 0xFFFFFF);
    public static final /* enum */ EnumChatFormat OBFUSCATED = new EnumChatFormat("OBFUSCATED", 'k', true);
    public static final /* enum */ EnumChatFormat BOLD = new EnumChatFormat("BOLD", 'l', true);
    public static final /* enum */ EnumChatFormat STRIKETHROUGH = new EnumChatFormat("STRIKETHROUGH", 'm', true);
    public static final /* enum */ EnumChatFormat UNDERLINE = new EnumChatFormat("UNDERLINE", 'n', true);
    public static final /* enum */ EnumChatFormat ITALIC = new EnumChatFormat("ITALIC", 'o', true);
    public static final /* enum */ EnumChatFormat RESET = new EnumChatFormat("RESET", 'r', -1, null);
    public static final char PREFIX_CODE = '\u00a7';
    private static final Map<String, EnumChatFormat> FORMATTING_BY_NAME;
    private static final Pattern STRIP_FORMATTING_PATTERN;
    private final String name;
    public final char code;
    private final boolean isFormat;
    private final String toString;
    private final int id;
    @Nullable
    private final Integer color;
    private static final /* synthetic */ EnumChatFormat[] F;

    public static EnumChatFormat[] values() {
        return (EnumChatFormat[])F.clone();
    }

    public static EnumChatFormat valueOf(String var0) {
        return Enum.valueOf(EnumChatFormat.class, var0);
    }

    private static String cleanName(String var0) {
        return var0.toLowerCase(Locale.ROOT).replaceAll("[^a-z]", "");
    }

    private EnumChatFormat(String var2, char var3, int var4, Integer var5) {
        this(var2, var3, false, var4, var5);
    }

    private EnumChatFormat(String var2, char var3, boolean var4) {
        this(var2, var3, var4, -1, null);
    }

    private EnumChatFormat(String var2, char var3, boolean var4, int var5, Integer var6) {
        this.name = var2;
        this.code = var3;
        this.isFormat = var4;
        this.id = var5;
        this.color = var6;
        this.toString = "\u00a7" + var3;
    }

    public char getChar() {
        return this.code;
    }

    public int getId() {
        return this.id;
    }

    public boolean isFormat() {
        return this.isFormat;
    }

    public boolean isColor() {
        return !this.isFormat && this != RESET;
    }

    @Nullable
    public Integer getColor() {
        return this.color;
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String toString() {
        return this.toString;
    }

    @Nullable
    public static String stripFormatting(@Nullable String var0) {
        return var0 == null ? null : STRIP_FORMATTING_PATTERN.matcher(var0).replaceAll("");
    }

    @Nullable
    public static EnumChatFormat getByName(@Nullable String var0) {
        if (var0 == null) {
            return null;
        }
        return FORMATTING_BY_NAME.get(EnumChatFormat.cleanName(var0));
    }

    @Nullable
    public static EnumChatFormat getById(int var0) {
        if (var0 < 0) {
            return RESET;
        }
        for (EnumChatFormat var4 : EnumChatFormat.values()) {
            if (var4.getId() != var0) continue;
            return var4;
        }
        return null;
    }

    @Nullable
    public static EnumChatFormat getByCode(char var0) {
        char var1 = Character.toString(var0).toLowerCase(Locale.ROOT).charAt(0);
        for (EnumChatFormat var5 : EnumChatFormat.values()) {
            if (var5.code != var1) continue;
            return var5;
        }
        return null;
    }

    public static Collection<String> getNames(boolean var0, boolean var1) {
        ArrayList var2 = Lists.newArrayList();
        for (EnumChatFormat var6 : EnumChatFormat.values()) {
            if (var6.isColor() && !var0 || var6.isFormat() && !var1) continue;
            var2.add(var6.getName());
        }
        return var2;
    }

    private static /* synthetic */ EnumChatFormat[] g() {
        return new EnumChatFormat[]{BLACK, DARK_BLUE, DARK_GREEN, DARK_AQUA, DARK_RED, DARK_PURPLE, GOLD, GRAY, DARK_GRAY, BLUE, GREEN, AQUA, RED, LIGHT_PURPLE, YELLOW, WHITE, OBFUSCATED, BOLD, STRIKETHROUGH, UNDERLINE, ITALIC, RESET};
    }

    static {
        F = EnumChatFormat.g();
        FORMATTING_BY_NAME = Arrays.stream(EnumChatFormat.values()).collect(Collectors.toMap(var0 -> EnumChatFormat.cleanName(var0.name), var0 -> var0));
        STRIP_FORMATTING_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    }
}

