/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.timers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.timers.CustomFunctionCallback;
import net.minecraft.world.level.timers.CustomFunctionCallbackTag;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomFunctionCallbackTimers<C> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final CustomFunctionCallbackTimers<MinecraftServer> SERVER_CALLBACKS = new CustomFunctionCallbackTimers<MinecraftServer>().register(new CustomFunctionCallback.a()).register(new CustomFunctionCallbackTag.a());
    private final Map<MinecraftKey, CustomFunctionCallbackTimer.a<C, ?>> idToSerializer = Maps.newHashMap();
    private final Map<Class<?>, CustomFunctionCallbackTimer.a<C, ?>> classToSerializer = Maps.newHashMap();

    @VisibleForTesting
    public CustomFunctionCallbackTimers() {
    }

    public CustomFunctionCallbackTimers<C> register(CustomFunctionCallbackTimer.a<C, ?> var0) {
        this.idToSerializer.put(var0.getId(), var0);
        this.classToSerializer.put(var0.getCls(), var0);
        return this;
    }

    private <T extends CustomFunctionCallbackTimer<C>> CustomFunctionCallbackTimer.a<C, T> getSerializer(Class<?> var0) {
        return this.classToSerializer.get(var0);
    }

    public <T extends CustomFunctionCallbackTimer<C>> NBTTagCompound serialize(T var0) {
        CustomFunctionCallbackTimer.a<T, T> var1 = this.getSerializer(var0.getClass());
        NBTTagCompound var2 = new NBTTagCompound();
        var1.serialize(var2, var0);
        var2.putString("Type", var1.getId().toString());
        return var2;
    }

    @Nullable
    public CustomFunctionCallbackTimer<C> deserialize(NBTTagCompound var0) {
        MinecraftKey var1 = MinecraftKey.tryParse(var0.getString("Type"));
        CustomFunctionCallbackTimer.a<C, ?> var2 = this.idToSerializer.get(var1);
        if (var2 == null) {
            LOGGER.error("Failed to deserialize timer callback: {}", (Object)var0);
            return null;
        }
        try {
            return var2.deserialize(var0);
        }
        catch (Exception var3) {
            LOGGER.error("Failed to deserialize timer callback: {}", (Object)var0, (Object)var3);
            return null;
        }
    }
}

