/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class LootItemConditionTimeCheck
implements LootItemCondition {
    @Nullable
    final Long period;
    final IntRange value;

    LootItemConditionTimeCheck(@Nullable Long var0, IntRange var1) {
        this.period = var0;
        this.value = var1;
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.TIME_CHECK;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return this.value.getReferencedContextParams();
    }

    @Override
    public boolean test(LootTableInfo var0) {
        WorldServer var1 = var0.getLevel();
        long var2 = var1.getDayTime();
        if (this.period != null) {
            var2 %= this.period.longValue();
        }
        return this.value.test(var0, (int)var2);
    }

    public static a time(IntRange var0) {
        return new a(var0);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }

    public static class a
    implements LootItemCondition.a {
        @Nullable
        private Long period;
        private final IntRange value;

        public a(IntRange var0) {
            this.value = var0;
        }

        public a setPeriod(long var0) {
            this.period = var0;
            return this;
        }

        @Override
        public LootItemConditionTimeCheck build() {
            return new LootItemConditionTimeCheck(this.period, this.value);
        }

        @Override
        public /* synthetic */ LootItemCondition build() {
            return this.build();
        }
    }

    public static class b
    implements LootSerializer<LootItemConditionTimeCheck> {
        @Override
        public void serialize(JsonObject var0, LootItemConditionTimeCheck var1, JsonSerializationContext var2) {
            var0.addProperty("period", (Number)var1.period);
            var0.add("value", var2.serialize((Object)var1.value));
        }

        @Override
        public LootItemConditionTimeCheck deserialize(JsonObject var0, JsonDeserializationContext var1) {
            Long var2 = var0.has("period") ? Long.valueOf(ChatDeserializer.getAsLong(var0, "period")) : null;
            IntRange var3 = ChatDeserializer.getAsObject(var0, "value", var1, IntRange.class);
            return new LootItemConditionTimeCheck(var2, var3);
        }

        @Override
        public /* synthetic */ Object deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonObject, jsonDeserializationContext);
        }
    }
}

