/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class LootItemConditionTableBonus
implements LootItemCondition {
    final Enchantment enchantment;
    final float[] values;

    LootItemConditionTableBonus(Enchantment var0, float[] var1) {
        this.enchantment = var0;
        this.values = var1;
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.TABLE_BONUS;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParameters.TOOL);
    }

    @Override
    public boolean test(LootTableInfo var0) {
        ItemStack var1 = var0.getParamOrNull(LootContextParameters.TOOL);
        int var2 = var1 != null ? EnchantmentManager.getItemEnchantmentLevel(this.enchantment, var1) : 0;
        float var3 = this.values[Math.min(var2, this.values.length - 1)];
        return var0.getRandom().nextFloat() < var3;
    }

    public static LootItemCondition.a bonusLevelFlatChance(Enchantment var0, float ... var1) {
        return () -> new LootItemConditionTableBonus(var0, var1);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }

    public static class a
    implements LootSerializer<LootItemConditionTableBonus> {
        @Override
        public void serialize(JsonObject var0, LootItemConditionTableBonus var1, JsonSerializationContext var2) {
            var0.addProperty("enchantment", IRegistry.ENCHANTMENT.getKey(var1.enchantment).toString());
            var0.add("chances", var2.serialize((Object)var1.values));
        }

        @Override
        public LootItemConditionTableBonus deserialize(JsonObject var0, JsonDeserializationContext var1) {
            MinecraftKey var2 = new MinecraftKey(ChatDeserializer.getAsString(var0, "enchantment"));
            Enchantment var3 = IRegistry.ENCHANTMENT.getOptional(var2).orElseThrow(() -> new JsonParseException("Invalid enchantment id: " + var2));
            float[] var4 = ChatDeserializer.getAsObject(var0, "chances", var1, float[].class);
            return new LootItemConditionTableBonus(var3, var4);
        }

        @Override
        public /* synthetic */ Object deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonObject, jsonDeserializationContext);
        }
    }
}

