/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetName;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionSetLore
extends LootItemFunctionConditional {
    final boolean replace;
    final List<IChatBaseComponent> lore;
    @Nullable
    final LootTableInfo.EntityTarget resolutionContext;

    public LootItemFunctionSetLore(LootItemCondition[] var0, boolean var1, List<IChatBaseComponent> var2, @Nullable LootTableInfo.EntityTarget var3) {
        super(var0);
        this.replace = var1;
        this.lore = ImmutableList.copyOf(var2);
        this.resolutionContext = var3;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.SET_LORE;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return this.resolutionContext != null ? ImmutableSet.of(this.resolutionContext.getParam()) : ImmutableSet.of();
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        NBTTagList var2 = this.getLoreTag(var0, !this.lore.isEmpty());
        if (var2 != null) {
            if (this.replace) {
                var2.clear();
            }
            UnaryOperator<IChatBaseComponent> var3 = LootItemFunctionSetName.createResolver(var1, this.resolutionContext);
            this.lore.stream().map(var3).map(IChatBaseComponent.ChatSerializer::toJson).map(NBTTagString::valueOf).forEach(var2::add);
        }
        return var0;
    }

    @Nullable
    private NBTTagList getLoreTag(ItemStack var0, boolean var1) {
        NBTTagCompound var3;
        NBTTagCompound var2;
        if (var0.hasTag()) {
            var2 = var0.getTag();
        } else if (var1) {
            var2 = new NBTTagCompound();
            var0.setTag(var2);
        } else {
            return null;
        }
        if (var2.contains("display", 10)) {
            var3 = var2.getCompound("display");
        } else if (var1) {
            var3 = new NBTTagCompound();
            var2.put("display", var3);
        } else {
            return null;
        }
        if (var3.contains("Lore", 9)) {
            return var3.getList("Lore", 8);
        }
        if (var1) {
            NBTTagList var4 = new NBTTagList();
            var3.put("Lore", var4);
            return var4;
        }
        return null;
    }

    public static a setLore() {
        return new a();
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private boolean replace;
        private LootTableInfo.EntityTarget resolutionContext;
        private final List<IChatBaseComponent> lore = Lists.newArrayList();

        public a setReplace(boolean var0) {
            this.replace = var0;
            return this;
        }

        public a setResolutionContext(LootTableInfo.EntityTarget var0) {
            this.resolutionContext = var0;
            return this;
        }

        public a addLine(IChatBaseComponent var0) {
            this.lore.add(var0);
            return this;
        }

        @Override
        protected a getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootItemFunctionSetLore(this.getConditions(), this.replace, this.lore, this.resolutionContext);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }

    public static class b
    extends LootItemFunctionConditional.c<LootItemFunctionSetLore> {
        @Override
        public void serialize(JsonObject var0, LootItemFunctionSetLore var1, JsonSerializationContext var2) {
            super.serialize(var0, var1, var2);
            var0.addProperty("replace", Boolean.valueOf(var1.replace));
            JsonArray var3 = new JsonArray();
            for (IChatBaseComponent var5 : var1.lore) {
                var3.add(IChatBaseComponent.ChatSerializer.toJsonTree(var5));
            }
            var0.add("lore", (JsonElement)var3);
            if (var1.resolutionContext != null) {
                var0.add("entity", var2.serialize((Object)var1.resolutionContext));
            }
        }

        @Override
        public LootItemFunctionSetLore deserialize(JsonObject var0, JsonDeserializationContext var1, LootItemCondition[] var2) {
            boolean var3 = ChatDeserializer.getAsBoolean(var0, "replace", false);
            List var4 = (List)Streams.stream((Iterable)ChatDeserializer.getAsJsonArray(var0, "lore")).map(IChatBaseComponent.ChatSerializer::fromJson).collect(ImmutableList.toImmutableList());
            LootTableInfo.EntityTarget var5 = ChatDeserializer.getAsObject(var0, "entity", null, var1, LootTableInfo.EntityTarget.class);
            return new LootItemFunctionSetLore(var2, var3, var4, var5);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, lootItemConditionArray);
        }
    }
}

