/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;

public class PathPoint {
    public final int x;
    public final int y;
    public final int z;
    private final int hash;
    public int heapIdx = -1;
    public float g;
    public float h;
    public float f;
    @Nullable
    public PathPoint cameFrom;
    public boolean closed;
    public float walkedDistance;
    public float costMalus;
    public PathType type = PathType.BLOCKED;

    public PathPoint(int var0, int var1, int var2) {
        this.x = var0;
        this.y = var1;
        this.z = var2;
        this.hash = PathPoint.createHash(var0, var1, var2);
    }

    public PathPoint cloneAndMove(int var0, int var1, int var2) {
        PathPoint var3 = new PathPoint(var0, var1, var2);
        var3.heapIdx = this.heapIdx;
        var3.g = this.g;
        var3.h = this.h;
        var3.f = this.f;
        var3.cameFrom = this.cameFrom;
        var3.closed = this.closed;
        var3.walkedDistance = this.walkedDistance;
        var3.costMalus = this.costMalus;
        var3.type = this.type;
        return var3;
    }

    public static int createHash(int var0, int var1, int var2) {
        return var1 & 0xFF | (var0 & Short.MAX_VALUE) << 8 | (var2 & Short.MAX_VALUE) << 24 | (var0 < 0 ? Integer.MIN_VALUE : 0) | (var2 < 0 ? 32768 : 0);
    }

    public float distanceTo(PathPoint var0) {
        float var1 = var0.x - this.x;
        float var2 = var0.y - this.y;
        float var3 = var0.z - this.z;
        return MathHelper.sqrt(var1 * var1 + var2 * var2 + var3 * var3);
    }

    public float distanceTo(BlockPosition var0) {
        float var1 = var0.getX() - this.x;
        float var2 = var0.getY() - this.y;
        float var3 = var0.getZ() - this.z;
        return MathHelper.sqrt(var1 * var1 + var2 * var2 + var3 * var3);
    }

    public float distanceToSqr(PathPoint var0) {
        float var1 = var0.x - this.x;
        float var2 = var0.y - this.y;
        float var3 = var0.z - this.z;
        return var1 * var1 + var2 * var2 + var3 * var3;
    }

    public float distanceToSqr(BlockPosition var0) {
        float var1 = var0.getX() - this.x;
        float var2 = var0.getY() - this.y;
        float var3 = var0.getZ() - this.z;
        return var1 * var1 + var2 * var2 + var3 * var3;
    }

    public float distanceManhattan(PathPoint var0) {
        float var1 = Math.abs(var0.x - this.x);
        float var2 = Math.abs(var0.y - this.y);
        float var3 = Math.abs(var0.z - this.z);
        return var1 + var2 + var3;
    }

    public float distanceManhattan(BlockPosition var0) {
        float var1 = Math.abs(var0.getX() - this.x);
        float var2 = Math.abs(var0.getY() - this.y);
        float var3 = Math.abs(var0.getZ() - this.z);
        return var1 + var2 + var3;
    }

    public BlockPosition asBlockPos() {
        return new BlockPosition(this.x, this.y, this.z);
    }

    public Vec3D asVec3() {
        return new Vec3D(this.x, this.y, this.z);
    }

    public boolean equals(Object var0) {
        if (var0 instanceof PathPoint) {
            PathPoint var1 = (PathPoint)var0;
            return this.hash == var1.hash && this.x == var1.x && this.y == var1.y && this.z == var1.z;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean inOpenSet() {
        return this.heapIdx >= 0;
    }

    public String toString() {
        return "Node{x=" + this.x + ", y=" + this.y + ", z=" + this.z + "}";
    }

    public void writeToStream(PacketDataSerializer var0) {
        var0.writeInt(this.x);
        var0.writeInt(this.y);
        var0.writeInt(this.z);
        var0.writeFloat(this.walkedDistance);
        var0.writeFloat(this.costMalus);
        var0.writeBoolean(this.closed);
        var0.writeInt(this.type.ordinal());
        var0.writeFloat(this.f);
    }

    public static PathPoint createFromStream(PacketDataSerializer var0) {
        PathPoint var1 = new PathPoint(var0.readInt(), var0.readInt(), var0.readInt());
        var1.walkedDistance = var0.readFloat();
        var1.costMalus = var0.readFloat();
        var1.closed = var0.readBoolean();
        var1.type = PathType.values()[var0.readInt()];
        var1.f = var0.readFloat();
        return var1;
    }
}

