/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.LightEngineLayer;
import net.minecraft.world.level.lighting.LightEngineStorageBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.mutable.MutableInt;

public final class LightEngineBlock
extends LightEngineLayer<LightEngineStorageBlock.a, LightEngineStorageBlock> {
    private static final EnumDirection[] DIRECTIONS = EnumDirection.values();
    private final BlockPosition.MutableBlockPosition pos = new BlockPosition.MutableBlockPosition();

    public LightEngineBlock(ILightAccess var0) {
        super(var0, EnumSkyBlock.BLOCK, new LightEngineStorageBlock(var0));
    }

    private int getLightEmission(long var0) {
        int var2 = BlockPosition.getX(var0);
        int var3 = BlockPosition.getY(var0);
        int var4 = BlockPosition.getZ(var0);
        IBlockAccess var5 = this.chunkSource.getChunkForLighting(SectionPosition.blockToSectionCoord(var2), SectionPosition.blockToSectionCoord(var4));
        if (var5 != null) {
            return var5.getLightEmission(this.pos.set(var2, var3, var4));
        }
        return 0;
    }

    @Override
    protected int computeLevelFromNeighbor(long var0, long var2, int var4) {
        VoxelShape var13;
        int var7;
        int var6;
        if (var2 == Long.MAX_VALUE) {
            return 15;
        }
        if (var0 == Long.MAX_VALUE) {
            return var4 + 15 - this.getLightEmission(var2);
        }
        if (var4 >= 15) {
            return var4;
        }
        int var5 = Integer.signum(BlockPosition.getX(var2) - BlockPosition.getX(var0));
        EnumDirection var8 = EnumDirection.fromNormal(var5, var6 = Integer.signum(BlockPosition.getY(var2) - BlockPosition.getY(var0)), var7 = Integer.signum(BlockPosition.getZ(var2) - BlockPosition.getZ(var0)));
        if (var8 == null) {
            return 15;
        }
        MutableInt var9 = new MutableInt();
        IBlockData var10 = this.getStateAndOpacity(var2, var9);
        if (var9.getValue() >= 15) {
            return 15;
        }
        IBlockData var11 = this.getStateAndOpacity(var0, null);
        VoxelShape var12 = this.getShape(var11, var0, var8);
        if (VoxelShapes.faceShapeOccludes(var12, var13 = this.getShape(var10, var2, var8.getOpposite()))) {
            return 15;
        }
        return var4 + Math.max(1, var9.getValue());
    }

    @Override
    protected void checkNeighborsAfterUpdate(long var0, int var2, boolean var3) {
        long var4 = SectionPosition.blockToSection(var0);
        for (EnumDirection var9 : DIRECTIONS) {
            long var10 = BlockPosition.offset(var0, var9);
            long var12 = SectionPosition.blockToSection(var10);
            if (var4 != var12 && !((LightEngineStorageBlock)this.storage).storingLightForSection(var12)) continue;
            this.checkNeighbor(var0, var10, var2, var3);
        }
    }

    @Override
    protected int getComputedLevel(long var0, long var2, int var4) {
        int var5 = var4;
        if (Long.MAX_VALUE != var2) {
            int var6 = this.computeLevelFromNeighbor(Long.MAX_VALUE, var0, 0);
            if (var5 > var6) {
                var5 = var6;
            }
            if (var5 == 0) {
                return var5;
            }
        }
        long var6 = SectionPosition.blockToSection(var0);
        NibbleArray var8 = ((LightEngineStorageBlock)this.storage).getDataLayer(var6, true);
        for (EnumDirection var12 : DIRECTIONS) {
            long var15;
            NibbleArray var17;
            long var13 = BlockPosition.offset(var0, var12);
            if (var13 == var2 || (var17 = var6 == (var15 = SectionPosition.blockToSection(var13)) ? var8 : ((LightEngineStorageBlock)this.storage).getDataLayer(var15, true)) == null) continue;
            int var18 = this.computeLevelFromNeighbor(var13, var0, this.getLevel(var17, var13));
            if (var5 > var18) {
                var5 = var18;
            }
            if (var5 != 0) continue;
            return var5;
        }
        return var5;
    }

    @Override
    public void onBlockEmissionIncrease(BlockPosition var0, int var1) {
        ((LightEngineStorageBlock)this.storage).runAllUpdates();
        this.checkEdge(Long.MAX_VALUE, var0.asLong(), 15 - var1, true);
    }
}

