/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.synth.NoiseGenerator3Handler;
import net.minecraft.world.level.levelgen.synth.NoiseUtils;

public final class NoiseGeneratorPerlin {
    private static final float SHIFT_UP_EPSILON = 1.0E-7f;
    private final byte[] p;
    public final double xo;
    public final double yo;
    public final double zo;

    public NoiseGeneratorPerlin(RandomSource var0) {
        int var1;
        this.xo = var0.nextDouble() * 256.0;
        this.yo = var0.nextDouble() * 256.0;
        this.zo = var0.nextDouble() * 256.0;
        this.p = new byte[256];
        for (var1 = 0; var1 < 256; ++var1) {
            this.p[var1] = (byte)var1;
        }
        for (var1 = 0; var1 < 256; ++var1) {
            int var2 = var0.nextInt(256 - var1);
            byte var3 = this.p[var1];
            this.p[var1] = this.p[var1 + var2];
            this.p[var1 + var2] = var3;
        }
    }

    public double noise(double var0, double var2, double var4) {
        return this.noise(var0, var2, var4, 0.0, 0.0);
    }

    @Deprecated
    public double noise(double var0, double var2, double var4, double var6, double var8) {
        double var25;
        double var10 = var0 + this.xo;
        double var12 = var2 + this.yo;
        double var14 = var4 + this.zo;
        int var16 = MathHelper.floor(var10);
        int var17 = MathHelper.floor(var12);
        int var18 = MathHelper.floor(var14);
        double var19 = var10 - (double)var16;
        double var21 = var12 - (double)var17;
        double var23 = var14 - (double)var18;
        if (var6 != 0.0) {
            double var27 = var8 >= 0.0 && var8 < var21 ? var8 : var21;
            var25 = (double)MathHelper.floor(var27 / var6 + (double)1.0E-7f) * var6;
        } else {
            var25 = 0.0;
        }
        return this.sampleAndLerp(var16, var17, var18, var19, var21 - var25, var23, var21);
    }

    public double noiseWithDerivative(double var0, double var2, double var4, double[] var6) {
        double var7 = var0 + this.xo;
        double var9 = var2 + this.yo;
        double var11 = var4 + this.zo;
        int var13 = MathHelper.floor(var7);
        int var14 = MathHelper.floor(var9);
        int var15 = MathHelper.floor(var11);
        double var16 = var7 - (double)var13;
        double var18 = var9 - (double)var14;
        double var20 = var11 - (double)var15;
        return this.sampleWithDerivative(var13, var14, var15, var16, var18, var20, var6);
    }

    private static double gradDot(int var0, double var1, double var3, double var5) {
        return NoiseGenerator3Handler.dot(NoiseGenerator3Handler.GRADIENT[var0 & 0xF], var1, var3, var5);
    }

    private int p(int var0) {
        return this.p[var0 & 0xFF] & 0xFF;
    }

    private double sampleAndLerp(int var0, int var1, int var2, double var3, double var5, double var7, double var9) {
        int var11 = this.p(var0);
        int var12 = this.p(var0 + 1);
        int var13 = this.p(var11 + var1);
        int var14 = this.p(var11 + var1 + 1);
        int var15 = this.p(var12 + var1);
        int var16 = this.p(var12 + var1 + 1);
        double var17 = NoiseGeneratorPerlin.gradDot(this.p(var13 + var2), var3, var5, var7);
        double var19 = NoiseGeneratorPerlin.gradDot(this.p(var15 + var2), var3 - 1.0, var5, var7);
        double var21 = NoiseGeneratorPerlin.gradDot(this.p(var14 + var2), var3, var5 - 1.0, var7);
        double var23 = NoiseGeneratorPerlin.gradDot(this.p(var16 + var2), var3 - 1.0, var5 - 1.0, var7);
        double var25 = NoiseGeneratorPerlin.gradDot(this.p(var13 + var2 + 1), var3, var5, var7 - 1.0);
        double var27 = NoiseGeneratorPerlin.gradDot(this.p(var15 + var2 + 1), var3 - 1.0, var5, var7 - 1.0);
        double var29 = NoiseGeneratorPerlin.gradDot(this.p(var14 + var2 + 1), var3, var5 - 1.0, var7 - 1.0);
        double var31 = NoiseGeneratorPerlin.gradDot(this.p(var16 + var2 + 1), var3 - 1.0, var5 - 1.0, var7 - 1.0);
        double var33 = MathHelper.smoothstep(var3);
        double var35 = MathHelper.smoothstep(var9);
        double var37 = MathHelper.smoothstep(var7);
        return MathHelper.lerp3(var33, var35, var37, var17, var19, var21, var23, var25, var27, var29, var31);
    }

    private double sampleWithDerivative(int var0, int var1, int var2, double var3, double var5, double var7, double[] var9) {
        int var10 = this.p(var0);
        int var11 = this.p(var0 + 1);
        int var12 = this.p(var10 + var1);
        int var13 = this.p(var10 + var1 + 1);
        int var14 = this.p(var11 + var1);
        int var15 = this.p(var11 + var1 + 1);
        int var16 = this.p(var12 + var2);
        int var17 = this.p(var14 + var2);
        int var18 = this.p(var13 + var2);
        int var19 = this.p(var15 + var2);
        int var20 = this.p(var12 + var2 + 1);
        int var21 = this.p(var14 + var2 + 1);
        int var22 = this.p(var13 + var2 + 1);
        int var23 = this.p(var15 + var2 + 1);
        int[] var24 = NoiseGenerator3Handler.GRADIENT[var16 & 0xF];
        int[] var25 = NoiseGenerator3Handler.GRADIENT[var17 & 0xF];
        int[] var26 = NoiseGenerator3Handler.GRADIENT[var18 & 0xF];
        int[] var27 = NoiseGenerator3Handler.GRADIENT[var19 & 0xF];
        int[] var28 = NoiseGenerator3Handler.GRADIENT[var20 & 0xF];
        int[] var29 = NoiseGenerator3Handler.GRADIENT[var21 & 0xF];
        int[] var30 = NoiseGenerator3Handler.GRADIENT[var22 & 0xF];
        int[] var31 = NoiseGenerator3Handler.GRADIENT[var23 & 0xF];
        double var32 = NoiseGenerator3Handler.dot(var24, var3, var5, var7);
        double var34 = NoiseGenerator3Handler.dot(var25, var3 - 1.0, var5, var7);
        double var36 = NoiseGenerator3Handler.dot(var26, var3, var5 - 1.0, var7);
        double var38 = NoiseGenerator3Handler.dot(var27, var3 - 1.0, var5 - 1.0, var7);
        double var40 = NoiseGenerator3Handler.dot(var28, var3, var5, var7 - 1.0);
        double var42 = NoiseGenerator3Handler.dot(var29, var3 - 1.0, var5, var7 - 1.0);
        double var44 = NoiseGenerator3Handler.dot(var30, var3, var5 - 1.0, var7 - 1.0);
        double var46 = NoiseGenerator3Handler.dot(var31, var3 - 1.0, var5 - 1.0, var7 - 1.0);
        double var48 = MathHelper.smoothstep(var3);
        double var50 = MathHelper.smoothstep(var5);
        double var52 = MathHelper.smoothstep(var7);
        double var54 = MathHelper.lerp3(var48, var50, var52, var24[0], var25[0], var26[0], var27[0], var28[0], var29[0], var30[0], var31[0]);
        double var56 = MathHelper.lerp3(var48, var50, var52, var24[1], var25[1], var26[1], var27[1], var28[1], var29[1], var30[1], var31[1]);
        double var58 = MathHelper.lerp3(var48, var50, var52, var24[2], var25[2], var26[2], var27[2], var28[2], var29[2], var30[2], var31[2]);
        double var60 = MathHelper.lerp2(var50, var52, var34 - var32, var38 - var36, var42 - var40, var46 - var44);
        double var62 = MathHelper.lerp2(var52, var48, var36 - var32, var44 - var40, var38 - var34, var46 - var42);
        double var64 = MathHelper.lerp2(var48, var50, var40 - var32, var42 - var34, var44 - var36, var46 - var38);
        double var66 = MathHelper.smoothstepDerivative(var3);
        double var68 = MathHelper.smoothstepDerivative(var5);
        double var70 = MathHelper.smoothstepDerivative(var7);
        double var72 = var54 + var66 * var60;
        double var74 = var56 + var68 * var62;
        double var76 = var58 + var70 * var64;
        var9[0] = var9[0] + var72;
        var9[1] = var9[1] + var74;
        var9[2] = var9[2] + var76;
        return MathHelper.lerp3(var48, var50, var52, var32, var34, var36, var38, var40, var42, var44, var46);
    }

    @VisibleForTesting
    public void parityConfigString(StringBuilder var0) {
        NoiseUtils.parityNoiseOctaveConfigString(var0, this.xo, this.yo, this.zo, this.p);
    }
}

