/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorOctaves;

public class NoiseGeneratorNormal {
    private static final double INPUT_FACTOR = 1.0181268882175227;
    private static final double TARGET_DEVIATION = 0.3333333333333333;
    private final double valueFactor;
    private final NoiseGeneratorOctaves first;
    private final NoiseGeneratorOctaves second;

    @Deprecated
    public static NoiseGeneratorNormal createLegacyNetherBiome(RandomSource var0, a var1) {
        return new NoiseGeneratorNormal(var0, var1.firstOctave(), var1.amplitudes(), false);
    }

    public static NoiseGeneratorNormal create(RandomSource var0, int var1, double ... var2) {
        return new NoiseGeneratorNormal(var0, var1, (DoubleList)new DoubleArrayList(var2), true);
    }

    public static NoiseGeneratorNormal create(RandomSource var0, a var1) {
        return new NoiseGeneratorNormal(var0, var1.firstOctave(), var1.amplitudes(), true);
    }

    public static NoiseGeneratorNormal create(RandomSource var0, int var1, DoubleList var2) {
        return new NoiseGeneratorNormal(var0, var1, var2, true);
    }

    private NoiseGeneratorNormal(RandomSource var0, int var1, DoubleList var2, boolean var3) {
        if (var3) {
            this.first = NoiseGeneratorOctaves.create(var0, var1, var2);
            this.second = NoiseGeneratorOctaves.create(var0, var1, var2);
        } else {
            this.first = NoiseGeneratorOctaves.createLegacyForLegacyNormalNoise(var0, var1, var2);
            this.second = NoiseGeneratorOctaves.createLegacyForLegacyNormalNoise(var0, var1, var2);
        }
        int var4 = Integer.MAX_VALUE;
        int var5 = Integer.MIN_VALUE;
        DoubleListIterator var6 = var2.iterator();
        while (var6.hasNext()) {
            int var7 = var6.nextIndex();
            double var8 = var6.nextDouble();
            if (var8 == 0.0) continue;
            var4 = Math.min(var4, var7);
            var5 = Math.max(var5, var7);
        }
        this.valueFactor = 0.16666666666666666 / NoiseGeneratorNormal.expectedDeviation(var5 - var4);
    }

    private static double expectedDeviation(int var0) {
        return 0.1 * (1.0 + 1.0 / (double)(var0 + 1));
    }

    public double getValue(double var0, double var2, double var4) {
        double var6 = var0 * 1.0181268882175227;
        double var8 = var2 * 1.0181268882175227;
        double var10 = var4 * 1.0181268882175227;
        return (this.first.getValue(var0, var2, var4) + this.second.getValue(var6, var8, var10)) * this.valueFactor;
    }

    public a parameters() {
        return new a(this.first.firstOctave(), (List<Double>)this.first.amplitudes());
    }

    @VisibleForTesting
    public void parityConfigString(StringBuilder var0) {
        var0.append("NormalNoise {");
        var0.append("first: ");
        this.first.parityConfigString(var0);
        var0.append(", second: ");
        this.second.parityConfigString(var0);
        var0.append("}");
    }

    public static class a {
        private final int firstOctave;
        private final DoubleList amplitudes;
        public static final Codec<a> DIRECT_CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.INT.fieldOf("firstOctave").forGetter(a::firstOctave), (App)Codec.DOUBLE.listOf().fieldOf("amplitudes").forGetter(a::amplitudes)).apply((Applicative)var0, a::new));
        public static final Codec<Supplier<a>> CODEC = RegistryFileCodec.create(IRegistry.NOISE_REGISTRY, DIRECT_CODEC);

        public a(int var0, List<Double> var1) {
            this.firstOctave = var0;
            this.amplitudes = new DoubleArrayList(var1);
        }

        public a(int var0, double var1, double ... var3) {
            this.firstOctave = var0;
            this.amplitudes = new DoubleArrayList(var3);
            this.amplitudes.add(0, var1);
        }

        public int firstOctave() {
            return this.firstOctave;
        }

        public DoubleList amplitudes() {
            return this.amplitudes;
        }
    }
}

