/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;

public class PosRuleTestAxisAlignedLinear
extends PosRuleTest {
    public static final Codec<PosRuleTestAxisAlignedLinear> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.FLOAT.fieldOf("min_chance").orElse((Object)Float.valueOf(0.0f)).forGetter(var0 -> Float.valueOf(var0.minChance)), (App)Codec.FLOAT.fieldOf("max_chance").orElse((Object)Float.valueOf(0.0f)).forGetter(var0 -> Float.valueOf(var0.maxChance)), (App)Codec.INT.fieldOf("min_dist").orElse((Object)0).forGetter(var0 -> var0.minDist), (App)Codec.INT.fieldOf("max_dist").orElse((Object)0).forGetter(var0 -> var0.maxDist), (App)EnumDirection.EnumAxis.CODEC.fieldOf("axis").orElse((Object)EnumDirection.EnumAxis.Y).forGetter(var0 -> var0.axis)).apply((Applicative)var02, PosRuleTestAxisAlignedLinear::new));
    private final float minChance;
    private final float maxChance;
    private final int minDist;
    private final int maxDist;
    private final EnumDirection.EnumAxis axis;

    public PosRuleTestAxisAlignedLinear(float var0, float var1, int var2, int var3, EnumDirection.EnumAxis var4) {
        if (var2 >= var3) {
            throw new IllegalArgumentException("Invalid range: [" + var2 + "," + var3 + "]");
        }
        this.minChance = var0;
        this.maxChance = var1;
        this.minDist = var2;
        this.maxDist = var3;
        this.axis = var4;
    }

    @Override
    public boolean test(BlockPosition var0, BlockPosition var1, BlockPosition var2, Random var3) {
        EnumDirection var4 = EnumDirection.get(EnumDirection.EnumAxisDirection.POSITIVE, this.axis);
        float var5 = Math.abs((var1.getX() - var2.getX()) * var4.getStepX());
        float var6 = Math.abs((var1.getY() - var2.getY()) * var4.getStepY());
        float var7 = Math.abs((var1.getZ() - var2.getZ()) * var4.getStepZ());
        int var8 = (int)(var5 + var6 + var7);
        float var9 = var3.nextFloat();
        return var9 <= MathHelper.clampedLerp(this.minChance, this.maxChance, MathHelper.inverseLerp(var8, this.minDist, this.maxDist));
    }

    @Override
    protected PosRuleTestType<?> getType() {
        return PosRuleTestType.AXIS_ALIGNED_LINEAR_POS_TEST;
    }
}

