/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.ArgumentBlock;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;

public class DefinedStructureProcessorJigsawReplacement
extends DefinedStructureProcessor {
    public static final Codec<DefinedStructureProcessorJigsawReplacement> CODEC = Codec.unit(() -> INSTANCE);
    public static final DefinedStructureProcessorJigsawReplacement INSTANCE = new DefinedStructureProcessorJigsawReplacement();

    private DefinedStructureProcessorJigsawReplacement() {
    }

    @Override
    @Nullable
    public DefinedStructure.BlockInfo processBlock(IWorldReader var0, BlockPosition var1, BlockPosition var2, DefinedStructure.BlockInfo var3, DefinedStructure.BlockInfo var4, DefinedStructureInfo var5) {
        IBlockData var6 = var4.state;
        if (!var6.is(Blocks.JIGSAW)) {
            return var4;
        }
        String var7 = var4.nbt.getString("final_state");
        ArgumentBlock var8 = new ArgumentBlock(new StringReader(var7), false);
        try {
            var8.parse(true);
        }
        catch (CommandSyntaxException var9) {
            throw new RuntimeException(var9);
        }
        if (var8.getState().is(Blocks.STRUCTURE_VOID)) {
            return null;
        }
        return new DefinedStructure.BlockInfo(var4.pos, var8.getState(), null);
    }

    @Override
    protected DefinedStructureStructureProcessorType<?> getType() {
        return DefinedStructureStructureProcessorType.JIGSAW_REPLACEMENT;
    }
}

