/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import java.util.Map;
import java.util.Random;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureShipwreckConfiguration;
import net.minecraft.world.level.levelgen.structure.DefinedStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockIgnore;
import net.minecraft.world.level.storage.loot.LootTables;

public class WorldGenShipwreck {
    static final BlockPosition PIVOT = new BlockPosition(4, 0, 15);
    private static final MinecraftKey[] STRUCTURE_LOCATION_BEACHED = new MinecraftKey[]{new MinecraftKey("shipwreck/with_mast"), new MinecraftKey("shipwreck/sideways_full"), new MinecraftKey("shipwreck/sideways_fronthalf"), new MinecraftKey("shipwreck/sideways_backhalf"), new MinecraftKey("shipwreck/rightsideup_full"), new MinecraftKey("shipwreck/rightsideup_fronthalf"), new MinecraftKey("shipwreck/rightsideup_backhalf"), new MinecraftKey("shipwreck/with_mast_degraded"), new MinecraftKey("shipwreck/rightsideup_full_degraded"), new MinecraftKey("shipwreck/rightsideup_fronthalf_degraded"), new MinecraftKey("shipwreck/rightsideup_backhalf_degraded")};
    private static final MinecraftKey[] STRUCTURE_LOCATION_OCEAN = new MinecraftKey[]{new MinecraftKey("shipwreck/with_mast"), new MinecraftKey("shipwreck/upsidedown_full"), new MinecraftKey("shipwreck/upsidedown_fronthalf"), new MinecraftKey("shipwreck/upsidedown_backhalf"), new MinecraftKey("shipwreck/sideways_full"), new MinecraftKey("shipwreck/sideways_fronthalf"), new MinecraftKey("shipwreck/sideways_backhalf"), new MinecraftKey("shipwreck/rightsideup_full"), new MinecraftKey("shipwreck/rightsideup_fronthalf"), new MinecraftKey("shipwreck/rightsideup_backhalf"), new MinecraftKey("shipwreck/with_mast_degraded"), new MinecraftKey("shipwreck/upsidedown_full_degraded"), new MinecraftKey("shipwreck/upsidedown_fronthalf_degraded"), new MinecraftKey("shipwreck/upsidedown_backhalf_degraded"), new MinecraftKey("shipwreck/sideways_full_degraded"), new MinecraftKey("shipwreck/sideways_fronthalf_degraded"), new MinecraftKey("shipwreck/sideways_backhalf_degraded"), new MinecraftKey("shipwreck/rightsideup_full_degraded"), new MinecraftKey("shipwreck/rightsideup_fronthalf_degraded"), new MinecraftKey("shipwreck/rightsideup_backhalf_degraded")};
    static final Map<String, MinecraftKey> MARKERS_TO_LOOT = Map.of("map_chest", LootTables.SHIPWRECK_MAP, "treasure_chest", LootTables.SHIPWRECK_TREASURE, "supply_chest", LootTables.SHIPWRECK_SUPPLY);

    public static void addPieces(DefinedStructureManager var0, BlockPosition var1, EnumBlockRotation var2, StructurePieceAccessor var3, Random var4, WorldGenFeatureShipwreckConfiguration var5) {
        MinecraftKey var6 = SystemUtils.getRandom(var5.isBeached ? STRUCTURE_LOCATION_BEACHED : STRUCTURE_LOCATION_OCEAN, var4);
        var3.addPiece(new a(var0, var6, var1, var2, var5.isBeached));
    }

    public static class a
    extends DefinedStructurePiece {
        private final boolean isBeached;

        public a(DefinedStructureManager var0, MinecraftKey var1, BlockPosition var2, EnumBlockRotation var3, boolean var4) {
            super(WorldGenFeatureStructurePieceType.SHIPWRECK_PIECE, 0, var0, var1, var1.toString(), a.makeSettings(var3), var2);
            this.isBeached = var4;
        }

        public a(DefinedStructureManager var0, NBTTagCompound var12) {
            super(WorldGenFeatureStructurePieceType.SHIPWRECK_PIECE, var12, var0, var1 -> a.makeSettings(EnumBlockRotation.valueOf(var12.getString("Rot"))));
            this.isBeached = var12.getBoolean("isBeached");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
            super.addAdditionalSaveData(var0, var1);
            var1.putBoolean("isBeached", this.isBeached);
            var1.putString("Rot", this.placeSettings.getRotation().name());
        }

        private static DefinedStructureInfo makeSettings(EnumBlockRotation var0) {
            return new DefinedStructureInfo().setRotation(var0).setMirror(EnumBlockMirror.NONE).setRotationPivot(PIVOT).addProcessor(DefinedStructureProcessorBlockIgnore.STRUCTURE_AND_AIR);
        }

        @Override
        protected void handleDataMarker(String var0, BlockPosition var1, WorldAccess var2, Random var3, StructureBoundingBox var4) {
            MinecraftKey var5 = MARKERS_TO_LOOT.get(var0);
            if (var5 != null) {
                TileEntityLootable.setLootTable(var2, var3, var1.below(), var5);
            }
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, Random var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            int var7 = var0.getMaxBuildHeight();
            int var8 = 0;
            BaseBlockPosition var9 = this.template.getSize();
            HeightMap.Type var10 = this.isBeached ? HeightMap.Type.WORLD_SURFACE_WG : HeightMap.Type.OCEAN_FLOOR_WG;
            int var11 = var9.getX() * var9.getZ();
            if (var11 == 0) {
                var8 = var0.getHeight(var10, this.templatePosition.getX(), this.templatePosition.getZ());
            } else {
                BlockPosition var12 = this.templatePosition.offset(var9.getX() - 1, 0, var9.getZ() - 1);
                for (BlockPosition var14 : BlockPosition.betweenClosed(this.templatePosition, var12)) {
                    int var15 = var0.getHeight(var10, var14.getX(), var14.getZ());
                    var8 += var15;
                    var7 = Math.min(var7, var15);
                }
                var8 /= var11;
            }
            int var12 = this.isBeached ? var7 - var9.getY() / 2 - var3.nextInt(3) : var8;
            this.templatePosition = new BlockPosition(this.templatePosition.getX(), var12, this.templatePosition.getZ());
            super.postProcess(var0, var1, var2, var3, var4, var5, var6);
        }
    }
}

