/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class SurfaceRelativeThresholdFilter
extends PlacementFilter {
    public static final Codec<SurfaceRelativeThresholdFilter> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)HeightMap.Type.CODEC.fieldOf("heightmap").forGetter(var0 -> var0.heightmap), (App)Codec.INT.optionalFieldOf("min_inclusive", (Object)Integer.MIN_VALUE).forGetter(var0 -> var0.minInclusive), (App)Codec.INT.optionalFieldOf("max_inclusive", (Object)Integer.MAX_VALUE).forGetter(var0 -> var0.maxInclusive)).apply((Applicative)var02, SurfaceRelativeThresholdFilter::new));
    private final HeightMap.Type heightmap;
    private final int minInclusive;
    private final int maxInclusive;

    private SurfaceRelativeThresholdFilter(HeightMap.Type var0, int var1, int var2) {
        this.heightmap = var0;
        this.minInclusive = var1;
        this.maxInclusive = var2;
    }

    public static SurfaceRelativeThresholdFilter of(HeightMap.Type var0, int var1, int var2) {
        return new SurfaceRelativeThresholdFilter(var0, var1, var2);
    }

    @Override
    protected boolean shouldPlace(PlacementContext var0, Random var1, BlockPosition var2) {
        long var3 = var0.getHeight(this.heightmap, var2.getX(), var2.getZ());
        long var5 = var3 + (long)this.minInclusive;
        long var7 = var3 + (long)this.maxInclusive;
        return var5 <= (long)var2.getY() && (long)var2.getY() <= var7;
    }

    @Override
    public PlacementModifierType<?> type() {
        return PlacementModifierType.SURFACE_RELATIVE_THRESHOLD_FILTER;
    }
}

