/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.trunkplacers;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacers;

public class TrunkPlacerGiant
extends TrunkPlacer {
    public static final Codec<TrunkPlacerGiant> CODEC = RecordCodecBuilder.create(var0 -> TrunkPlacerGiant.trunkPlacerParts(var0).apply((Applicative)var0, TrunkPlacerGiant::new));

    public TrunkPlacerGiant(int var0, int var1, int var2) {
        super(var0, var1, var2);
    }

    @Override
    protected TrunkPlacers<?> type() {
        return TrunkPlacers.GIANT_TRUNK_PLACER;
    }

    @Override
    public List<WorldGenFoilagePlacer.a> placeTrunk(VirtualLevelReadable var0, BiConsumer<BlockPosition, IBlockData> var1, Random var2, int var3, BlockPosition var4, WorldGenFeatureTreeConfiguration var5) {
        BlockPosition var6 = var4.below();
        TrunkPlacerGiant.setDirtAt(var0, var1, var2, var6, var5);
        TrunkPlacerGiant.setDirtAt(var0, var1, var2, var6.east(), var5);
        TrunkPlacerGiant.setDirtAt(var0, var1, var2, var6.south(), var5);
        TrunkPlacerGiant.setDirtAt(var0, var1, var2, var6.south().east(), var5);
        BlockPosition.MutableBlockPosition var7 = new BlockPosition.MutableBlockPosition();
        for (int var8 = 0; var8 < var3; ++var8) {
            TrunkPlacerGiant.placeLogIfFreeWithOffset(var0, var1, var2, var7, var5, var4, 0, var8, 0);
            if (var8 >= var3 - 1) continue;
            TrunkPlacerGiant.placeLogIfFreeWithOffset(var0, var1, var2, var7, var5, var4, 1, var8, 0);
            TrunkPlacerGiant.placeLogIfFreeWithOffset(var0, var1, var2, var7, var5, var4, 1, var8, 1);
            TrunkPlacerGiant.placeLogIfFreeWithOffset(var0, var1, var2, var7, var5, var4, 0, var8, 1);
        }
        return ImmutableList.of((Object)new WorldGenFoilagePlacer.a(var4.above(var3), 0, true));
    }

    private static void placeLogIfFreeWithOffset(VirtualLevelReadable var0, BiConsumer<BlockPosition, IBlockData> var1, Random var2, BlockPosition.MutableBlockPosition var3, WorldGenFeatureTreeConfiguration var4, BlockPosition var5, int var6, int var7, int var8) {
        var3.setWithOffset(var5, var6, var7, var8);
        TrunkPlacerGiant.placeLogIfFree(var0, var1, var2, var3, var4);
    }
}

