/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.trunkplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.WorldGenTrees;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacers;

public class TrunkPlacerDarkOak
extends TrunkPlacer {
    public static final Codec<TrunkPlacerDarkOak> CODEC = RecordCodecBuilder.create(var0 -> TrunkPlacerDarkOak.trunkPlacerParts(var0).apply((Applicative)var0, TrunkPlacerDarkOak::new));

    public TrunkPlacerDarkOak(int var0, int var1, int var2) {
        super(var0, var1, var2);
    }

    @Override
    protected TrunkPlacers<?> type() {
        return TrunkPlacers.DARK_OAK_TRUNK_PLACER;
    }

    @Override
    public List<WorldGenFoilagePlacer.a> placeTrunk(VirtualLevelReadable var0, BiConsumer<BlockPosition, IBlockData> var1, Random var2, int var3, BlockPosition var4, WorldGenFeatureTreeConfiguration var5) {
        int var18;
        int var17;
        ArrayList var6 = Lists.newArrayList();
        BlockPosition var7 = var4.below();
        TrunkPlacerDarkOak.setDirtAt(var0, var1, var2, var7, var5);
        TrunkPlacerDarkOak.setDirtAt(var0, var1, var2, var7.east(), var5);
        TrunkPlacerDarkOak.setDirtAt(var0, var1, var2, var7.south(), var5);
        TrunkPlacerDarkOak.setDirtAt(var0, var1, var2, var7.south().east(), var5);
        EnumDirection var8 = EnumDirection.EnumDirectionLimit.HORIZONTAL.getRandomDirection(var2);
        int var9 = var3 - var2.nextInt(4);
        int var10 = 2 - var2.nextInt(3);
        int var11 = var4.getX();
        int var12 = var4.getY();
        int var13 = var4.getZ();
        int var14 = var11;
        int var15 = var13;
        int var16 = var12 + var3 - 1;
        for (var17 = 0; var17 < var3; ++var17) {
            BlockPosition var19;
            if (var17 >= var9 && var10 > 0) {
                var14 += var8.getStepX();
                var15 += var8.getStepZ();
                --var10;
            }
            if (!WorldGenTrees.isAirOrLeaves(var0, var19 = new BlockPosition(var14, var18 = var12 + var17, var15))) continue;
            TrunkPlacerDarkOak.placeLog(var0, var1, var2, var19, var5);
            TrunkPlacerDarkOak.placeLog(var0, var1, var2, var19.east(), var5);
            TrunkPlacerDarkOak.placeLog(var0, var1, var2, var19.south(), var5);
            TrunkPlacerDarkOak.placeLog(var0, var1, var2, var19.east().south(), var5);
        }
        var6.add(new WorldGenFoilagePlacer.a(new BlockPosition(var14, var16, var15), 0, true));
        for (var17 = -1; var17 <= 2; ++var17) {
            for (var18 = -1; var18 <= 2; ++var18) {
                if (var17 >= 0 && var17 <= 1 && var18 >= 0 && var18 <= 1 || var2.nextInt(3) > 0) continue;
                int var19 = var2.nextInt(3) + 2;
                for (int var20 = 0; var20 < var19; ++var20) {
                    TrunkPlacerDarkOak.placeLog(var0, var1, var2, new BlockPosition(var11 + var17, var16 - var20 - 1, var13 + var18), var5);
                }
                var6.add(new WorldGenFoilagePlacer.a(new BlockPosition(var14 + var17, var16, var15 + var18), 0, false));
            }
        }
        return var6;
    }
}

