/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.structures;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructurePoolEmpty;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructurePoolFeature;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructurePoolLegacySingle;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructurePoolList;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructurePoolSingle;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructurePools;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;

public abstract class WorldGenFeatureDefinedStructurePoolStructure {
    public static final Codec<WorldGenFeatureDefinedStructurePoolStructure> CODEC = IRegistry.STRUCTURE_POOL_ELEMENT.byNameCodec().dispatch("element_type", WorldGenFeatureDefinedStructurePoolStructure::getType, WorldGenFeatureDefinedStructurePools::codec);
    @Nullable
    private volatile WorldGenFeatureDefinedStructurePoolTemplate.Matching projection;

    protected static <E extends WorldGenFeatureDefinedStructurePoolStructure> RecordCodecBuilder<E, WorldGenFeatureDefinedStructurePoolTemplate.Matching> projectionCodec() {
        return WorldGenFeatureDefinedStructurePoolTemplate.Matching.CODEC.fieldOf("projection").forGetter(WorldGenFeatureDefinedStructurePoolStructure::getProjection);
    }

    protected WorldGenFeatureDefinedStructurePoolStructure(WorldGenFeatureDefinedStructurePoolTemplate.Matching var0) {
        this.projection = var0;
    }

    public abstract BaseBlockPosition getSize(DefinedStructureManager var1, EnumBlockRotation var2);

    public abstract List<DefinedStructure.BlockInfo> getShuffledJigsawBlocks(DefinedStructureManager var1, BlockPosition var2, EnumBlockRotation var3, Random var4);

    public abstract StructureBoundingBox getBoundingBox(DefinedStructureManager var1, BlockPosition var2, EnumBlockRotation var3);

    public abstract boolean place(DefinedStructureManager var1, GeneratorAccessSeed var2, StructureManager var3, ChunkGenerator var4, BlockPosition var5, BlockPosition var6, EnumBlockRotation var7, StructureBoundingBox var8, Random var9, boolean var10);

    public abstract WorldGenFeatureDefinedStructurePools<?> getType();

    public void handleDataMarker(GeneratorAccess var0, DefinedStructure.BlockInfo var1, BlockPosition var2, EnumBlockRotation var3, Random var4, StructureBoundingBox var5) {
    }

    public WorldGenFeatureDefinedStructurePoolStructure setProjection(WorldGenFeatureDefinedStructurePoolTemplate.Matching var0) {
        this.projection = var0;
        return this;
    }

    public WorldGenFeatureDefinedStructurePoolTemplate.Matching getProjection() {
        WorldGenFeatureDefinedStructurePoolTemplate.Matching var0 = this.projection;
        if (var0 == null) {
            throw new IllegalStateException();
        }
        return var0;
    }

    public int getGroundLevelDelta() {
        return 1;
    }

    public static Function<WorldGenFeatureDefinedStructurePoolTemplate.Matching, WorldGenFeatureDefinedStructurePoolEmpty> empty() {
        return var0 -> WorldGenFeatureDefinedStructurePoolEmpty.INSTANCE;
    }

    public static Function<WorldGenFeatureDefinedStructurePoolTemplate.Matching, WorldGenFeatureDefinedStructurePoolLegacySingle> legacy(String var0) {
        return var1 -> new WorldGenFeatureDefinedStructurePoolLegacySingle((Either<MinecraftKey, DefinedStructure>)Either.left((Object)new MinecraftKey(var0)), () -> ProcessorLists.EMPTY, (WorldGenFeatureDefinedStructurePoolTemplate.Matching)var1);
    }

    public static Function<WorldGenFeatureDefinedStructurePoolTemplate.Matching, WorldGenFeatureDefinedStructurePoolLegacySingle> legacy(String var0, ProcessorList var1) {
        return var2 -> new WorldGenFeatureDefinedStructurePoolLegacySingle((Either<MinecraftKey, DefinedStructure>)Either.left((Object)new MinecraftKey(var0)), () -> var1, (WorldGenFeatureDefinedStructurePoolTemplate.Matching)var2);
    }

    public static Function<WorldGenFeatureDefinedStructurePoolTemplate.Matching, WorldGenFeatureDefinedStructurePoolSingle> single(String var0) {
        return var1 -> new WorldGenFeatureDefinedStructurePoolSingle((Either<MinecraftKey, DefinedStructure>)Either.left((Object)new MinecraftKey(var0)), () -> ProcessorLists.EMPTY, (WorldGenFeatureDefinedStructurePoolTemplate.Matching)var1);
    }

    public static Function<WorldGenFeatureDefinedStructurePoolTemplate.Matching, WorldGenFeatureDefinedStructurePoolSingle> single(String var0, ProcessorList var1) {
        return var2 -> new WorldGenFeatureDefinedStructurePoolSingle((Either<MinecraftKey, DefinedStructure>)Either.left((Object)new MinecraftKey(var0)), () -> var1, (WorldGenFeatureDefinedStructurePoolTemplate.Matching)var2);
    }

    public static Function<WorldGenFeatureDefinedStructurePoolTemplate.Matching, WorldGenFeatureDefinedStructurePoolFeature> feature(PlacedFeature var0) {
        return var1 -> new WorldGenFeatureDefinedStructurePoolFeature(() -> var0, (WorldGenFeatureDefinedStructurePoolTemplate.Matching)var1);
    }

    public static Function<WorldGenFeatureDefinedStructurePoolTemplate.Matching, WorldGenFeatureDefinedStructurePoolList> list(List<Function<WorldGenFeatureDefinedStructurePoolTemplate.Matching, ? extends WorldGenFeatureDefinedStructurePoolStructure>> var0) {
        return var12 -> new WorldGenFeatureDefinedStructurePoolList(var0.stream().map(var1 -> (WorldGenFeatureDefinedStructurePoolStructure)var1.apply(var12)).collect(Collectors.toList()), (WorldGenFeatureDefinedStructurePoolTemplate.Matching)var12);
    }
}

