/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.structures;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.BlockPropertyJigsawOrientation;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.BlockJigsaw;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructurePools;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;

public class WorldGenFeatureDefinedStructurePoolFeature
extends WorldGenFeatureDefinedStructurePoolStructure {
    public static final Codec<WorldGenFeatureDefinedStructurePoolFeature> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)PlacedFeature.CODEC.fieldOf("feature").forGetter(var0 -> var0.feature), WorldGenFeatureDefinedStructurePoolFeature.projectionCodec()).apply((Applicative)var02, WorldGenFeatureDefinedStructurePoolFeature::new));
    private final Supplier<PlacedFeature> feature;
    private final NBTTagCompound defaultJigsawNBT;

    protected WorldGenFeatureDefinedStructurePoolFeature(Supplier<PlacedFeature> var0, WorldGenFeatureDefinedStructurePoolTemplate.Matching var1) {
        super(var1);
        this.feature = var0;
        this.defaultJigsawNBT = this.fillDefaultJigsawNBT();
    }

    private NBTTagCompound fillDefaultJigsawNBT() {
        NBTTagCompound var0 = new NBTTagCompound();
        var0.putString("name", "minecraft:bottom");
        var0.putString("final_state", "minecraft:air");
        var0.putString("pool", "minecraft:empty");
        var0.putString("target", "minecraft:empty");
        var0.putString("joint", TileEntityJigsaw.JointType.ROLLABLE.getSerializedName());
        return var0;
    }

    @Override
    public BaseBlockPosition getSize(DefinedStructureManager var0, EnumBlockRotation var1) {
        return BaseBlockPosition.ZERO;
    }

    @Override
    public List<DefinedStructure.BlockInfo> getShuffledJigsawBlocks(DefinedStructureManager var0, BlockPosition var1, EnumBlockRotation var2, Random var3) {
        ArrayList var4 = Lists.newArrayList();
        var4.add(new DefinedStructure.BlockInfo(var1, (IBlockData)Blocks.JIGSAW.defaultBlockState().setValue(BlockJigsaw.ORIENTATION, BlockPropertyJigsawOrientation.fromFrontAndTop(EnumDirection.DOWN, EnumDirection.SOUTH)), this.defaultJigsawNBT));
        return var4;
    }

    @Override
    public StructureBoundingBox getBoundingBox(DefinedStructureManager var0, BlockPosition var1, EnumBlockRotation var2) {
        BaseBlockPosition var3 = this.getSize(var0, var2);
        return new StructureBoundingBox(var1.getX(), var1.getY(), var1.getZ(), var1.getX() + var3.getX(), var1.getY() + var3.getY(), var1.getZ() + var3.getZ());
    }

    @Override
    public boolean place(DefinedStructureManager var0, GeneratorAccessSeed var1, StructureManager var2, ChunkGenerator var3, BlockPosition var4, BlockPosition var5, EnumBlockRotation var6, StructureBoundingBox var7, Random var8, boolean var9) {
        return this.feature.get().place(var1, var3, var8, var4);
    }

    @Override
    public WorldGenFeatureDefinedStructurePools<?> getType() {
        return WorldGenFeatureDefinedStructurePools.FEATURE;
    }

    public String toString() {
        return "Feature[" + this.feature.get() + "]";
    }
}

