/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IWorldWriter;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacer;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.VoxelShapeBitSet;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;

public class WorldGenTrees
extends WorldGenerator<WorldGenFeatureTreeConfiguration> {
    private static final int BLOCK_UPDATE_FLAGS = 19;

    public WorldGenTrees(Codec<WorldGenFeatureTreeConfiguration> var0) {
        super(var0);
    }

    public static boolean isFree(VirtualLevelReadable var02, BlockPosition var1) {
        return WorldGenTrees.validTreePos(var02, var1) || var02.isStateAtPosition(var1, var0 -> var0.is(TagsBlock.LOGS));
    }

    private static boolean isVine(VirtualLevelReadable var02, BlockPosition var1) {
        return var02.isStateAtPosition(var1, var0 -> var0.is(Blocks.VINE));
    }

    private static boolean isBlockWater(VirtualLevelReadable var02, BlockPosition var1) {
        return var02.isStateAtPosition(var1, var0 -> var0.is(Blocks.WATER));
    }

    public static boolean isAirOrLeaves(VirtualLevelReadable var02, BlockPosition var1) {
        return var02.isStateAtPosition(var1, var0 -> var0.isAir() || var0.is(TagsBlock.LEAVES));
    }

    private static boolean isReplaceablePlant(VirtualLevelReadable var02, BlockPosition var1) {
        return var02.isStateAtPosition(var1, var0 -> {
            Material var1 = var0.getMaterial();
            return var1 == Material.REPLACEABLE_PLANT;
        });
    }

    private static void setBlockKnownShape(IWorldWriter var0, BlockPosition var1, IBlockData var2) {
        var0.setBlock(var1, var2, 19);
    }

    public static boolean validTreePos(VirtualLevelReadable var0, BlockPosition var1) {
        return WorldGenTrees.isAirOrLeaves(var0, var1) || WorldGenTrees.isReplaceablePlant(var0, var1) || WorldGenTrees.isBlockWater(var0, var1);
    }

    private boolean doPlace(GeneratorAccessSeed var0, Random var1, BlockPosition var2, BiConsumer<BlockPosition, IBlockData> var3, BiConsumer<BlockPosition, IBlockData> var4, WorldGenFeatureTreeConfiguration var5) {
        int var6 = var5.trunkPlacer.getTreeHeight(var1);
        int var72 = var5.foliagePlacer.foliageHeight(var1, var6, var5);
        int var8 = var6 - var72;
        int var9 = var5.foliagePlacer.foliageRadius(var1, var8);
        if (var2.getY() < var0.getMinBuildHeight() + 1 || var2.getY() + var6 + 1 > var0.getMaxBuildHeight()) {
            return false;
        }
        OptionalInt var10 = var5.minimumSize.minClippedHeight();
        int var11 = this.getMaxFreeTreeHeight(var0, var6, var2, var5);
        if (!(var11 >= var6 || var10.isPresent() && var11 >= var10.getAsInt())) {
            return false;
        }
        List<WorldGenFoilagePlacer.a> var12 = var5.trunkPlacer.placeTrunk(var0, var3, var1, var11, var2, var5);
        var12.forEach(var7 -> var0.foliagePlacer.createFoliage(var0, var4, var1, var5, var11, (WorldGenFoilagePlacer.a)var7, var72, var9));
        return true;
    }

    private int getMaxFreeTreeHeight(VirtualLevelReadable var0, int var1, BlockPosition var2, WorldGenFeatureTreeConfiguration var3) {
        BlockPosition.MutableBlockPosition var4 = new BlockPosition.MutableBlockPosition();
        for (int var5 = 0; var5 <= var1 + 1; ++var5) {
            int var6 = var3.minimumSize.getSizeAtHeight(var1, var5);
            for (int var7 = -var6; var7 <= var6; ++var7) {
                for (int var8 = -var6; var8 <= var6; ++var8) {
                    var4.setWithOffset(var2, var7, var5, var8);
                    if (WorldGenTrees.isFree(var0, var4) && (var3.ignoreVines || !WorldGenTrees.isVine(var0, var4))) continue;
                    return var5 - 2;
                }
            }
        }
        return var1;
    }

    @Override
    protected void setBlock(IWorldWriter var0, BlockPosition var1, IBlockData var2) {
        WorldGenTrees.setBlockKnownShape(var0, var1, var2);
    }

    @Override
    public final boolean place(FeaturePlaceContext<WorldGenFeatureTreeConfiguration> var0) {
        GeneratorAccessSeed var1 = var0.level();
        Random var22 = var0.random();
        BlockPosition var32 = var0.origin();
        WorldGenFeatureTreeConfiguration var4 = var0.config();
        HashSet var52 = Sets.newHashSet();
        HashSet var6 = Sets.newHashSet();
        HashSet var7 = Sets.newHashSet();
        BiConsumer<BlockPosition, IBlockData> var8 = (var2, var3) -> {
            var52.add(var2.immutable());
            var1.setBlock((BlockPosition)var2, (IBlockData)var3, 19);
        };
        BiConsumer<BlockPosition, IBlockData> var9 = (var2, var3) -> {
            var6.add(var2.immutable());
            var1.setBlock((BlockPosition)var2, (IBlockData)var3, 19);
        };
        BiConsumer<BlockPosition, IBlockData> var10 = (var2, var3) -> {
            var7.add(var2.immutable());
            var1.setBlock((BlockPosition)var2, (IBlockData)var3, 19);
        };
        boolean var11 = this.doPlace(var1, var22, var32, var8, var9, var4);
        if (!var11 || var52.isEmpty() && var6.isEmpty()) {
            return false;
        }
        if (!var4.decorators.isEmpty()) {
            ArrayList var12 = Lists.newArrayList((Iterable)var52);
            ArrayList var13 = Lists.newArrayList((Iterable)var6);
            var12.sort(Comparator.comparingInt(BaseBlockPosition::getY));
            var13.sort(Comparator.comparingInt(BaseBlockPosition::getY));
            var4.decorators.forEach(var5 -> var5.place(var1, var10, var22, var12, var13));
        }
        return StructureBoundingBox.encapsulatingPositions(Iterables.concat((Iterable)var52, (Iterable)var6, (Iterable)var7)).map(var3 -> {
            VoxelShapeDiscrete var4 = WorldGenTrees.updateLeaves(var1, var3, var52, var7);
            DefinedStructure.updateShapeAtEdge(var1, 3, var4, var3.minX(), var3.minY(), var3.minZ());
            return true;
        }).orElse(false);
    }

    private static VoxelShapeDiscrete updateLeaves(GeneratorAccess var0, StructureBoundingBox var1, Set<BlockPosition> var2, Set<BlockPosition> var3) {
        ArrayList var4 = Lists.newArrayList();
        VoxelShapeBitSet var5 = new VoxelShapeBitSet(var1.getXSpan(), var1.getYSpan(), var1.getZSpan());
        int var6 = 6;
        for (int var7 = 0; var7 < 6; ++var7) {
            var4.add(Sets.newHashSet());
        }
        BlockPosition.MutableBlockPosition var7 = new BlockPosition.MutableBlockPosition();
        for (Object var9 : Lists.newArrayList(var3)) {
            if (!var1.isInside((BaseBlockPosition)var9)) continue;
            ((VoxelShapeDiscrete)var5).fill(((BaseBlockPosition)var9).getX() - var1.minX(), ((BaseBlockPosition)var9).getY() - var1.minY(), ((BaseBlockPosition)var9).getZ() - var1.minZ());
        }
        for (Object var9 : Lists.newArrayList(var2)) {
            if (var1.isInside((BaseBlockPosition)var9)) {
                ((VoxelShapeDiscrete)var5).fill(((BaseBlockPosition)var9).getX() - var1.minX(), ((BaseBlockPosition)var9).getY() - var1.minY(), ((BaseBlockPosition)var9).getZ() - var1.minZ());
            }
            for (EnumDirection var13 : EnumDirection.values()) {
                IBlockData var14;
                var7.setWithOffset((BaseBlockPosition)var9, var13);
                if (var2.contains(var7) || !(var14 = var0.getBlockState(var7)).hasProperty(BlockProperties.DISTANCE)) continue;
                ((Set)var4.get(0)).add(var7.immutable());
                WorldGenTrees.setBlockKnownShape(var0, var7, (IBlockData)var14.setValue(BlockProperties.DISTANCE, 1));
                if (!var1.isInside(var7)) continue;
                ((VoxelShapeDiscrete)var5).fill(var7.getX() - var1.minX(), var7.getY() - var1.minY(), var7.getZ() - var1.minZ());
            }
        }
        for (int var8 = 1; var8 < 6; ++var8) {
            Object var9;
            var9 = (Set)var4.get(var8 - 1);
            Set var10 = (Set)var4.get(var8);
            Iterator iterator = var9.iterator();
            while (iterator.hasNext()) {
                BlockPosition var12 = (BlockPosition)iterator.next();
                if (var1.isInside(var12)) {
                    ((VoxelShapeDiscrete)var5).fill(var12.getX() - var1.minX(), var12.getY() - var1.minY(), var12.getZ() - var1.minZ());
                }
                for (EnumDirection var16 : EnumDirection.values()) {
                    int var18;
                    IBlockData var17;
                    var7.setWithOffset((BaseBlockPosition)var12, var16);
                    if (var9.contains(var7) || var10.contains(var7) || !(var17 = var0.getBlockState(var7)).hasProperty(BlockProperties.DISTANCE) || (var18 = var17.getValue(BlockProperties.DISTANCE).intValue()) <= var8 + 1) continue;
                    IBlockData var19 = (IBlockData)var17.setValue(BlockProperties.DISTANCE, var8 + 1);
                    WorldGenTrees.setBlockKnownShape(var0, var7, var19);
                    if (var1.isInside(var7)) {
                        ((VoxelShapeDiscrete)var5).fill(var7.getX() - var1.minX(), var7.getY() - var1.minY(), var7.getZ() - var1.minZ());
                    }
                    var10.add(var7.immutable());
                }
            }
        }
        return var5;
    }
}

