/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.WorldGenMonumentPieces;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class WorldGenMonument
extends StructureGenerator<WorldGenFeatureEmptyConfiguration> {
    public static final WeightedRandomList<BiomeSettingsMobs.c> MONUMENT_ENEMIES = WeightedRandomList.create((WeightedEntry[])new BiomeSettingsMobs.c[]{new BiomeSettingsMobs.c(EntityTypes.GUARDIAN, 1, 2, 4)});

    public WorldGenMonument(Codec<WorldGenFeatureEmptyConfiguration> var0) {
        super(var0, PieceGeneratorSupplier.simple(WorldGenMonument::checkLocation, WorldGenMonument::generatePieces));
    }

    @Override
    protected boolean linearSeparation() {
        return false;
    }

    private static boolean checkLocation(PieceGeneratorSupplier.a<WorldGenFeatureEmptyConfiguration> var0) {
        int var1 = var0.chunkPos().getBlockX(9);
        int var2 = var0.chunkPos().getBlockZ(9);
        Set<BiomeBase> var3 = var0.biomeSource().getBiomesWithin(var1, var0.chunkGenerator().getSeaLevel(), var2, 29, var0.chunkGenerator().climateSampler());
        for (BiomeBase var5 : var3) {
            if (var5.getBiomeCategory() == BiomeBase.Geography.OCEAN || var5.getBiomeCategory() == BiomeBase.Geography.RIVER) continue;
            return false;
        }
        return var0.validBiomeOnTop(HeightMap.Type.OCEAN_FLOOR_WG);
    }

    private static StructurePiece createTopPiece(ChunkCoordIntPair var0, SeededRandom var1) {
        int var2 = var0.getMinBlockX() - 29;
        int var3 = var0.getMinBlockZ() - 29;
        EnumDirection var4 = EnumDirection.EnumDirectionLimit.HORIZONTAL.getRandomDirection(var1);
        return new WorldGenMonumentPieces.WorldGenMonumentPiece1(var1, var2, var3, var4);
    }

    private static void generatePieces(StructurePiecesBuilder var0, PieceGenerator.a<WorldGenFeatureEmptyConfiguration> var1) {
        var0.addPiece(WorldGenMonument.createTopPiece(var1.chunkPos(), var1.random()));
    }

    public static PiecesContainer regeneratePiecesAfterLoad(ChunkCoordIntPair var0, long var1, PiecesContainer var3) {
        if (var3.isEmpty()) {
            return var3;
        }
        SeededRandom var4 = new SeededRandom(new LegacyRandomSource(RandomSupport.seedUniquifier()));
        var4.setLargeFeatureSeed(var1, var0.x, var0.z);
        StructurePiece var5 = var3.pieces().get(0);
        StructureBoundingBox var6 = var5.getBoundingBox();
        int var7 = var6.minX();
        int var8 = var6.minZ();
        EnumDirection var9 = EnumDirection.EnumDirectionLimit.HORIZONTAL.getRandomDirection(var4);
        EnumDirection var10 = Objects.requireNonNullElse(var5.getOrientation(), var9);
        WorldGenMonumentPieces.WorldGenMonumentPiece1 var11 = new WorldGenMonumentPieces.WorldGenMonumentPiece1(var4, var7, var8, var10);
        StructurePiecesBuilder var12 = new StructurePiecesBuilder();
        var12.addPiece(var11);
        return var12.build();
    }
}

