/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCoralFanWallAbstract;
import net.minecraft.world.level.block.BlockSeaPickle;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;

public abstract class WorldGenFeatureCoral
extends WorldGenerator<WorldGenFeatureEmptyConfiguration> {
    public WorldGenFeatureCoral(Codec<WorldGenFeatureEmptyConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<WorldGenFeatureEmptyConfiguration> var0) {
        Random var1 = var0.random();
        GeneratorAccessSeed var2 = var0.level();
        BlockPosition var3 = var0.origin();
        IBlockData var4 = ((Block)TagsBlock.CORAL_BLOCKS.getRandomElement(var1)).defaultBlockState();
        return this.placeFeature(var2, var1, var3, var4);
    }

    protected abstract boolean placeFeature(GeneratorAccess var1, Random var2, BlockPosition var3, IBlockData var4);

    protected boolean placeCoralBlock(GeneratorAccess var0, Random var1, BlockPosition var2, IBlockData var3) {
        BlockPosition var4 = var2.above();
        IBlockData var5 = var0.getBlockState(var2);
        if (!var5.is(Blocks.WATER) && !var5.is(TagsBlock.CORALS) || !var0.getBlockState(var4).is(Blocks.WATER)) {
            return false;
        }
        var0.setBlock(var2, var3, 3);
        if (var1.nextFloat() < 0.25f) {
            var0.setBlock(var4, ((Block)TagsBlock.CORALS.getRandomElement(var1)).defaultBlockState(), 2);
        } else if (var1.nextFloat() < 0.05f) {
            var0.setBlock(var4, (IBlockData)Blocks.SEA_PICKLE.defaultBlockState().setValue(BlockSeaPickle.PICKLES, var1.nextInt(4) + 1), 2);
        }
        for (EnumDirection var7 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition var8;
            if (!(var1.nextFloat() < 0.2f) || !var0.getBlockState(var8 = var2.relative(var7)).is(Blocks.WATER)) continue;
            IBlockData var9 = ((Block)TagsBlock.WALL_CORALS.getRandomElement(var1)).defaultBlockState();
            if (var9.hasProperty(BlockCoralFanWallAbstract.FACING)) {
                var9 = (IBlockData)var9.setValue(BlockCoralFanWallAbstract.FACING, var7);
            }
            var0.setBlock(var8, var9, 2);
        }
        return true;
    }
}

